/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import org.springframework.util.Assert;
import org.springframework.web.util.HtmlCharacterEntityDecoder;
import org.springframework.web.util.HtmlCharacterEntityReferences;

public abstract class HtmlUtils {
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();

    public static String htmlEscape(String input2) {
        return HtmlUtils.htmlEscape(input2, "ISO-8859-1");
    }

    public static String htmlEscape(String input2, String encoding) {
        Assert.notNull((Object)input2, "Input is required");
        Assert.notNull((Object)encoding, "Encoding is required");
        StringBuilder escaped = new StringBuilder(input2.length() * 2);
        for (int i = 0; i < input2.length(); ++i) {
            char character = input2.charAt(i);
            String reference = characterEntityReferences.convertToReference(character, encoding);
            if (reference != null) {
                escaped.append(reference);
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeDecimal(String input2) {
        return HtmlUtils.htmlEscapeDecimal(input2, "ISO-8859-1");
    }

    public static String htmlEscapeDecimal(String input2, String encoding) {
        Assert.notNull((Object)input2, "Input is required");
        Assert.notNull((Object)encoding, "Encoding is required");
        StringBuilder escaped = new StringBuilder(input2.length() * 2);
        for (int i = 0; i < input2.length(); ++i) {
            char character = input2.charAt(i);
            if (characterEntityReferences.isMappedToReference(character, encoding)) {
                escaped.append("&#");
                escaped.append((int)character);
                escaped.append(';');
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlEscapeHex(String input2) {
        return HtmlUtils.htmlEscapeHex(input2, "ISO-8859-1");
    }

    public static String htmlEscapeHex(String input2, String encoding) {
        Assert.notNull((Object)input2, "Input is required");
        Assert.notNull((Object)encoding, "Encoding is required");
        StringBuilder escaped = new StringBuilder(input2.length() * 2);
        for (int i = 0; i < input2.length(); ++i) {
            char character = input2.charAt(i);
            if (characterEntityReferences.isMappedToReference(character, encoding)) {
                escaped.append("&#x");
                escaped.append(Integer.toString(character, 16));
                escaped.append(';');
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String htmlUnescape(String input2) {
        return new HtmlCharacterEntityDecoder(characterEntityReferences, input2).decode();
    }
}

