/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

public final class ArgUtil {
    private ArgUtil() {
    }

    public static boolean convertToBoolean(String prop, Object value2) {
        if (value2 == null) {
            return false;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            throw new IllegalArgumentException("Invalid String value for property '" + prop + "': expected Boolean value.");
        }
        throw new IllegalArgumentException("Invalid value type (" + value2.getClass() + ") for property '" + prop + "': expected Boolean value.");
    }

    public static int convertToInt(String prop, Object value2, int minValue) {
        int i;
        if (value2 == null) {
            i = 0;
        } else if (value2 instanceof Number) {
            long l = ((Number)value2).longValue();
            i = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (l < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)l);
        } else if (value2 instanceof String) {
            try {
                i = Integer.parseInt((String)value2);
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Invalid String value for property '" + prop + "': expected a number (Integer).");
            }
        } else {
            throw new IllegalArgumentException("Invalid value type (" + value2.getClass() + ") for property '" + prop + "': expected Integer value.");
        }
        if (i < minValue) {
            throw new IllegalArgumentException("Invalid numeric value (" + i + ") for property '" + prop + "': minimum is " + minValue + ".");
        }
        return i;
    }

    public static long convertToLong(String prop, Object value2, long minValue) {
        long i;
        if (value2 == null) {
            i = 0L;
        } else if (value2 instanceof Number) {
            i = ((Number)value2).longValue();
        } else if (value2 instanceof String) {
            try {
                i = Long.parseLong((String)value2);
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Invalid String value for property '" + prop + "': expected a number (Long).");
            }
        } else {
            throw new IllegalArgumentException("Invalid value type (" + value2.getClass() + ") for property '" + prop + "': expected Long value.");
        }
        if (i < minValue) {
            throw new IllegalArgumentException("Invalid numeric value (" + i + ") for property '" + prop + "': minimum is " + minValue + ".");
        }
        return i;
    }
}

