/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.model.parameter.multivalued;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

final class PrimitiveMapper {
    static final Map<Class, Class> primitiveToClassMap = PrimitiveMapper.getPrimitiveToClassMap();
    static final Map<Class, Object> primitiveToDefaultValueMap = PrimitiveMapper.getPrimitiveToDefaultValueMap();

    PrimitiveMapper() {
    }

    private static Map<Class, Class> getPrimitiveToClassMap() {
        WeakHashMap<Class<Comparable<Boolean>>, Class<Double>> m3 = new WeakHashMap<Class<Comparable<Boolean>>, Class<Double>>();
        m3.put(Boolean.TYPE, Boolean.class);
        m3.put(Byte.TYPE, Byte.class);
        m3.put(Short.TYPE, Short.class);
        m3.put(Integer.TYPE, Integer.class);
        m3.put(Long.TYPE, Long.class);
        m3.put(Float.TYPE, Float.class);
        m3.put(Double.TYPE, Double.class);
        return Collections.unmodifiableMap(m3);
    }

    private static Map<Class, Object> getPrimitiveToDefaultValueMap() {
        WeakHashMap<Class<Double>, Comparable<Boolean>> m3 = new WeakHashMap<Class<Double>, Comparable<Boolean>>();
        m3.put(Boolean.class, Boolean.valueOf(false));
        m3.put(Byte.class, Byte.valueOf((byte)0));
        m3.put(Short.class, Short.valueOf((short)0));
        m3.put(Integer.class, Integer.valueOf(0));
        m3.put(Long.class, Long.valueOf(0L));
        m3.put(Float.class, Float.valueOf(0.0f));
        m3.put(Double.class, Double.valueOf(0.0));
        return Collections.unmodifiableMap(m3);
    }
}

