/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;

public class PersistenceProviderResolverHolder {
    private static PersistenceProviderResolver singleton = new DefaultPersistenceProviderResolver();

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return singleton;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver resolver) {
        singleton = resolver == null ? new DefaultPersistenceProviderResolver() : resolver;
    }

    private static class DefaultPersistenceProviderResolver
    implements PersistenceProviderResolver {
        private volatile HashMap<CacheKey, PersistenceProviderReference> providers = new HashMap();
        private static final ReferenceQueue referenceQueue = new ReferenceQueue();
        private static final String LOGGER_SUBSYSTEM = "javax.persistence.spi";
        private Logger logger;
        private static final String SERVICE_PROVIDER_FILE = "META-INF/services/javax.persistence.spi.PersistenceProvider";
        private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

        private DefaultPersistenceProviderResolver() {
        }

        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            this.processQueue();
            ClassLoader loader = DefaultPersistenceProviderResolver.getContextClassLoader();
            CacheKey cacheKey = new CacheKey(loader);
            PersistenceProviderReference providersReferent = this.providers.get(cacheKey);
            ArrayList<PersistenceProvider> loadedProviders = null;
            if (providersReferent != null) {
                loadedProviders = (ArrayList<PersistenceProvider>)providersReferent.get();
            }
            if (loadedProviders == null) {
                Collection<ProviderName> providerNames = this.getProviderNames(loader);
                loadedProviders = new ArrayList<PersistenceProvider>();
                for (ProviderName providerName : providerNames) {
                    try {
                        PersistenceProvider provider = (PersistenceProvider)loader.loadClass(providerName.getName()).newInstance();
                        loadedProviders.add(provider);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.log(Level.FINEST, cnfe + ": " + providerName);
                    }
                    catch (InstantiationException ie) {
                        this.log(Level.FINEST, ie + ": " + providerName);
                    }
                    catch (IllegalAccessException iae) {
                        this.log(Level.FINEST, iae + ": " + providerName);
                    }
                    catch (ClassCastException cce) {
                        this.log(Level.FINEST, cce + ": " + providerName);
                    }
                }
                if (loadedProviders.isEmpty() && !providerNames.isEmpty()) {
                    this.log(Level.WARNING, "No valid providers found using:");
                    for (ProviderName name : providerNames) {
                        this.log(Level.WARNING, name.toString());
                    }
                }
                providersReferent = new PersistenceProviderReference(loadedProviders, referenceQueue, cacheKey);
                this.providers.put(cacheKey, providersReferent);
            }
            return loadedProviders;
        }

        private void processQueue() {
            CacheKeyReference ref;
            while ((ref = (CacheKeyReference)((Object)referenceQueue.poll())) != null) {
                this.providers.remove(ref.getCacheKey());
            }
        }

        private static ClassLoader getContextClassLoader() {
            if (System.getSecurityManager() == null) {
                return Thread.currentThread().getContextClassLoader();
            }
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }

        private void log(Level level, String message) {
            if (this.logger == null) {
                this.logger = Logger.getLogger(LOGGER_SUBSYSTEM);
            }
            this.logger.log(level, "javax.persistence.spi::" + message);
        }

        private Collection<ProviderName> getProviderNames(ClassLoader loader) {
            Enumeration<URL> resources = null;
            try {
                resources = loader.getResources(SERVICE_PROVIDER_FILE);
            }
            catch (IOException ioe) {
                throw new PersistenceException("IOException caught: " + loader + ".getResources(" + SERVICE_PROVIDER_FILE + ")", ioe);
            }
            ArrayList<ProviderName> providerNames = new ArrayList<ProviderName>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                this.addProviderNames(url, providerNames);
            }
            return providerNames;
        }

        private void addProviderNames(URL url, Collection<ProviderName> providerNames) {
            InputStream in = null;
            try {
                try {
                    String line;
                    in = url.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    while ((line = reader.readLine()) != null) {
                        Matcher m3 = nonCommentPattern.matcher(line = line.trim());
                        if (!m3.find()) continue;
                        providerNames.add(new ProviderName(m3.group().trim(), url));
                    }
                }
                catch (IOException ioe) {
                    throw new PersistenceException("IOException caught reading: " + url, ioe);
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public void clearCachedProviders() {
            this.providers.clear();
        }

        private class CacheKey
        implements Cloneable {
            private LoaderReference loaderRef;
            private int hashCodeCache;

            CacheKey(ClassLoader loader) {
                this.loaderRef = loader == null ? null : new LoaderReference(loader, referenceQueue, this);
                this.calculateHashCode();
            }

            ClassLoader getLoader() {
                return this.loaderRef != null ? (ClassLoader)this.loaderRef.get() : null;
            }

            public boolean equals(Object other) {
                CacheKey otherEntry;
                block6: {
                    if (this == other) {
                        return true;
                    }
                    otherEntry = (CacheKey)other;
                    if (this.hashCodeCache == otherEntry.hashCodeCache) break block6;
                    return false;
                }
                try {
                    if (this.loaderRef == null) {
                        return otherEntry.loaderRef == null;
                    }
                    ClassLoader loader = (ClassLoader)this.loaderRef.get();
                    return otherEntry.loaderRef != null && loader != null && loader == otherEntry.loaderRef.get();
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (ClassCastException classCastException) {}
                return false;
            }

            public int hashCode() {
                return this.hashCodeCache;
            }

            private void calculateHashCode() {
                ClassLoader loader = this.getLoader();
                if (loader != null) {
                    this.hashCodeCache = loader.hashCode();
                }
            }

            public Object clone() {
                try {
                    CacheKey clone2 = (CacheKey)super.clone();
                    if (this.loaderRef != null) {
                        clone2.loaderRef = new LoaderReference((ClassLoader)this.loaderRef.get(), referenceQueue, clone2);
                    }
                    return clone2;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new InternalError();
                }
            }

            public String toString() {
                return "CacheKey[" + this.getLoader() + ")]";
            }
        }

        private static interface CacheKeyReference {
            public CacheKey getCacheKey();
        }

        private class LoaderReference
        extends WeakReference<ClassLoader>
        implements CacheKeyReference {
            private CacheKey cacheKey;

            LoaderReference(ClassLoader referent, ReferenceQueue q, CacheKey key) {
                super(referent, q);
                this.cacheKey = key;
            }

            @Override
            public CacheKey getCacheKey() {
                return this.cacheKey;
            }
        }

        private class PersistenceProviderReference
        extends SoftReference<List<PersistenceProvider>>
        implements CacheKeyReference {
            private CacheKey cacheKey;

            PersistenceProviderReference(List<PersistenceProvider> referent, ReferenceQueue q, CacheKey key) {
                super(referent, q);
                this.cacheKey = key;
            }

            @Override
            public CacheKey getCacheKey() {
                return this.cacheKey;
            }
        }

        private class ProviderName {
            private String name;
            private URL source;

            public ProviderName(String name, URL sourceURL) {
                this.name = name;
                this.source = sourceURL;
            }

            public String getName() {
                return this.name;
            }

            public URL getSource() {
                return this.source;
            }

            public String toString() {
                return String.valueOf(this.getName()) + " - " + this.getSource();
            }
        }
    }
}

