/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ConsumerGroupCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerGroupCommand$
implements Logging {
    public static final ConsumerGroupCommand$ MODULE$;
    private final String MISSING_COLUMN_VALUE;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConsumerGroupCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConsumerGroupCommand$ consumerGroupCommand$ = this;
        synchronized (consumerGroupCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        block16: {
            ConsumerGroupCommand.ConsumerGroupService consumerGroupService;
            ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "List all consumer groups, describe a consumer group, delete consumer group info, or reset consumer group offsets.");
            }
            int actions = ((TraversableOnce)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.listOpt(), opts.describeOpt(), opts.deleteOpt(), opts.resetOffsetsOpt()}))).count(new Serializable(opts){
                public static final long serialVersionUID = 0L;
                private final ConsumerGroupCommand.ConsumerGroupCommandOptions opts$1;

                public final boolean apply(OptionSpec<?> x$1) {
                    return this.opts$1.options().has(x$1);
                }
                {
                    this.opts$1 = opts$1;
                }
            });
            if (actions != 1) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --delete, --reset-offset");
            }
            opts.checkArgs();
            if (opts.useOldConsumer()) {
                System.err.println("Note: This will only show information about consumers that use ZooKeeper (not those using the Java consumer API).\n");
                consumerGroupService = new ConsumerGroupCommand.ZkConsumerGroupService(opts);
            } else {
                System.err.println("Note: This will not show information about old Zookeeper-based consumers.\n");
                consumerGroupService = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
            }
            ConsumerGroupCommand.ConsumerGroupService consumerGroupService2 = consumerGroupService;
            try {
                try {
                    block17: {
                        Tuple2<Option<String>, Option<Seq<ConsumerGroupCommand.PartitionAssignmentState>>> tuple2;
                        block18: {
                            Option<Seq<ConsumerGroupCommand.PartitionAssignmentState>> option;
                            block19: {
                                Option<String> option2;
                                block26: {
                                    BoxedUnit boxedUnit;
                                    block21: {
                                        block23: {
                                            String string2;
                                            Some some;
                                            boolean bl;
                                            Seq assignments;
                                            block25: {
                                                Some some2;
                                                String string3;
                                                Some some3;
                                                String string4;
                                                String groupId;
                                                block24: {
                                                    String string5;
                                                    block22: {
                                                        Option<String> state;
                                                        block20: {
                                                            Tuple2<Option<String>, Option<Seq<ConsumerGroupCommand.PartitionAssignmentState>>> tuple22;
                                                            if (opts.options().has(opts.listOpt())) {
                                                                consumerGroupService2.listGroups().foreach(new Serializable(){
                                                                    public static final long serialVersionUID = 0L;

                                                                    public final void apply(String x$1) {
                                                                        Predef$.MODULE$.println(x$1);
                                                                    }
                                                                });
                                                                break block16;
                                                            }
                                                            if (!opts.options().has(opts.describeOpt())) break block17;
                                                            tuple2 = consumerGroupService2.describeGroup();
                                                            if (tuple2 == null) break block18;
                                                            Option<String> state2 = tuple2._1();
                                                            Option<Seq<ConsumerGroupCommand.PartitionAssignmentState>> assignments2 = tuple2._2();
                                                            Tuple2<Option<String>, Option<Seq<ConsumerGroupCommand.PartitionAssignmentState>>> tuple23 = tuple22 = new Tuple2<Option<String>, Option<Seq<ConsumerGroupCommand.PartitionAssignmentState>>>(state2, assignments2);
                                                            state = tuple23._1();
                                                            Option<Seq<ConsumerGroupCommand.PartitionAssignmentState>> assignments3 = tuple23._2();
                                                            groupId = (String)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.groupOpt())).asScala()).head();
                                                            option = assignments3;
                                                            if (None$.MODULE$.equals(option)) {
                                                                this.printError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group '", "' does not exist."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{groupId})), this.printError$default$2());
                                                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                                                break block16;
                                                            }
                                                            if (!(option instanceof Some)) break block19;
                                                            Some some4 = (Some)option;
                                                            assignments = (Seq)some4.x();
                                                            if (!opts.useOldConsumer()) break block20;
                                                            this.printAssignment(assignments, false);
                                                            boxedUnit = BoxedUnit.UNIT;
                                                            break block21;
                                                        }
                                                        bl = false;
                                                        some = null;
                                                        option2 = state;
                                                        if (!(option2 instanceof Some)) break block22;
                                                        bl = true;
                                                        some = (Some)option2;
                                                        String string6 = (String)some.x();
                                                        if (!"Dead".equals(string6)) break block22;
                                                        this.printError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer group '", "' does not exist."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{groupId})), this.printError$default$2());
                                                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                                                        break block23;
                                                    }
                                                    if (!bl || !"Empty".equals(string5 = (String)some.x())) break block24;
                                                    System.err.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer group '", "' has no active members."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{groupId})));
                                                    this.printAssignment(assignments, true);
                                                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                                                    break block23;
                                                }
                                                boolean bl2 = option2 instanceof Some && "PreparingRebalance".equals(string4 = (String)(some3 = (Some)option2).x()) ? true : option2 instanceof Some && "AwaitingSync".equals(string3 = (String)(some2 = (Some)option2).x());
                                                if (!bl2) break block25;
                                                System.err.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning: Consumer group '", "' is rebalancing."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{groupId})));
                                                this.printAssignment(assignments, true);
                                                BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                                                break block23;
                                            }
                                            if (!bl || !"Stable".equals(string2 = (String)some.x())) break block26;
                                            this.printAssignment(assignments, true);
                                            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                                        }
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit7 = boxedUnit;
                                    break block16;
                                }
                                throw new KafkaException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a valid consumer group state, but found '", "'."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{option2.getOrElse(new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "NONE";
                                    }
                                })})));
                            }
                            throw new MatchError(option);
                        }
                        throw new MatchError(tuple2);
                    }
                    if (opts.options().has(opts.deleteOpt())) {
                        ConsumerGroupCommand.ConsumerGroupService consumerGroupService3 = consumerGroupService2;
                        if (consumerGroupService3 instanceof ConsumerGroupCommand.ZkConsumerGroupService) {
                            ConsumerGroupCommand.ZkConsumerGroupService zkConsumerGroupService = (ConsumerGroupCommand.ZkConsumerGroupService)consumerGroupService3;
                            zkConsumerGroupService.deleteGroups();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block16;
                        }
                        throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete is not supported for ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{consumerGroupService2})));
                    }
                    if (!opts.options().has(opts.resetOffsetsOpt())) break block16;
                    Map<TopicPartition, OffsetAndMetadata> offsetsToReset = consumerGroupService2.resetOffsets();
                    if (opts.options().has(opts.exportOpt())) {
                        String exported = consumerGroupService2.exportOffsetsToReset(offsetsToReset);
                        Predef$.MODULE$.println(exported);
                        break block16;
                    }
                    this.printOffsetsToReset(offsetsToReset);
                }
                catch (Throwable throwable) {
                    this.printError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executing consumer group command failed due to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{throwable.getMessage()})), new Some<Throwable>(throwable));
                }
            }
            finally {
                consumerGroupService2.close();
            }
        }
    }

    public String MISSING_COLUMN_VALUE() {
        return this.MISSING_COLUMN_VALUE;
    }

    public void printError(String msg, Option<Throwable> e) {
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{msg})));
        e.foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Throwable x$3) {
                ConsumerGroupCommand$.MODULE$.debug((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Exception in consumer group command";
                    }
                }), (Function0<Throwable>)((Object)new Serializable(this, x$3){
                    public static final long serialVersionUID = 0L;
                    private final Throwable x$3$1;

                    public final Throwable apply() {
                        return this.x$3$1;
                    }
                    {
                        this.x$3$1 = x$3$1;
                    }
                }));
            }
        });
    }

    public Option<Throwable> printError$default$2() {
        return None$.MODULE$;
    }

    public void printAssignment(Seq<ConsumerGroupCommand.PartitionAssignmentState> groupAssignment, boolean useNewConsumer) {
        Predef$.MODULE$.print(new StringOps(Predef$.MODULE$.augmentString("\n%-30s %-10s %-15s %-15s %-10s %-50s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{"TOPIC", "PARTITION", "CURRENT-OFFSET", "LOG-END-OFFSET", "LAG", "CONSUMER-ID"})));
        if (useNewConsumer) {
            Predef$.MODULE$.print(new StringOps(Predef$.MODULE$.augmentString("%-30s %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{"HOST", "CLIENT-ID"})));
        }
        Predef$.MODULE$.println();
        groupAssignment.foreach(new Serializable(useNewConsumer){
            public static final long serialVersionUID = 0L;
            private final boolean useNewConsumer$1;

            public final void apply(ConsumerGroupCommand.PartitionAssignmentState consumerAssignment) {
                Predef$.MODULE$.print(new StringOps(Predef$.MODULE$.augmentString("%-30s %-10s %-15s %-15s %-10s %-50s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{consumerAssignment.topic().getOrElse(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                    }
                }), consumerAssignment.partition().getOrElse(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                    }
                }), consumerAssignment.offset().getOrElse(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                    }
                }), consumerAssignment.logEndOffset().getOrElse(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                    }
                }), consumerAssignment.lag().getOrElse(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                    }
                }), consumerAssignment.consumerId().getOrElse(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                    }
                })})));
                if (this.useNewConsumer$1) {
                    Predef$.MODULE$.print(new StringOps(Predef$.MODULE$.augmentString("%-30s %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{consumerAssignment.host().getOrElse(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                        }
                    }), consumerAssignment.clientId().getOrElse(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                        }
                    })})));
                }
                Predef$.MODULE$.println();
            }
            {
                this.useNewConsumer$1 = useNewConsumer$1;
            }
        });
    }

    public void printOffsetsToReset(Map<TopicPartition, OffsetAndMetadata> groupAssignmentsToReset) {
        Predef$.MODULE$.print(new StringOps(Predef$.MODULE$.augmentString("\n%-30s %-10s %-15s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{"TOPIC", "PARTITION", "NEW-OFFSET"})));
        Predef$.MODULE$.println();
        groupAssignmentsToReset.foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<TopicPartition, OffsetAndMetadata> x0$1) {
                Tuple2<TopicPartition, OffsetAndMetadata> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition consumerAssignment = tuple2._1();
                    OffsetAndMetadata offsetAndMetadata = tuple2._2();
                    Predef$.MODULE$.print(new StringOps(Predef$.MODULE$.augmentString("%-30s %-10s %-15s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{consumerAssignment.topic(), BoxesRunTime.boxToInteger(consumerAssignment.partition()), BoxesRunTime.boxToLong(offsetAndMetadata.offset())})));
                    Predef$.MODULE$.println();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    private ConsumerGroupCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.MISSING_COLUMN_VALUE = "-";
    }
}

