/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import kafka.api.FetchRequest$;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.api.TopicData;
import kafka.api.TopicData$;
import kafka.common.TopicAndPartition;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class FetchResponse$
implements Serializable {
    public static final FetchResponse$ MODULE$;

    static {
        new FetchResponse$();
    }

    public FetchResponse readFrom(ByteBuffer buffer, int requestVersion) {
        int correlationId = buffer.getInt();
        int throttleTime = requestVersion > 0 ? buffer.getInt() : 0;
        int topicCount = buffer.getInt();
        IndexedSeq pairs = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), topicCount).flatMap(new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$2;

            public final Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>> apply(int x$2) {
                TopicData topicData = TopicData$.MODULE$.readFrom(this.buffer$2);
                return topicData.partitionData().map(new Serializable(this, topicData){
                    public static final long serialVersionUID = 0L;
                    private final TopicData topicData$1;

                    public final Tuple2<TopicAndPartition, FetchResponsePartitionData> apply(Tuple2<Object, FetchResponsePartitionData> x0$1) {
                        Tuple2<Object, FetchResponsePartitionData> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int partitionId = tuple2._1$mcI$sp();
                            FetchResponsePartitionData partitionData = tuple2._2();
                            Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple22 = new Tuple2<TopicAndPartition, FetchResponsePartitionData>(new TopicAndPartition(this.topicData$1.topic(), partitionId), partitionData);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.topicData$1 = topicData$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.buffer$2 = buffer$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new FetchResponse(correlationId, (Seq)package$.MODULE$.Vector().apply(pairs), requestVersion, throttleTime);
    }

    public Seq<Tuple2<String, Seq<Tuple2<Object, FetchResponsePartitionData>>>> batchByTopic(Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>> data) {
        return FetchRequest$.MODULE$.batchByTopic(data);
    }

    public int headerSize(int requestVersion) {
        int throttleTimeSize = requestVersion > 0 ? 4 : 0;
        return 8 + throttleTimeSize;
    }

    public int responseSize(Seq<Tuple2<String, Seq<Tuple2<Object, FetchResponsePartitionData>>>> dataGroupedByTopic2, int requestVersion) {
        return this.headerSize(requestVersion) + BoxesRunTime.unboxToInt(dataGroupedByTopic2.foldLeft(BoxesRunTime.boxToInteger(0), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x0$2, Tuple2<String, Seq<Tuple2<Object, FetchResponsePartitionData>>> x1$1) {
                Tuple2<Integer, Tuple2<String, Seq<Tuple2<Object, FetchResponsePartitionData>>>> tuple2 = new Tuple2<Integer, Tuple2<String, Seq<Tuple2<Object, FetchResponsePartitionData>>>>(BoxesRunTime.boxToInteger(x0$2), x1$1);
                if (tuple2 != null) {
                    int folded = tuple2._1$mcI$sp();
                    Tuple2<String, Seq<Tuple2<Object, FetchResponsePartitionData>>> tuple22 = tuple2._2();
                    if (tuple22 != null) {
                        String topic = tuple22._1();
                        Seq<Tuple2<Object, FetchResponsePartitionData>> partitionDataMap = tuple22._2();
                        TopicData topicData = new TopicData(topic, partitionDataMap.map(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, FetchResponsePartitionData> apply(Tuple2<Object, FetchResponsePartitionData> x0$3) {
                                Tuple2<Object, FetchResponsePartitionData> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    int partitionId = tuple2._1$mcI$sp();
                                    FetchResponsePartitionData partitionData = tuple2._2();
                                    Tuple2<Object, FetchResponsePartitionData> tuple22 = new Tuple2<Object, FetchResponsePartitionData>(BoxesRunTime.boxToInteger(partitionId), partitionData);
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Seq$.MODULE$.canBuildFrom()));
                        int n = folded + topicData.sizeInBytes();
                        return n;
                    }
                }
                throw new MatchError(tuple2);
            }
        }));
    }

    public FetchResponse apply(int correlationId, Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>> data, int requestVersion, int throttleTimeMs) {
        return new FetchResponse(correlationId, data, requestVersion, throttleTimeMs);
    }

    public Option<Tuple4<Object, Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>>, Object, Object>> unapply(FetchResponse x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple4<Integer, Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>>, Integer, Integer>>(new Tuple4<Integer, Seq<Tuple2<TopicAndPartition, FetchResponsePartitionData>>, Integer, Integer>(BoxesRunTime.boxToInteger(x$0.correlationId()), x$0.data(), BoxesRunTime.boxToInteger(x$0.requestVersion()), BoxesRunTime.boxToInteger(x$0.throttleTimeMs())));
    }

    public int $lessinit$greater$default$3() {
        return 0;
    }

    public int $lessinit$greater$default$4() {
        return 0;
    }

    public int apply$default$3() {
        return 0;
    }

    public int apply$default$4() {
        return 0;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FetchResponse$() {
        MODULE$ = this;
    }
}

