/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.StateChangeLogger;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcZI$sp;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bC\u0001\f\u001d\u0013\ti\"AA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtDcA\u0011#GA\u0011a\u0003\u0001\u0005\u0006\u0007y\u0001\r!\u0006\u0005\u00065y\u0001\ra\u0007\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u000b\u0002OA\u0011a\u0003K\u0005\u0003S\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011\u0019Y\u0003\u0001)A\u0005O\u0005\u00112m\u001c8ue>dG.\u001a:D_:$X\r\u001f;!\u0011\u001di\u0003A1A\u0005\n9\nAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012a\f\t\u0003\u0013AJ!!\r\u0006\u0003\u0007%sG\u000f\u0003\u00044\u0001\u0001\u0006IaL\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\t\u000fU\u0002!\u0019!C\u0005m\u00059!p[+uS2\u001cX#A\u001c\u0011\u0005=A\u0014BA\u001d\u0011\u0005\u001dQ6.\u0016;jYNDaa\u000f\u0001!\u0002\u00139\u0014\u0001\u0003>l+RLGn\u001d\u0011\t\u000fu\u0002!\u0019!C\u0005}\u0005q\u0001/\u0019:uSRLwN\\*uCR,W#A \u0011\t\u0001+u)T\u0007\u0002\u0003*\u0011!iQ\u0001\b[V$\u0018M\u00197f\u0015\t!%\"\u0001\u0006d_2dWm\u0019;j_:L!AR!\u0003\u00075\u000b\u0007\u000f\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\t\u000511m\\7n_:L!\u0001T%\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u0017\u001d&\u0011qJ\u0001\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u0019\t\u0006\u0001)A\u0005\u007f\u0005y\u0001/\u0019:uSRLwN\\*uCR,\u0007\u0005C\u0004T\u0001\t\u0007I\u0011\u0002+\u0002%\t\u0014xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u000b\u0002+B\u0011aCV\u0005\u0003/\n\u0011AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\u0003\u0004Z\u0001\u0001\u0006I!V\u0001\u0014EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\t\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0003mqwn\u00149QCJ$\u0018\u000e^5p]2+\u0017\rZ3s'\u0016dWm\u0019;peV\tQ\f\u0005\u0002\u0017=&\u0011qL\u0001\u0002\u0013\u001d>|\u0005\u000fT3bI\u0016\u00148+\u001a7fGR|'\u000f\u0003\u0004b\u0001\u0001\u0006I!X\u0001\u001d]>|\u0005\u000fU1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:!\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0003\u001d\u0019H/\u0019:ukB$\u0012!\u001a\t\u0003\u0013\u0019L!a\u001a\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006S\u0002!\t\u0001Z\u0001\tg\",H\u000fZ8x]\")1\u000e\u0001C\u0001I\u0006\tCO]5hO\u0016\u0014xJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c\u0005.\u00198hK\")Q\u000e\u0001C\u0001]\u0006\t\u0002/\u0019:uSRLwN\\:J]N#\u0018\r^3\u0015\u0005=\u001c\bc\u00019r\u000f6\t1)\u0003\u0002s\u0007\n\u00191+\u001a;\t\u000bQd\u0007\u0019A'\u0002\u000bM$\u0018\r^3\t\u000bY\u0004A\u0011A<\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u0007KbTH0a\u0001\t\u000be,\b\u0019A8\u0002\u0015A\f'\u000f^5uS>t7\u000fC\u0003|k\u0002\u0007Q*A\u0006uCJ<W\r^*uCR,\u0007bB?v!\u0003\u0005\rA`\u0001\u000fY\u0016\fG-\u001a:TK2,7\r^8s!\t1r0C\u0002\u0002\u0002\t\u0011q\u0003U1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:\t\u0013\u0005\u0015Q\u000f%AA\u0002\u0005\u001d\u0011!C2bY2\u0014\u0017mY6t!\r1\u0012\u0011B\u0005\u0004\u0003\u0017\u0011!!C\"bY2\u0014\u0017mY6t\u0011\u001d\ty\u0001\u0001C\u0005\u0003#\t\u0011\u0003[1oI2,7\u000b^1uK\u000eC\u0017M\\4f)-)\u00171CA\u0013\u0003S\tY#!\f\t\u0011\u0005U\u0011Q\u0002a\u0001\u0003/\tQ\u0001^8qS\u000e\u0004B!!\u0007\u0002 9\u0019\u0011\"a\u0007\n\u0007\u0005u!\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\t\u0019C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;Q\u0001bBA\u0014\u0003\u001b\u0001\raL\u0001\na\u0006\u0014H/\u001b;j_:Daa_A\u0007\u0001\u0004i\u0005BB?\u0002\u000e\u0001\u0007a\u0010\u0003\u0005\u0002\u0006\u00055\u0001\u0019AA\u0004\u0011\u0019\t\t\u0004\u0001C\u0005I\u0006A\u0012N\\5uS\u0006d\u0017N_3QCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000f\u0005U\u0002\u0001\"\u0003\u00028\u0005)\u0012m]:feR4\u0016\r\\5e)J\fgn]5uS>tG#B3\u0002:\u0005u\u0002bBA\u001e\u0003g\u0001\raR\u0001\u0012i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007BB>\u00024\u0001\u0007Q\nC\u0004\u0002B\u0001!I!a\u0011\u0002E%t\u0017\u000e^5bY&TX\rT3bI\u0016\u0014\u0018I\u001c3JgJ4uN\u001d)beRLG/[8o)\r)\u0017Q\t\u0005\b\u0003w\ty\u00041\u0001H\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\nq#\u001a7fGRdU-\u00193fe\u001a{'\u000fU1si&$\u0018n\u001c8\u0015\u000f\u0015\fi%a\u0014\u0002R!A\u0011QCA$\u0001\u0004\t9\u0002C\u0004\u0002(\u0005\u001d\u0003\u0019A\u0018\t\ru\f9\u00051\u0001\u007f\u0011\u001d\t)\u0006\u0001C\u0005\u0003/\nAeZ3u\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ#q_\u000eDwJ\u001d+ie><X\t_2faRLwN\u001c\u000b\u0007\u00033\ny&!\u0019\u0011\u0007Y\tY&C\u0002\u0002^\t\u00111\u0004T3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007\u0002CA\u000b\u0003'\u0002\r!a\u0006\t\u000f\u0005\u001d\u00121\u000ba\u0001_!I\u0011Q\r\u0001\u0012\u0002\u0013\u0005\u0011qM\u0001\u001dQ\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tIGK\u0002\u007f\u0003WZ#!!\u001c\u0011\t\u0005=\u0014\u0011P\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003oR\u0011AC1o]>$\u0018\r^5p]&!\u00111PA9\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u007f\u0002\u0011\u0013!C\u0001\u0003\u0003\u000bA\u0004[1oI2,7\u000b^1uK\u000eC\u0017M\\4fg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0004*\"\u0011qAA6\u0001")
public class PartitionStateMachine
implements Logging {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkUtils zkUtils;
    private final Map<TopicAndPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public Map<TopicAndPartition, PartitionState> kafka$controller$PartitionStateMachine$$partitionState() {
        return this.kafka$controller$PartitionStateMachine$$partitionState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    public void startup() {
        this.initializePartitionState();
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started partition state machine with initial state -> ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$controller$PartitionStateMachine$$partitionState()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$partitionState().clear();
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped partition state machine";
            }
        }));
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.kafka$controller$PartitionStateMachine$$partitionState().withFilter((Function1<TopicAndPartition, Object>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> check$ifrefutable$1) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            })).withFilter((Function1<Tuple2<TopicAndPartition, PartitionState>, Object>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> x$1) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = x$1;
                    if (tuple2 != null) {
                        TopicAndPartition topicAndPartition = tuple2._1();
                        boolean bl = !this.$outer.kafka$controller$PartitionStateMachine$$controller.topicDeletionManager().isTopicQueuedUpForDeletion(topicAndPartition.topic());
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })).foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final void apply(Tuple2<TopicAndPartition, PartitionState> x$2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple2 = x$2;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        TopicAndPartition topicAndPartition = tuple2._1();
                        PartitionState partitionState = tuple2._2();
                        if (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$)) {
                            this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), OnlinePartition$.MODULE$, this.$outer.kafka$controller$PartitionStateMachine$$controller.offlinePartitionSelector(), new Callbacks.CallbackBuilder().build());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while moving some partitions to the online state";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            }));
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.kafka$controller$PartitionStateMachine$$partitionState().filter((Function1<TopicAndPartition, Object>)((Object)new Serializable(this, state){
            public static final long serialVersionUID = 0L;
            private final PartitionState state$1;

            public final boolean apply(Tuple2<TopicAndPartition, PartitionState> p) {
                PartitionState partitionState = p._2();
                PartitionState partitionState2 = this.state$1;
                return !(partitionState != null ? !partitionState.equals(partitionState2) : partitionState2 != null);
            }
            {
                this.state$1 = state$1;
            }
        }))).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        this.info((Function0<String>)((Object)new Serializable(this, partitions, targetState){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final PartitionState targetState$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.targetState$1, this.partitions$1.mkString(",")}));
            }
            {
                this.partitions$1 = partitions$1;
                this.targetState$1 = targetState$1;
            }
        }));
        try {
            this.brokerRequestBatch().newBatch();
            partitions.foreach(new Serializable(this, targetState, leaderSelector, callbacks){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final PartitionState targetState$1;
                private final PartitionLeaderSelector leaderSelector$1;
                private final Callbacks callbacks$1;

                public final void apply(TopicAndPartition topicAndPartition) {
                    this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), this.targetState$1, this.leaderSelector$1, this.callbacks$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.targetState$1 = targetState$1;
                    this.leaderSelector$1 = leaderSelector$1;
                    this.callbacks$1 = callbacks$1;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new Serializable(this, targetState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Error while moving some partitions to %s state")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = targetState$1;
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            }));
        }
    }

    public void kafka$controller$PartitionStateMachine$$handleStateChange(String topic, int partition2, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        block12: {
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition2);
            PartitionState currState = this.kafka$controller$PartitionStateMachine$$partitionState().getOrElseUpdate(topicAndPartition, (Function0<PartitionState>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final NonExistentPartition$ apply() {
                    return NonExistentPartition$.MODULE$;
                }
            }));
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.kafka$controller$PartitionStateMachine$$controller.epoch());
            try {
                this.assertValidTransition(topicAndPartition, targetState);
                PartitionState partitionState = targetState;
                if (NewPartition$.MODULE$.equals(partitionState)) {
                    this.kafka$controller$PartitionStateMachine$$partitionState().put(topicAndPartition, NewPartition$.MODULE$);
                    String assignedReplicas = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply(topicAndPartition)).mkString(",");
                    stateChangeLog.trace((Function0<String>)((Object)new Serializable(this, targetState, topicAndPartition, currState, assignedReplicas){
                        public static final long serialVersionUID = 0L;
                        private final PartitionState targetState$2;
                        private final TopicAndPartition topicAndPartition$1;
                        private final PartitionState currState$1;
                        private final String assignedReplicas$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", " with "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$1, this.currState$1, this.targetState$2}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"assigned replicas ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.assignedReplicas$1}))).toString();
                        }
                        {
                            this.targetState$2 = targetState$2;
                            this.topicAndPartition$1 = topicAndPartition$1;
                            this.currState$1 = currState$1;
                            this.assignedReplicas$1 = assignedReplicas$1;
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (OnlinePartition$.MODULE$.equals(partitionState)) {
                    PartitionState partitionState2 = (PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState().apply(topicAndPartition);
                    if (NewPartition$.MODULE$.equals(partitionState2)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OfflinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition2, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (OnlinePartition$.MODULE$.equals(partitionState2)) {
                        this.electLeaderForPartition(topic, partition2, leaderSelector);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.kafka$controller$PartitionStateMachine$$partitionState().put(topicAndPartition, OnlinePartition$.MODULE$);
                    int leader = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply(topicAndPartition)).leaderAndIsr().leader();
                    stateChangeLog.trace((Function0<String>)((Object)new Serializable(this, targetState, topicAndPartition, currState, leader){
                        public static final long serialVersionUID = 0L;
                        private final PartitionState targetState$2;
                        private final TopicAndPartition topicAndPartition$1;
                        private final PartitionState currState$1;
                        private final int leader$1;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " from ", " to ", " with leader ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$1, this.currState$1, this.targetState$2, BoxesRunTime.boxToInteger(this.leader$1)}));
                        }
                        {
                            this.targetState$2 = targetState$2;
                            this.topicAndPartition$1 = topicAndPartition$1;
                            this.currState$1 = currState$1;
                            this.leader$1 = leader$1;
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (OfflinePartition$.MODULE$.equals(partitionState)) {
                    stateChangeLog.trace((Function0<String>)((Object)new Serializable(this, targetState, topicAndPartition, currState){
                        public static final long serialVersionUID = 0L;
                        private final PartitionState targetState$2;
                        private final TopicAndPartition topicAndPartition$1;
                        private final PartitionState currState$1;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                        }
                        {
                            this.targetState$2 = targetState$2;
                            this.topicAndPartition$1 = topicAndPartition$1;
                            this.currState$1 = currState$1;
                        }
                    }));
                    this.kafka$controller$PartitionStateMachine$$partitionState().put(topicAndPartition, OfflinePartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (NonExistentPartition$.MODULE$.equals(partitionState)) {
                    this.stateChangeLogger.trace((Function0<String>)((Object)new Serializable(this, targetState, topicAndPartition, currState){
                        public static final long serialVersionUID = 0L;
                        private final PartitionState targetState$2;
                        private final TopicAndPartition topicAndPartition$1;
                        private final PartitionState currState$1;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                        }
                        {
                            this.targetState$2 = targetState$2;
                            this.topicAndPartition$1 = topicAndPartition$1;
                            this.currState$1 = currState$1;
                        }
                    }));
                    this.kafka$controller$PartitionStateMachine$$partitionState().put(topicAndPartition, NonExistentPartition$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                throw new MatchError(partitionState);
            }
            catch (Throwable throwable) {
                stateChangeLog.error((Function0<String>)((Object)new Serializable(this, targetState, topicAndPartition, currState){
                    public static final long serialVersionUID = 0L;
                    private final PartitionState targetState$2;
                    private final TopicAndPartition topicAndPartition$1;
                    private final PartitionState currState$1;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initiated state change for partition ", " from ", " to ", " failed"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                    }
                    {
                        this.targetState$2 = targetState$2;
                        this.topicAndPartition$1 = topicAndPartition$1;
                        this.currState$1 = currState$1;
                    }
                }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$1;

                    public final Throwable apply() {
                        return this.t$1;
                    }
                    {
                        this.t$1 = t$1;
                    }
                }));
            }
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().keys().foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Option<PartitionState> apply(TopicAndPartition topicPartition) {
                Option<B> option;
                block4: {
                    Option<PartitionState> option2;
                    block3: {
                        block2: {
                            option = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().get(topicPartition);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
                            option2 = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().isReplicaOnline(currentLeaderIsrAndEpoch.leaderAndIsr().leader(), topicPartition, this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().isReplicaOnline$default$3()) ? this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put(topicPartition, OnlinePartition$.MODULE$) : this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put(topicPartition, OfflinePartition$.MODULE$);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        option2 = this.$outer.kafka$controller$PartitionStateMachine$$partitionState().put(topicPartition, NewPartition$.MODULE$);
                    }
                    return option2;
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void assertValidTransition(TopicAndPartition topicAndPartition, PartitionState targetState) {
        if (targetState.validPreviousStates().contains((PartitionState)this.kafka$controller$PartitionStateMachine$$partitionState().apply(topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition, targetState.validPreviousStates().mkString(","), targetState}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.kafka$controller$PartitionStateMachine$$partitionState().apply(topicAndPartition)}))).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        List<Object> replicaAssignment = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply(topicAndPartition)).toList();
        List liveAssignedReplicas = (List)replicaAssignment.filter((Function1)((Object)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final TopicAndPartition topicAndPartition$2;

            public final boolean apply(int r) {
                return this.apply$mcZI$sp(r);
            }

            public boolean apply$mcZI$sp(int r) {
                return this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().isReplicaOnline(r, this.topicAndPartition$2, this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().isReplicaOnline$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$2 = topicAndPartition$2;
            }
        }));
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.kafka$controller$PartitionStateMachine$$controller.epoch());
        Option option = liveAssignedReplicas.headOption();
        if (None$.MODULE$.equals(option)) {
            String failMsg = new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered error during state change of partition ", " from New to Online, "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"assigned replicas are [", "], live brokers are "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replicaAssignment.mkString(",")}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]. No assigned replica is alive."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}))).toString();
            stateChangeLog.error((Function0<String>)((Object)new Serializable(this, failMsg){
                public static final long serialVersionUID = 0L;
                private final String failMsg$1;

                public final String apply() {
                    return this.failMsg$1;
                }
                {
                    this.failMsg$1 = failMsg$1;
                }
            }));
            throw new StateChangeFailedException(stateChangeLog.messageWithPrefix(failMsg));
        }
        if (!(option instanceof Some)) throw new MatchError(option);
        Some some = (Some)option;
        int leader = BoxesRunTime.unboxToInt(some.x());
        this.debug((Function0<String>)((Object)new Serializable(this, topicAndPartition, liveAssignedReplicas){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$2;
            private final List liveAssignedReplicas$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Live assigned replicas for partition ", " are: [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$2, this.liveAssignedReplicas$1}));
            }
            {
                this.topicAndPartition$2 = topicAndPartition$2;
                this.liveAssignedReplicas$1 = liveAssignedReplicas$1;
            }
        }));
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leader, liveAssignedReplicas);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch());
        this.debug((Function0<String>)((Object)new Serializable(this, topicAndPartition, leaderIsrAndControllerEpoch){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$2;
            private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing leader and isr for partition ", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$2, this.leaderIsrAndControllerEpoch$1}));
            }
            {
                this.topicAndPartition$2 = topicAndPartition$2;
                this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch$1;
            }
        }));
        try {
            this.zkUtils().createPersistentPath(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), this.zkUtils().leaderAndIsrZkData(leaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch()), this.zkUtils().createPersistentPath$default$3());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put(topicAndPartition, leaderIsrAndControllerEpoch);
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers(liveAssignedReplicas, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, replicaAssignment, true);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            LeaderIsrAndControllerEpoch leaderIsrAndEpoch = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topicAndPartition.topic(), topicAndPartition.partition()).get();
            String failMsg = new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered error while changing partition ", "'s state from New to Online "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"since LeaderAndIsr path already exists with value ", " and controller "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{leaderIsrAndEpoch.leaderAndIsr()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(leaderIsrAndEpoch.controllerEpoch())}))).toString();
            stateChangeLog.error((Function0<String>)((Object)new Serializable(this, failMsg){
                public static final long serialVersionUID = 0L;
                private final String failMsg$2;

                public final String apply() {
                    return this.failMsg$2;
                }
                {
                    this.failMsg$2 = failMsg$2;
                }
            }));
            throw new StateChangeFailedException(stateChangeLog.messageWithPrefix(failMsg));
        }
    }

    public void electLeaderForPartition(String topic, int partition2, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition2);
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.kafka$controller$PartitionStateMachine$$controller.epoch());
        stateChangeLog.trace((Function0<String>)((Object)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final TopicAndPartition topicAndPartition$3;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started leader election for partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$3}));
            }
            {
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        }));
        try {
            Seq replicasForThisPartition;
            ObjectRef<Object> newLeaderAndIsr;
            block6: {
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2;
                block7: {
                    Tuple2<Object, Object> tuple22;
                    boolean zookeeperPathUpdateSucceeded = false;
                    newLeaderAndIsr = ObjectRef.create(null);
                    replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
                    while (true) {
                        Tuple2$mcZI$sp tuple2$mcZI$sp;
                        Tuple2<LeaderAndIsr, Seq<Object>> tuple23;
                        if (zookeeperPathUpdateSucceeded) break block6;
                        LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition2);
                        LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                        int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                        if (controllerEpoch > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                            String failMsg = new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborted leader election for partition ", " since the LeaderAndIsr path was "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"already written by another controller. This probably means that the current controller ", " went "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.controllerId())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"through a soft failure and another controller was elected with epoch ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(controllerEpoch)}))).toString();
                            stateChangeLog.error((Function0<String>)((Object)new Serializable(this, failMsg){
                                public static final long serialVersionUID = 0L;
                                private final String failMsg$3;

                                public final String apply() {
                                    return this.failMsg$3;
                                }
                                {
                                    this.failMsg$3 = failMsg$3;
                                }
                            }));
                            throw new StateChangeFailedException(stateChangeLog.messageWithPrefix(failMsg));
                        }
                        tuple2 = leaderSelector.selectLeader(topicAndPartition, currentLeaderAndIsr);
                        if (tuple2 == null) break block7;
                        LeaderAndIsr leaderAndIsr = tuple2._1();
                        Seq<Object> replicas = tuple2._2();
                        Tuple2<LeaderAndIsr, Seq<Object>> tuple24 = tuple23 = new Tuple2<LeaderAndIsr, Seq<Object>>(leaderAndIsr, replicas);
                        LeaderAndIsr leaderAndIsr2 = tuple24._1();
                        Seq<Object> replicas2 = tuple24._2();
                        tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkUtils(), topic, partition2, leaderAndIsr2, this.kafka$controller$PartitionStateMachine$$controller.epoch(), currentLeaderAndIsr.zkVersion());
                        if (tuple22 == null) break;
                        boolean updateSucceeded = tuple22._1$mcZ$sp();
                        int newVersion = tuple22._2$mcI$sp();
                        Tuple2$mcZI$sp tuple2$mcZI$sp2 = tuple2$mcZI$sp = new Tuple2$mcZI$sp(updateSucceeded, newVersion);
                        boolean updateSucceeded2 = ((Tuple2)tuple2$mcZI$sp2)._1$mcZ$sp();
                        int newVersion2 = ((Tuple2)tuple2$mcZI$sp2)._2$mcI$sp();
                        var10_7.elem = leaderAndIsr2.withZkVersion(newVersion2);
                        boolean bl = updateSucceeded2;
                        Seq<Object> seq = replicas2;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch((LeaderAndIsr)newLeaderAndIsr.elem, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put(new TopicAndPartition(topic, partition2), newLeaderIsrAndControllerEpoch);
            stateChangeLog.trace((Function0<String>)((Object)new Serializable(this, topicAndPartition, newLeaderAndIsr){
                public static final long serialVersionUID = 0L;
                private final TopicAndPartition topicAndPartition$3;
                private final ObjectRef newLeaderAndIsr$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elected leader ", " for Offline partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(((LeaderAndIsr)this.newLeaderAndIsr$1.elem).leader()), this.topicAndPartition$3}));
                }
                {
                    this.topicAndPartition$3 = topicAndPartition$3;
                    this.newLeaderAndIsr$1 = newLeaderAndIsr$1;
                }
            }));
            Seq replicas = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply(new TopicAndPartition(topic, partition2));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers(replicasForThisPartition, topic, partition2, newLeaderIsrAndControllerEpoch, replicas, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
        }
        catch (Throwable throwable) {
            String failMsg = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered error while electing leader for partition ", " due to: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicAndPartition, throwable.getMessage()}));
            stateChangeLog.error((Function0<String>)((Object)new Serializable(this, failMsg){
                public static final long serialVersionUID = 0L;
                private final String failMsg$4;

                public final String apply() {
                    return this.failMsg$4;
                }
                {
                    this.failMsg$4 = failMsg$4;
                }
            }));
            throw new StateChangeFailedException(stateChangeLog.messageWithPrefix(failMsg), throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {}
        this.debug((Function0<String>)((Object)new Serializable(this, topicAndPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;
            private final TopicAndPartition topicAndPartition$3;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"After leader election, leader cache for ", " is updated to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicAndPartition$3, this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply(this.topicAndPartition$3)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicAndPartition$3 = topicAndPartition$3;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition2) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition2);
        Option<LeaderIsrAndControllerEpoch> option = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topic, partition2);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.x();
            return leaderIsrAndControllerEpoch;
        }
        if (None$.MODULE$.equals(option)) {
            void var3_3;
            throw new StateChangeFailedException(new StringBuilder().append((Object)"LeaderAndIsr information doesn't exist for ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", " in ", " state"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{var3_3, this.kafka$controller$PartitionStateMachine$$partitionState().apply((TopicAndPartition)var3_3)}))).toString());
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController controller, StateChangeLogger stateChangeLogger) {
        this.kafka$controller$PartitionStateMachine$$controller = controller;
        this.stateChangeLogger = stateChangeLogger;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.zkUtils = this.kafka$controller$PartitionStateMachine$$controllerContext().zkUtils();
        this.kafka$controller$PartitionStateMachine$$partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller, stateChangeLogger);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.logIdent_$eq(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[PartitionStateMachine controllerId=", "] "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.controllerId())})));
    }
}

