/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.CleanedTransactionMetadata$;
import kafka.log.Cleaner$;
import kafka.log.Cleaner$$anonfun$kafka$log$Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetMap;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TransactionIndex;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tUc!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011agP\u0007\u0002o)\u0011\u0001\u0003\u000f\u0006\u0003si\naaY8n[>t'BA\u0003<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001;$\u0001\u0002+j[\u0016D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\nG\",7m\u001b#p]\u0016\u0004B\u0001\u0003#G\u0015&\u0011Q)\u0003\u0002\n\rVt7\r^5p]F\u0002\"a\u0012%\u000e\u0003aJ!!\u0013\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001bS\u0005\u0003\u0019&\u0011A!\u00168ji\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"\u0012\u0002U)S'R+fk\u0016-\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bN\u0001\u00049\u0002\"B\u000fN\u0001\u0004y\u0002\"\u0002\u0014N\u0001\u00049\u0002\"\u0002\u0015N\u0001\u00049\u0002\"\u0002\u0016N\u0001\u0004Y\u0003\"B\u0018N\u0001\u0004\u0001\u0004\"\u0002\u001bN\u0001\u0004)\u0004\"\u0002\"N\u0001\u0004\u0019\u0005b\u0002.\u0001\u0005\u0004%\teW\u0001\u000bY><w-\u001a:OC6,W#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n11\u000b\u001e:j]\u001eDa!\u001a\u0001!\u0002\u0013a\u0016a\u00037pO\u001e,'OT1nK\u0002Bqa\u001a\u0001A\u0002\u0013%\u0001.\u0001\u0006sK\u0006$')\u001e4gKJ,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0002\f1A\\5p\u0013\tq7N\u0001\u0006CsR,')\u001e4gKJDq\u0001\u001d\u0001A\u0002\u0013%\u0011/\u0001\bsK\u0006$')\u001e4gKJ|F%Z9\u0015\u0005)\u0013\bbB:p\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0004BB;\u0001A\u0003&\u0011.A\u0006sK\u0006$')\u001e4gKJ\u0004\u0003bB<\u0001\u0001\u0004%I\u0001[\u0001\foJLG/\u001a\"vM\u001a,'\u000fC\u0004z\u0001\u0001\u0007I\u0011\u0002>\u0002\u001f]\u0014\u0018\u000e^3Ck\u001a4WM]0%KF$\"AS>\t\u000fMD\u0018\u0011!a\u0001S\"1Q\u0010\u0001Q!\n%\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002B\u0001b \u0001C\u0002\u0013%\u0011\u0011A\u0001\u001cI\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Ck\u001a4WM]*vaBd\u0017.\u001a:\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0001(\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003\u001b\t9A\u0001\bCk\u001a4WM]*vaBd\u0017.\u001a:\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0007\tA\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0005\u0003\u0005\u0002\u0016\u0001!\tAAA\f\u0003\u0015\u0019G.Z1o)\u0011\tI\"a\u000b\u0011\u000f!\tY\"a\b\u0002&%\u0019\u0011QD\u0005\u0003\rQ+\b\u000f\\33!\rA\u0011\u0011E\u0005\u0004\u0003GI!\u0001\u0002'p]\u001e\u00042\u0001IA\u0014\u0013\r\tIC\u0001\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\t\u0003[\t\u0019\u00021\u0001\u00020\u0005I1\r\\3b]\u0006\u0014G.\u001a\t\u0004A\u0005E\u0012bAA\u001a\u0005\tQAj\\4U_\u000ecW-\u00198\t\u0011\u0005]\u0002\u0001\"\u0001\u0003\u0003s\tq\u0001Z8DY\u0016\fg\u000e\u0006\u0004\u0002\u001a\u0005m\u0012Q\b\u0005\t\u0003[\t)\u00041\u0001\u00020!A\u0011qHA\u001b\u0001\u0004\ty\"A\beK2,G/\u001a%pe&TxN\\'t\u0011!\t\u0019\u0005\u0001C\u0001\u0005\u0005\u0015\u0013!D2mK\u0006t7+Z4nK:$8\u000fF\u0006K\u0003\u000f\ny%!\u001d\u0002v\u0005]\u0004bB\u0002\u0002B\u0001\u0007\u0011\u0011\n\t\u0004A\u0005-\u0013bAA'\u0005\t\u0019Aj\\4\t\u0011\u0005E\u0013\u0011\ta\u0001\u0003'\n\u0001b]3h[\u0016tGo\u001d\t\u0007\u0003+\n)'a\u001b\u000f\t\u0005]\u0013\u0011\r\b\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0011bAA2\u0013\u00059\u0001/Y2lC\u001e,\u0017\u0002BA4\u0003S\u00121aU3r\u0015\r\t\u0019'\u0003\t\u0004A\u00055\u0014bAA8\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005M\u0014\u0011\ta\u0001?\u0005\u0019Q.\u00199\t\u0011\u0005}\u0012\u0011\ta\u0001\u0003?A\u0001\"!\u001f\u0002B\u0001\u0007\u0011QE\u0001\u0006gR\fGo\u001d\u0005\t\u0003{\u0002A\u0011\u0001\u0002\u0002\u0000\u0005I1\r\\3b]&sGo\u001c\u000b\u0014\u0015\u0006\u0005\u0015QQAH\u0003'\u000b)*a(\u0002$\u00065\u0016q\u0018\u0005\b\u0003\u0007\u000bY\b1\u0001G\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001\"a\"\u0002|\u0001\u0007\u0011\u0011R\u0001\u000eg>,(oY3SK\u000e|'\u000fZ:\u0011\t\u0005\u0015\u00111R\u0005\u0005\u0003\u001b\u000b9AA\u0006GS2,'+Z2pe\u0012\u001c\b\u0002CAI\u0003w\u0002\r!a\u001b\u0002\t\u0011,7\u000f\u001e\u0005\b\u0003g\nY\b1\u0001 \u0011!\t9*a\u001fA\u0002\u0005e\u0015!\u0004:fi\u0006Lg\u000eR3mKR,7\u000fE\u0002\t\u00037K1!!(\n\u0005\u001d\u0011un\u001c7fC:Dq!!)\u0002|\u0001\u0007q#A\tnCbdunZ'fgN\fw-Z*ju\u0016D\u0001\"!*\u0002|\u0001\u0007\u0011qU\u0001\u0014iJ\fgn]1di&|g.T3uC\u0012\fG/\u0019\t\u0004A\u0005%\u0016bAAV\u0005\tQ2\t\\3b]\u0016$GK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\"A\u0011qVA>\u0001\u0004\t\t,A\bbGRLg/\u001a)s_\u0012,8-\u001a:t!\u001d\t\u0019,!/\u0002 ]q1\u0001CA[\u0013\r\t9,C\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0016Q\u0018\u0002\u0004\u001b\u0006\u0004(bAA\\\u0013!A\u0011\u0011PA>\u0001\u0004\t)\u0003C\u0004\u0002D\u0002!I!!2\u0002%MDw.\u001e7e\t&\u001c8-\u0019:e\u0005\u0006$8\r\u001b\u000b\t\u00033\u000b9-!5\u0002T\"A\u0011\u0011ZAa\u0001\u0004\tY-A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0002\u0006\u00055\u0017\u0002BAh\u0003\u000f\u00111BU3d_J$')\u0019;dQ\"A\u0011QUAa\u0001\u0004\t9\u000b\u0003\u0005\u0002V\u0006\u0005\u0007\u0019AAM\u0003A\u0011X\r^1j]RCh.T1sW\u0016\u00148\u000fC\u0004\u0002Z\u0002!I!a7\u0002%MDw.\u001e7e%\u0016$\u0018-\u001b8SK\u000e|'\u000f\u001a\u000b\r\u00033\u000bi.a8\u0002b\u0006\r\u00181\u001e\u0005\b\u0003g\n9\u000e1\u0001 \u0011!\t9*a6A\u0002\u0005e\u0005\u0002CAe\u0003/\u0004\r!a3\t\u0011\u0005%\u0011q\u001ba\u0001\u0003K\u0004B!!\u0002\u0002h&!\u0011\u0011^A\u0004\u0005\u0019\u0011VmY8sI\"A\u0011\u0011PAl\u0001\u0004\t)\u0003C\u0004\u0002p\u0002!\t!!=\u0002\u0017\u001d\u0014xn\u001e\"vM\u001a,'o\u001d\u000b\u0004\u0015\u0006M\bbBAQ\u0003[\u0004\ra\u0006\u0005\b\u0003o\u0004A\u0011AA}\u00039\u0011Xm\u001d;pe\u0016\u0014UO\u001a4feN$\u0012A\u0013\u0005\t\u0003{\u0004A\u0011\u0001\u0002\u0002\u0000\u0006\u0019rM]8vaN+w-\\3oiN\u0014\u0015pU5{KRQ!\u0011\u0001B\u0004\u0005\u001f\u0011\u0019Ba\u0006\u0011\r\u0005U#1AA*\u0013\u0011\u0011)!!\u001b\u0003\t1K7\u000f\u001e\u0005\t\u0003#\nY\u00101\u0001\u0003\nA1\u0011Q\u000bB\u0006\u0003WJAA!\u0004\u0002j\tA\u0011\n^3sC\ndW\rC\u0004\u0003\u0012\u0005m\b\u0019A\f\u0002\u000f5\f\u0007pU5{K\"9!QCA~\u0001\u00049\u0012\u0001D7bq&sG-\u001a=TSj,\u0007\u0002\u0003B\r\u0003w\u0004\r!a\b\u0002-\u0019L'o\u001d;V]\u000edW-\u00198bE2,wJ\u001a4tKRDqA!\b\u0001\t\u0013\u0011y\"A\rmCN$xJ\u001a4tKR4uN\u001d$jeN$8+Z4nK:$HCBA\u0010\u0005C\u00119\u0003\u0003\u0005\u0003$\tm\u0001\u0019\u0001B\u0013\u0003\u0011\u0019XmZ:\u0011\r\u0005U#1AA6\u0011!\u0011IBa\u0007A\u0002\u0005}\u0001\u0002\u0003B\u0016\u0001\u0011\u0005!A!\f\u0002\u001d\t,\u0018\u000e\u001c3PM\u001a\u001cX\r^'baRY!Ja\f\u00032\tU\"\u0011\bB\u001e\u0011\u001d\u0019!\u0011\u0006a\u0001\u0003\u0013B\u0001Ba\r\u0003*\u0001\u0007\u0011qD\u0001\u0006gR\f'\u000f\u001e\u0005\t\u0005o\u0011I\u00031\u0001\u0002 \u0005\u0019QM\u001c3\t\u000f\u0005M$\u0011\u0006a\u0001?!A\u0011\u0011\u0010B\u0015\u0001\u0004\t)\u0003C\u0004\u0003@\u0001!IA!\u0011\u00021\t,\u0018\u000e\u001c3PM\u001a\u001cX\r^'ba\u001a{'oU3h[\u0016tG\u000f\u0006\t\u0002\u001a\n\r#Q\tB%\u0005\u0017\u0012yE!\u0015\u0003T!9\u00111\u0011B\u001f\u0001\u00041\u0005\u0002\u0003B$\u0005{\u0001\r!a\u001b\u0002\u000fM,w-\\3oi\"9\u00111\u000fB\u001f\u0001\u0004y\u0002\u0002\u0003B'\u0005{\u0001\r!a\b\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0003C\u0013i\u00041\u0001\u0018\u0011!\t)K!\u0010A\u0002\u0005\u001d\u0006\u0002CA=\u0005{\u0001\r!!\n")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            block3: {
                block2: {
                    option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    if (!None$.MODULE$.equals(option)) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
            }
            long deleteHorizonMs = l;
            return this.doClean(cleanable, deleteHorizonMs);
        }
        throw new MatchError(option);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)((Object)new Serializable(this, cleanable){
            public static final long serialVersionUID = 0L;
            private final LogToClean cleanable$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
            }
            {
                this.cleanable$1 = cleanable$1;
            }
        }));
        Log log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)((Object)new Serializable(this, cleanable){
            public static final long serialVersionUID = 0L;
            private final LogToClean cleanable$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
            }
            {
                this.cleanable$1 = cleanable$1;
            }
        }));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong(log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$13) {
                return x$13.lastModified();
            }
        }).getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.info((Function0<String>)((Object)new Serializable(this, deleteHorizonMs, log, cleanableHorizonMs){
            public static final long serialVersionUID = 0L;
            private final long deleteHorizonMs$1;
            private final Log log$1;
            private final long cleanableHorizonMs$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$1.name(), new Date(this.cleanableHorizonMs$1), new Date(this.deleteHorizonMs$1)}));
            }
            {
                this.deleteHorizonMs$1 = deleteHorizonMs$1;
                this.log$1 = log$1;
                this.cleanableHorizonMs$1 = cleanableHorizonMs$1;
            }
        }));
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach(new Serializable(this, deleteHorizonMs, log, stats){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final long deleteHorizonMs$1;
            private final Log log$1;
            private final CleanerStats stats$2;

            public final void apply(Seq<LogSegment> group) {
                this.$outer.cleanSegments(this.log$1, group, this.$outer.offsetMap(), this.deleteHorizonMs$1, this.stats$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteHorizonMs$1 = deleteHorizonMs$1;
                this.log$1 = log$1;
                this.stats$2 = stats$2;
            }
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2<Object, CleanerStats>(BoxesRunTime.boxToLong(endOffset), stats);
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map2, long deleteHorizonMs, CleanerStats stats) {
        LogSegment firstSegment = (LogSegment)segments.head();
        File logFile = this.deleteAndGetCleanedFile$1(firstSegment.log().file());
        File indexFile = this.deleteAndGetCleanedFile$1(firstSegment.index().file());
        File timeIndexFile = this.deleteAndGetCleanedFile$1(firstSegment.timeIndex().file());
        File txnIndexFile = this.deleteAndGetCleanedFile$1(firstSegment.txnIndex().file());
        long startOffset = firstSegment.baseOffset();
        FileRecords records = FileRecords.open(logFile, false, log.initFileSize(), Predef$.MODULE$.Boolean2boolean(log.config().preallocate()));
        OffsetIndex index = new OffsetIndex(indexFile, startOffset, firstSegment.index().maxIndexSize(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        TimeIndex timeIndex = new TimeIndex(timeIndexFile, startOffset, firstSegment.timeIndex().maxIndexSize(), TimeIndex$.MODULE$.$lessinit$greater$default$4());
        TransactionIndex txnIndex = new TransactionIndex(startOffset, txnIndexFile);
        LogSegment cleaned = new LogSegment(records, index, timeIndex, txnIndex, startOffset, firstSegment.indexIntervalBytes(), log.config().randomSegmentJitter(), this.time);
        try {
            Iterator iter2 = segments.iterator();
            Option currentSegmentOpt = new Some(iter2.next());
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)((Option)currentSegmentOpt).get();
                Option nextSegmentOpt = iter2.hasNext() ? new Some(iter2.next()) : None$.MODULE$;
                long startOffset2 = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong(nextSegmentOpt.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$14) {
                        return x$14.baseOffset();
                    }
                }).getOrElse(new Serializable(this, map2){
                    public static final long serialVersionUID = 0L;
                    private final OffsetMap map$2;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.map$2.latestOffset() + 1L;
                    }
                    {
                        this.map$2 = map$2;
                    }
                }));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset2, upperBoundOffset);
                CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, new Some<TransactionIndex>(txnIndex));
                boolean retainDeletes = currentSegment.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)((Object)new Serializable(this, log, cleaned, currentSegment, startOffset2, retainDeletes){
                    public static final long serialVersionUID = 0L;
                    private final Log log$3;
                    private final LogSegment cleaned$1;
                    private final LogSegment currentSegment$1;
                    private final long startOffset$1;
                    private final boolean retainDeletes$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning segment ", " in log ", " (largest timestamp ", ") "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.startOffset$1), this.log$3.name(), new Date(this.currentSegment$1.largestTimestamp())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"into ", ", ", " deletes."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}))).toString();
                    }
                    {
                        this.log$3 = log$3;
                        this.cleaned$1 = cleaned$1;
                        this.currentSegment$1 = currentSegment$1;
                        this.startOffset$1 = startOffset$1;
                        this.retainDeletes$1 = retainDeletes$1;
                    }
                }));
                this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map2, retainDeletes, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, log.activeProducersWithLastSequence(), stats);
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.log().trim();
            index.trimToValidSize();
            cleaned.onBecomeInactiveSegment();
            timeIndex.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)((Object)new Serializable(this, log, segments, cleaned){
                public static final long serialVersionUID = 0L;
                private final Log log$3;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$15) {
                            return x$15.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), this.log$3.name()}));
                }
                {
                    this.log$3 = log$3;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            }));
            log.replaceSegments(cleaned, segments, log.replaceSegments$default$3());
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map2, boolean retainDeletes, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, Object> activeProducers, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, map2, retainDeletes, transactionMetadata, activeProducers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final OffsetMap map$3;
            private final boolean retainDeletes$2;
            private final CleanedTransactionMetadata transactionMetadata$1;
            private final Map activeProducers$1;
            private final CleanerStats stats$4;

            public boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            public void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$1, this.retainDeletes$2));
                return batch.hasProducerId() && this.activeProducers$1.get(BoxesRunTime.boxToLong(batch.producerId())).contains(BoxesRunTime.boxToInteger(batch.lastSequence())) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record2) {
                return this.discardBatchRecords() ? false : this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$3, this.retainDeletes$2, batch, record2, this.stats$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
                this.retainDeletes$2 = retainDeletes$2;
                this.transactionMetadata$1 = transactionMetadata$1;
                this.activeProducers$1 = activeProducers$1;
                this.stats$4 = stats$4;
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply(topicPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.kafka$log$Cleaner$$readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords(this.kafka$log$Cleaner$$readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result2 = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result2.messagesRead, result2.bytesRead);
            stats.recopyMessages(result2.messagesRetained, result2.bytesRetained);
            position += result2.bytesRead;
            ByteBuffer outputBuffer = result2.output;
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords(outputBuffer);
                dest.append(((RecordBatch)retained.batches().iterator().next()).baseOffset(), result2.maxOffset, result2.maxTimestamp, result2.shallowOffsetOfMaxTimestamp, retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || result2.messagesRead != 0) continue;
            this.growBuffers(maxLogMessageSize);
        }
        this.restoreBuffers();
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        boolean canDiscardBatch;
        boolean canDiscardControlBatch;
        boolean bl = batch.isControlBatch() ? (canDiscardControlBatch = transactionMetadata.onControlBatchRead(batch)) && !retainTxnMarkers : (canDiscardBatch = transactionMetadata.onBatchRead(batch));
        return bl;
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map2, boolean retainDeletes, RecordBatch batch, Record record2, CleanerStats stats) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = record2.offset() > map2.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        if (record2.hasKey()) {
            boolean obsoleteDelete;
            ByteBuffer key = record2.key();
            long foundOffset = map2.get(key);
            boolean redundant = foundOffset >= 0L && record2.offset() < foundOffset;
            boolean bl3 = obsoleteDelete = !retainDeletes && !record2.hasValue();
            bl = !redundant && !obsoleteDelete;
        } else {
            stats.invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)((Object)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append(BoxesRunTime.boxToInteger(this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        List grouped2 = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            List<LogSegment> group = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).index().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && this.lastOffsetForFirstSegment(segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon(logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).index().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped2 = grouped2.$colon$colon(group.reverse());
        }
        return grouped2.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        return segs.size() > 1 ? segs.apply(1).baseOffset() - 1L : firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(Log log, long start, long end, OffsetMap map2, CleanerStats stats) {
        map2.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        this.info((Function0<String>)((Object)new Serializable(this, log, start, end, dirty){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final long end$1;
            private final Buffer dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name(), BoxesRunTime.boxToInteger(this.dirty$1.size()), BoxesRunTime.boxToLong(this.start$1), BoxesRunTime.boxToLong(this.end$1)}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        }));
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, CleanedTransactionMetadata$.MODULE$.apply$default$2());
        BooleanRef full = BooleanRef.create(false);
        dirty.withFilter(new Serializable(this, full){
            public static final long serialVersionUID = 0L;
            private final BooleanRef full$1;

            public final boolean apply(LogSegment segment) {
                return !this.full$1.elem;
            }
            {
                this.full$1 = full$1;
            }
        }).foreach(new Serializable(this, log, start, map2, stats, dirty, transactionMetadata, full){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final Log log$2;
            private final long start$1;
            private final OffsetMap map$1;
            private final CleanerStats stats$3;
            public final Buffer dirty$1;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final BooleanRef full$1;

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply(this.log$2.topicPartition());
                this.full$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$2.topicPartition(), segment, this.map$1, this.start$1, Predef$.MODULE$.Integer2int(this.log$2.config().maxMessageSize()), this.transactionMetadata$2, this.stats$3);
                if (this.full$1.elem) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this, segment){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildOffsetMap$3 $outer;
                        private final LogSegment segment$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.dirty$1.indexOf(this.segment$1)), BoxesRunTime.boxToLong(this.segment$1.baseOffset())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.segment$1 = segment$1;
                        }
                    }));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.map$1 = map$1;
                this.stats$3 = stats$3;
                this.dirty$1 = dirty$1;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.full$1 = full$1;
            }
        });
        this.info((Function0<String>)((Object)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
            }
        }));
    }

    public boolean kafka$log$Cleaner$$buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map2, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            boolean bl;
            Object object = new Object();
            try {
                int position = segment.index().lookup(startOffset).position();
                int maxDesiredMapSize = (int)((double)map2.slots() * this.dupBufferLoadFactor);
                while (position < segment.log().sizeInBytes()) {
                    this.kafka$log$Cleaner$$checkDone.apply(topicPartition);
                    this.kafka$log$Cleaner$$readBuffer().clear();
                    segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position);
                    MemoryRecords records = MemoryRecords.readableRecords(this.kafka$log$Cleaner$$readBuffer());
                    this.throttler.maybeThrottle(records.sizeInBytes());
                    int startPosition = position;
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach(new Serializable(this, map2, startOffset, transactionMetadata, stats, maxDesiredMapSize, object){
                        public static final long serialVersionUID = 0L;
                        public final OffsetMap map$4;
                        public final long startOffset$2;
                        private final CleanedTransactionMetadata transactionMetadata$3;
                        public final CleanerStats stats$5;
                        public final int maxDesiredMapSize$1;
                        public final Object nonLocalReturnKey1$1;

                        public final void apply(MutableRecordBatch batch) {
                            if (batch.isControlBatch()) {
                                this.transactionMetadata$3.onControlBatchRead(batch);
                                this.stats$5.indexMessagesRead(1);
                            } else {
                                boolean isAborted = this.transactionMetadata$3.onBatchRead(batch);
                                if (isAborted) {
                                    this.stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                                } else {
                                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(batch).asScala()).foreach(new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$kafka$log$Cleaner$$buildOffsetMapForSegment$1 $outer;

                                        public final void apply(Record record2) {
                                            if (record2.hasKey() && record2.offset() >= this.$outer.startOffset$2) {
                                                if (this.$outer.map$4.size() < this.$outer.maxDesiredMapSize$1) {
                                                    this.$outer.map$4.put(record2.key(), record2.offset());
                                                } else {
                                                    throw new NonLocalReturnControl$mcZ$sp(this.$outer.nonLocalReturnKey1$1, true);
                                                }
                                            }
                                            this.$outer.stats$5.indexMessagesRead(1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }
                            }
                            if (batch.lastOffset() >= this.startOffset$2) {
                                this.map$4.updateLatestOffset(batch.lastOffset());
                            }
                        }
                        {
                            this.map$4 = map$4;
                            this.startOffset$2 = startOffset$2;
                            this.transactionMetadata$3 = transactionMetadata$3;
                            this.stats$5 = stats$5;
                            this.maxDesiredMapSize$1 = maxDesiredMapSize$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    int bytesRead = records.validBytes();
                    stats.indexBytesRead(bytesRead);
                    if ((position += bytesRead) != startPosition) continue;
                    this.growBuffers(maxLogMessageSize);
                }
                this.restoreBuffers();
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    /*
     * WARNING - void declaration
     */
    private final File deleteAndGetCleanedFile$1(File file) {
        void var2_2;
        File f = new File(new StringBuilder().append((Object)file.getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        f.delete();
        return var2_2;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append(BoxesRunTime.boxToInteger(id)).append((Object)": ").toString());
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads";
            }
        }));
    }
}

