/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002V5nK&sG-\u001a=\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0003\n\u00151aQ\"\u0001\u0002\n\u0005-\u0011!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007\u0010\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0003M_:<\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0001!\u0011!Q\u0001\ni\tQa\u00184jY\u0016\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0005%|'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011AAR5mK\"I1\u0005\u0001B\u0001B\u0003%A\u0002J\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\u0018BA\u0012\u000b\u0011%1\u0003A!A!\u0002\u00139#&\u0001\u0007nCbLe\u000eZ3y'&TX\r\u0005\u0002\u000eQ%\u0011\u0011F\u0004\u0002\u0004\u0013:$\u0018B\u0001\u0014\u000b\u0011%a\u0003A!A!\u0002\u0013i\u0003'\u0001\u0005xe&$\u0018M\u00197f!\tia&\u0003\u00020\u001d\t9!i\\8mK\u0006t\u0017B\u0001\u0017\u000b\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q)A'\u000e\u001c8qA\u0011\u0011\u0002\u0001\u0005\u00063E\u0002\rA\u0007\u0005\u0006GE\u0002\r\u0001\u0004\u0005\bME\u0002\n\u00111\u0001(\u0011\u001da\u0013\u0007%AA\u00025BQA\u000f\u0001\u0005Bm\n\u0011\"\u001a8uef\u001c\u0016N_3\u0016\u0003\u001dBQ!\u0010\u0001\u0005By\na![:Gk2dW#A\u0017\t\u000b\u0001\u0003A\u0011B!\u0002\u0013QLW.Z:uC6\u0004Hc\u0001\u0007C\u0015\")1i\u0010a\u0001\t\u00061!-\u001e4gKJ\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u0010\u0002\u00079Lw.\u0003\u0002J\r\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b-{\u0004\u0019A\u0014\u0002\u00039DQ!\u0014\u0001\u0005\n9\u000baB]3mCRLg/Z(gMN,G\u000fF\u0002(\u001fBCQa\u0011'A\u0002\u0011CQa\u0013'A\u0002\u001dBQA\u0015\u0001\u0005\u0002M\u000b\u0011\u0002\\1ti\u0016sGO]=\u0016\u0003Q\u0003\"!C+\n\u0005Y\u0013!a\u0004+j[\u0016\u001cH/Y7q\u001f\u001a47/\u001a;\t\u000ba\u0003A\u0011A-\u0002\u000b\u0015tGO]=\u0015\u0005QS\u0006\"B&X\u0001\u00049\u0003\"\u0002/\u0001\t\u0003j\u0016A\u00039beN,WI\u001c;ssR\u0019a,\u00192\u0011\u0005%y\u0016B\u00011\u0003\u0005)Ie\u000eZ3y\u000b:$(/\u001f\u0005\u0006\u0007n\u0003\r\u0001\u0012\u0005\u0006\u0017n\u0003\ra\n\u0005\u0006I\u0002!\t!Z\u0001\f[\u0006L(-Z!qa\u0016tG\r\u0006\u0003gS*d\u0007CA\u0007h\u0013\tAgB\u0001\u0003V]&$\b\"\u0002!d\u0001\u0004a\u0001\"B6d\u0001\u0004a\u0011AB8gMN,G\u000fC\u0004nGB\u0005\t\u0019A\u0017\u0002\u001bM\\\u0017\u000e\u001d$vY2\u001c\u0005.Z2l\u0011\u0015y\u0007\u0001\"\u0001q\u0003\u0019awn\\6vaR\u0011A+\u001d\u0005\u0006e:\u0004\r\u0001D\u0001\u0010i\u0006\u0014x-\u001a;US6,7\u000f^1na\")A\u000f\u0001C!k\u0006AAO];oG\u0006$X\rF\u0001g\u0011\u00159\b\u0001\"\u0011y\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0003MfDQa\u001b<A\u00021AQa\u001f\u0001\u0005\nq\f\u0011\u0003\u001e:v]\u000e\fG/\u001a+p\u000b:$(/[3t)\t1W\u0010C\u0003\u007fu\u0002\u0007q%A\u0004f]R\u0014\u0018.Z:\t\r\u0005\u0005\u0001\u0001\"\u0011v\u0003-\u0019\u0018M\\5us\u000eCWmY6\t\u0013\u0005\u0015\u0001!%A\u0005\u0002\u0005\u001d\u0011!F7bs\n,\u0017\t\u001d9f]\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0013Q3!LA\u0006W\t\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAA\f\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0011\u0011\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"DA\u0010\u0001A\u0005\u0019\u0011!A\u0005\n\u0005\u0005B%\u0001\ttkB,'\u000f\n2bg\u0016|eMZ:fiV\tAbB\u0005\u0002&\t\t\t\u0011#\u0001\u0002(\u0005IA+[7f\u0013:$W\r\u001f\t\u0004\u0013\u0005%b\u0001C\u0001\u0003\u0003\u0003E\t!a\u000b\u0014\t\u0005%\u0012Q\u0006\t\u0004\u001b\u0005=\u0012bAA\u0019\u001d\t1\u0011I\\=SK\u001aDqAMA\u0015\t\u0003\t)\u0004\u0006\u0002\u0002(!Q\u0011\u0011HA\u0015#\u0003%\t!a\u000f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tiDK\u0002(\u0003\u0017A!\"!\u0011\u0002*E\u0005I\u0011AA\u0004\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class TimeIndex
extends AbstractIndex<Object, Object> {
    public static boolean $lessinit$greater$default$4() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public /* synthetic */ long kafka$log$TimeIndex$$super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    public long kafka$log$TimeIndex$$timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    public int kafka$log$TimeIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;

            public final TimestampOffset apply() {
                TimestampOffset timestampOffset;
                int n = this.$outer._entries();
                switch (n) {
                    default: {
                        timestampOffset = (TimestampOffset)this.$outer.parseEntry(this.$outer.mmap(), n - 1);
                        break;
                    }
                    case 0: {
                        timestampOffset = new TimestampOffset(-1L, this.$outer.kafka$log$TimeIndex$$super$baseOffset());
                    }
                }
                return timestampOffset;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public TimestampOffset entry(int n) {
        return this.maybeLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final int n$1;

            public final TimestampOffset apply() {
                if (this.n$1 >= this.$outer._entries()) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from a time index of size %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.n$1), BoxesRunTime.boxToInteger(this.$outer._entries())})));
                }
                ByteBuffer idx = this.$outer.mmap().duplicate();
                return new TimestampOffset(this.$outer.kafka$log$TimeIndex$$timestamp(idx, this.n$1), this.$outer.kafka$log$TimeIndex$$relativeOffset(idx, this.n$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        });
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.kafka$log$TimeIndex$$timestamp(buffer, n), super.baseOffset() + (long)this.kafka$log$TimeIndex$$relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp2, long offset2, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, timestamp2, offset2, skipFullCheck){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            public final long timestamp$1;
            public final long offset$1;
            private final boolean skipFullCheck$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (!this.skipFullCheck$1) {
                    Predef$.MODULE$.require(!this.$outer.isFull(), (Function0<Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Attempt to append to a full time index (size = ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$TimeIndex$$anonfun$$$outer()._entries())).append((Object)").").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                if (this.$outer._entries() != 0 && this.offset$1 < this.$outer.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to slot %d no larger than the last offset appended (%d) to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.offset$1), BoxesRunTime.boxToInteger(this.$outer._entries()), BoxesRunTime.boxToLong(this.$outer.lastEntry().offset()), this.$outer.file().getAbsolutePath()})));
                }
                if (this.$outer._entries() != 0 && this.timestamp$1 < this.$outer.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append a timestamp (%d) to slot %d no larger than the last timestamp appended (%d) to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.timestamp$1), BoxesRunTime.boxToInteger(this.$outer._entries()), BoxesRunTime.boxToLong(this.$outer.lastEntry().timestamp()), this.$outer.file().getAbsolutePath()})));
                }
                if (this.timestamp$1 > this.$outer.lastEntry().timestamp()) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.timestamp$1), BoxesRunTime.boxToLong(this.$outer.offset$1), this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().file().getName()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    this.$outer.mmap().putLong(this.timestamp$1);
                    this.$outer.mmap().putInt((int)(this.offset$1 - this.$outer.kafka$log$TimeIndex$$super$baseOffset()));
                    this.$outer._entries_$eq(this.$outer._entries() + 1);
                    Predef$.MODULE$.require(this.$outer._entries() * this.$outer.entrySize() == this.$outer.mmap().position(), (Function0<Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$TimeIndex$$anonfun$$$outer()._entries()).append((Object)" entries but file position in index is ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
            }

            public /* synthetic */ TimeIndex kafka$log$TimeIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
                this.offset$1 = offset$1;
                this.skipFullCheck$1 = skipFullCheck$1;
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return this.maybeLock(this.lock(), new Serializable(this, targetTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long targetTimestamp$1;

            public final TimestampOffset apply() {
                TimestampOffset timestampOffset;
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.targetTimestamp$1, IndexSearchType$.MODULE$.KEY());
                if (slot == -1) {
                    timestampOffset = new TimestampOffset(-1L, this.$outer.kafka$log$TimeIndex$$super$baseOffset());
                } else {
                    TimestampOffset entry2 = (TimestampOffset)this.$outer.parseEntry(idx, slot);
                    timestampOffset = new TimestampOffset(entry2.timestamp(), entry2.offset());
                }
                return timestampOffset;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetTimestamp$1 = targetTimestamp$1;
            }
        });
    }

    @Override
    public void truncate() {
        this.kafka$log$TimeIndex$$truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.offset$2, IndexSearchType$.MODULE$.VALUE());
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$TimeIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.kafka$log$TimeIndex$$super$baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$TimeIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    public void kafka$log$TimeIndex$$truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final int entries$1;

            public final Buffer apply() {
                this.$outer._entries_$eq(this.entries$1);
                return this.$outer.mmap().position(this.$outer._entries() * this.$outer.entrySize());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    @Override
    public void sanityCheck() {
        TimestampOffset entry2 = this.lastEntry();
        long lastTimestamp = entry2.timestamp();
        long lastOffset = entry2.offset();
        Predef$.MODULE$.require(this._entries() == 0 || lastTimestamp >= this.kafka$log$TimeIndex$$timestamp(this.mmap(), 0), (Function0<Object>)((Object)new Serializable(this, lastTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long lastTimestamp$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has non-zero size but the last timestamp "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.file().getAbsolutePath()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is no larger than the first timestamp ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.lastTimestamp$1), BoxesRunTime.boxToLong(this.$outer.kafka$log$TimeIndex$$timestamp(this.$outer.mmap(), 0))}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastTimestamp$1 = lastTimestamp$1;
            }
        }));
        Predef$.MODULE$.require(this._entries() == 0 || lastOffset >= super.baseOffset(), (Function0<Object>)((Object)new Serializable(this, lastOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long lastOffset$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has non-zero size but the last offset "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.file().getAbsolutePath()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is smaller than the first offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.lastOffset$1), BoxesRunTime.boxToLong(this.$outer.kafka$log$TimeIndex$$super$baseOffset())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastOffset$1 = lastOffset$1;
            }
        }));
        long len = this.file().length();
        Predef$.MODULE$.require(len % (long)this.entrySize() == 0L, (Function0<Object>)((Object)new Serializable(this, len){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long len$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Time index file ").append((Object)this.$outer.file().getAbsolutePath()).append((Object)" is corrupt, found ").append(BoxesRunTime.boxToLong(this.len$1)).append((Object)" bytes which is not positive or not a multiple of 12.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.len$1 = len$1;
            }
        }));
    }

    public TimeIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
    }
}

