/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.server.TopicConfigHandler$;
import kafka.utils.Implicits$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u000f\t\u0011Bk\u001c9jG\u000e{gNZ5h\u0011\u0006tG\r\\3s\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t\u001dI\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u00055\u0019uN\u001c4jO\"\u000bg\u000e\u001a7feB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0006kRLGn]\u0005\u0003/Q\u0011q\u0001T8hO&tw\r\u0003\u0005\u001a\u0001\t\u0015\r\u0011\"\u0003\u001b\u0003)awnZ'b]\u0006<WM]\u000b\u00027A\u0011AdH\u0007\u0002;)\u0011a\u0004B\u0001\u0004Y><\u0017B\u0001\u0011\u001e\u0005)aunZ'b]\u0006<WM\u001d\u0005\tE\u0001\u0011\t\u0011)A\u00057\u0005YAn\\4NC:\fw-\u001a:!\u0011!!\u0003A!A!\u0002\u0013)\u0013aC6bM.\f7i\u001c8gS\u001e\u0004\"a\u0004\u0014\n\u0005\u001d\u0012!aC&bM.\f7i\u001c8gS\u001eD\u0001\"\u000b\u0001\u0003\u0006\u0004%\tAK\u0001\u0007cV|G/Y:\u0016\u0003-\u0002\"\u0001\f\u001c\u000f\u00055\"dB\u0001\u00184\u001d\ty#'D\u00011\u0015\t\td!\u0001\u0004=e>|GOP\u0005\u0002\u000b%\u00111\u0001B\u0005\u0003k\t\tA\"U;pi\u00064\u0015m\u0019;pefL!a\u000e\u001d\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\t)$\u0001\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003,\u0003\u001d\tXo\u001c;bg\u0002BQ\u0001\u0010\u0001\u0005\u0002u\na\u0001P5oSRtD\u0003\u0002 @\u0001\u0006\u0003\"a\u0004\u0001\t\u000beY\u0004\u0019A\u000e\t\u000b\u0011Z\u0004\u0019A\u0013\t\u000b%Z\u0004\u0019A\u0016\t\u000b\r\u0003A\u0011\u0001#\u0002)A\u0014xnY3tg\u000e{gNZ5h\u0007\"\fgnZ3t)\r)\u0005*\u0015\t\u0003\u0013\u0019K!a\u0012\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0013\n\u0003\rAS\u0001\u0006i>\u0004\u0018n\u0019\t\u0003\u0017:s!!\u0003'\n\u00055S\u0011A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014\u0006\t\u000bI\u0013\u0005\u0019A*\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bA!\u001e;jY*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.V\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u00069\u0002!\t!X\u0001\u0019a\u0006\u00148/\u001a+ie>$H\u000f\\3e!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u00020kW6\u00042a\u00183h\u001d\t\u0001'M\u0004\u00020C&\t1\"\u0003\u0002d\u0015\u00059\u0001/Y2lC\u001e,\u0017BA3g\u0005\r\u0019V-\u001d\u0006\u0003G*\u0001\"!\u00035\n\u0005%T!aA%oi\")!k\u0017a\u0001'\")An\u0017a\u0001O\u0006A!M]8lKJLE\rC\u0003o7\u0002\u0007!*\u0001\u0003qe>\u0004\b\"\u00029\u0001\t\u0003\t\u0018aD3yG2,H-\u001a3D_:4\u0017nZ:\u0015\u0007I,h\u000fE\u0002Lg*K!\u0001\u001e)\u0003\u0007M+G\u000fC\u0003J_\u0002\u0007!\nC\u0003S_\u0002\u00071\u000b")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final LogManager logManager;
    public final KafkaConfig kafka$server$TopicConfigHandler$$kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicConfigHandler topicConfigHandler = this;
        synchronized (topicConfigHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private LogManager logManager() {
        return this.logManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        Buffer logs = this.logManager().logsByTopicPartition().filterKeys((Function1<TopicPartition, Object>)((Object)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final boolean apply(TopicPartition x$1) {
                String string2 = x$1.topic();
                String string3 = this.topic$1;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.topic$1 = topic$1;
            }
        })).values().toBuffer();
        if (logs.nonEmpty()) {
            Properties props = new Properties();
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq((Map<String, Object>)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.logManager().defaultConfig().originals()).asScala());
            ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala()).foreach(new Serializable(this, configNamesToExclude, props){
                public static final long serialVersionUID = 0L;
                private final Set configNamesToExclude$1;
                private final Properties props$1;

                public final Object apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = tuple2._1();
                        String value2 = tuple2._2();
                        BoxedUnit boxedUnit = this.configNamesToExclude$1.contains(key) ? BoxedUnit.UNIT : this.props$1.put(key, value2);
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.configNamesToExclude$1 = configNamesToExclude$1;
                    this.props$1 = props$1;
                }
            });
            LogConfig logConfig = new LogConfig(props);
            if ((topicConfig.containsKey(LogConfig$.MODULE$.RetentionMsProp()) || topicConfig.containsKey(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp())) && Predef$.MODULE$.Long2long(logConfig.retentionMs()) < logConfig.messageTimestampDifferenceMaxMs()) {
                this.warn((Function0<String>)((Object)new Serializable(this, topic, logConfig){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;
                    private final LogConfig logConfig$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for topic ", " is set to ", ". It is smaller than "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{LogConfig$.MODULE$.RetentionMsProp(), this.topic$1, this.logConfig$1.retentionMs()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s value ", ". "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), BoxesRunTime.boxToLong(this.logConfig$1.messageTimestampDifferenceMaxMs())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This may result in frequent log rolling."})).s(Nil$.MODULE$)).toString();
                    }
                    {
                        this.topic$1 = topic$1;
                        this.logConfig$1 = logConfig$1;
                    }
                }));
            }
            logs.foreach(new Serializable(this, logConfig){
                public static final long serialVersionUID = 0L;
                private final LogConfig logConfig$1;

                public final void apply(Log x$2) {
                    x$2.config_$eq(this.logConfig$1);
                }
                {
                    this.logConfig$1 = logConfig$1;
                }
            });
        }
        this.updateThrottledList$1(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topic, topicConfig);
        this.updateThrottledList$1(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topic, topicConfig);
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        String string2 = configValue;
        Seq<Object> seq = "".equals(string2) ? (Seq<Object>)Seq$.MODULE$.apply(Nil$.MODULE$) : ("*".equals(string2) ? Constants$.MODULE$.AllReplicas() : Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$3) {
                return x$3.split(":");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).filter(new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final boolean apply(String[] x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4[1])).toInt() == this.brokerId$1;
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        })).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String[] x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5[0])).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSeq());
        return seq;
    }

    public Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap(new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicConfigHandler $outer;
            public final String topic$2;

            public final Option<String> apply(String versionString) {
                Option option;
                if (this.$outer.kafka$server$TopicConfigHandler$$kafkaConfig.interBrokerProtocolVersion().$less(ApiVersion$.MODULE$.apply(versionString))) {
                    this.$outer.warn((Function0<String>)((Object)new Serializable(this, versionString){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$excludedConfigs$1 $outer;
                        private final String versionString$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log configuration ", " is ignored for `", "` because `", "` "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), this.$outer.topic$2, this.versionString$1}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not compatible with Kafka inter-broker protocol version `", "`"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$server$TopicConfigHandler$$anonfun$$$outer().kafka$server$TopicConfigHandler$$kafkaConfig.interBrokerProtocolVersionString()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.versionString$1 = versionString$1;
                        }
                    }));
                    option = new Some<String>(LogConfig$.MODULE$.MessageFormatVersionProp());
                } else {
                    option = None$.MODULE$;
                }
                return option;
            }

            public /* synthetic */ TopicConfigHandler kafka$server$TopicConfigHandler$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, String topic$1, Properties topicConfig$1) {
        if (topicConfig$1.containsKey(prop) && topicConfig$1.getProperty(prop).length() > 0) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafka$server$TopicConfigHandler$$kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting ", " on broker ", " for topic: ", " and partitions ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{prop, BoxesRunTime.boxToInteger(this.kafka$server$TopicConfigHandler$$kafkaConfig.brokerId()), topic$1, partitions})));
        } else {
            quotaManager.removeThrottle(topic$1);
            this.logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " from broker ", " for topic ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{prop, BoxesRunTime.boxToInteger(this.kafka$server$TopicConfigHandler$$kafkaConfig.brokerId()), topic$1})));
        }
    }

    public TopicConfigHandler(LogManager logManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas) {
        this.logManager = logManager;
        this.kafka$server$TopicConfigHandler$$kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        Logging$class.$init$(this);
    }
}

