/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import kafka.tools.ProducerPerformance;
import kafka.utils.Exit$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ProducerPerformance$
implements Logging {
    public static final ProducerPerformance$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ProducerPerformance$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerPerformance$ producerPerformance$ = this;
        synchronized (producerPerformance$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        Logger logger = Logger.getLogger(this.getClass());
        ProducerPerformance.ProducerPerfConfig config = new ProducerPerformance.ProducerPerfConfig(args);
        if (!config.isFixedSize()) {
            logger.info("WARN: Throughput will be slower due to changing message size per request");
        }
        AtomicLong totalBytesSent = new AtomicLong(0L);
        AtomicLong totalMessagesSent = new AtomicLong(0L);
        ExecutorService executor = Executors.newFixedThreadPool(config.numThreads());
        CountDownLatch allDone = new CountDownLatch(config.numThreads());
        long startMs = System.currentTimeMillis();
        Random rand = new Random();
        if (!config.hideHeader()) {
            Predef$.MODULE$.println("start.time, end.time, compression, message.size, batch.size, total.data.sent.in.MB, MB.sec, total.data.sent.in.nMsg, nMsg.sec");
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(config, totalBytesSent, totalMessagesSent, executor, allDone, rand){
            public static final long serialVersionUID = 0L;
            private final ProducerPerformance.ProducerPerfConfig config$1;
            private final AtomicLong totalBytesSent$1;
            private final AtomicLong totalMessagesSent$1;
            private final ExecutorService executor$1;
            private final CountDownLatch allDone$1;
            private final Random rand$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.executor$1.execute(new ProducerPerformance.ProducerThread(i, this.config$1, this.totalBytesSent$1, this.totalMessagesSent$1, this.allDone$1, this.rand$1));
            }
            {
                this.config$1 = config$1;
                this.totalBytesSent$1 = totalBytesSent$1;
                this.totalMessagesSent$1 = totalMessagesSent$1;
                this.executor$1 = executor$1;
                this.allDone$1 = allDone$1;
                this.rand$1 = rand$1;
            }
        }));
        allDone.await();
        long endMs = System.currentTimeMillis();
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        double totalMBSent = (double)totalBytesSent.get() * 1.0 / (double)0x100000;
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s, %s, %d, %d, %d, %.2f, %.4f, %d, %.4f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong(startMs)), config.dateFormat().format(BoxesRunTime.boxToLong(endMs)), BoxesRunTime.boxToInteger(config.compressionCodec().codec()), BoxesRunTime.boxToInteger(config.messageSize()), BoxesRunTime.boxToInteger(config.batchSize()), BoxesRunTime.boxToDouble(totalMBSent), BoxesRunTime.boxToDouble(totalMBSent / elapsedSecs), BoxesRunTime.boxToLong(totalMessagesSent.get()), BoxesRunTime.boxToDouble((double)totalMessagesSent.get() / elapsedSecs)})));
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    private ProducerPerformance$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

