/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.utils.timer.SystemTimer$;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import kafka.utils.timer.TimerTaskList;
import kafka.utils.timer.TimingWheel;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001%\u00111bU=ti\u0016lG+[7fe*\u00111\u0001B\u0001\u0006i&lWM\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0002\u0005\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!\u0002+j[\u0016\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0019\u0015DXmY;u_Jt\u0015-\\3\u0011\u0005]QbBA\u0006\u0019\u0013\tIB\"\u0001\u0004Qe\u0016$WMZ\u0005\u00037q\u0011aa\u0015;sS:<'BA\r\r\u0011!q\u0002A!A!\u0002\u0013y\u0012A\u0002;jG.l5\u000f\u0005\u0002\fA%\u0011\u0011\u0005\u0004\u0002\u0005\u0019>tw\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003%9\b.Z3m'&TX\r\u0005\u0002\fK%\u0011a\u0005\u0004\u0002\u0004\u0013:$\b\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u000fM$\u0018M\u001d;Ng\")!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"R\u0001L\u0017/_A\u0002\"!\u0005\u0001\t\u000bUI\u0003\u0019\u0001\f\t\u000fyI\u0003\u0013!a\u0001?!91%\u000bI\u0001\u0002\u0004!\u0003b\u0002\u0015*!\u0003\u0005\ra\b\u0005\u0007e\u0001\u0001\u000b\u0011B\u001a\u0002\u0019Q\f7o[#yK\u000e,Ho\u001c:\u0011\u0005QZT\"A\u001b\u000b\u0005Y:\u0014AC2p]\u000e,(O]3oi*\u0011\u0001(O\u0001\u0005kRLGNC\u0001;\u0003\u0011Q\u0017M^1\n\u0005q*$aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\ry\u0002\u0001\u0015!\u0003@\u0003)!W\r\\1z#V,W/\u001a\t\u0004i\u0001\u0013\u0015BA!6\u0005)!U\r\\1z#V,W/\u001a\t\u0003#\rK!\u0001\u0012\u0002\u0003\u001bQKW.\u001a:UCN\\G*[:u\u0011\u00191\u0005\u0001)A\u0005\u000f\u0006YA/Y:l\u0007>,h\u000e^3s!\tA5*D\u0001J\u0015\tQU'\u0001\u0004bi>l\u0017nY\u0005\u0003\u0019&\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bB\u0002(\u0001A\u0003%q*A\u0006uS6LgnZ,iK\u0016d\u0007CA\tQ\u0013\t\t&AA\u0006US6LgnZ,iK\u0016d\u0007BB*\u0001A\u0003%A+A\u0007sK\u0006$wK]5uK2{7m\u001b\t\u0003+bk\u0011A\u0016\u0006\u0003/V\nQ\u0001\\8dWNL!!\u0017,\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.Daa\u0017\u0001!\u0002\u0013a\u0016\u0001\u0003:fC\u0012dunY6\u0011\u0005u\u0003W\"\u00010\u000b\u0005}3\u0016A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\n\u0005\u0005t&\u0001\u0003*fC\u0012dunY6\t\r\r\u0004\u0001\u0015!\u0003e\u0003%9(/\u001b;f\u0019>\u001c7\u000e\u0005\u0002^K&\u0011aM\u0018\u0002\n/JLG/\u001a'pG.DQ\u0001\u001b\u0001\u0005\u0002%\f1!\u00193e)\tQW\u000e\u0005\u0002\fW&\u0011A\u000e\u0004\u0002\u0005+:LG\u000fC\u0003oO\u0002\u0007q.A\u0005uS6,'\u000fV1tWB\u0011\u0011\u0003]\u0005\u0003c\n\u0011\u0011\u0002V5nKJ$\u0016m]6\t\u000bM\u0004A\u0011\u0002;\u0002#\u0005$G\rV5nKJ$\u0016m]6F]R\u0014\u0018\u0010\u0006\u0002kk\")aO\u001da\u0001o\u0006qA/[7feR\u000b7o[#oiJL\bCA\ty\u0013\tI(A\u0001\bUS6,'\u000fV1tW\u0016sGO]=\t\rm\u0004\u0001\u0015!\u0003}\u0003!\u0011X-\u001b8tKJ$\b\u0003B\u0006~o*L!A \u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBA\u0001\u0001\u0011\u0005\u00111A\u0001\rC\u00124\u0018M\\2f\u00072|7m\u001b\u000b\u0005\u0003\u000b\tY\u0001E\u0002\f\u0003\u000fI1!!\u0003\r\u0005\u001d\u0011un\u001c7fC:Da!!\u0004\u0000\u0001\u0004y\u0012!\u0003;j[\u0016|W\u000f^'t\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\tAa]5{KV\tA\u0005C\u0004\u0002\u0018\u0001!\t%!\u0007\u0002\u0011MDW\u000f\u001e3po:$\u0012A\u001b\u0015\u0004\u0001\u0005u\u0001\u0003BA\u0010\u0003Ci\u0011\u0001B\u0005\u0004\u0003G!!A\u0003;ie\u0016\fGm]1gK\u001eI\u0011q\u0005\u0002\u0002\u0002#\u0005\u0011\u0011F\u0001\f'f\u001cH/Z7US6,'\u000fE\u0002\u0012\u0003W1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QF\n\u0004\u0003WQ\u0001b\u0002\u0016\u0002,\u0011\u0005\u0011\u0011\u0007\u000b\u0003\u0003SA!\"!\u000e\u0002,E\u0005I\u0011AA\u001c\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\b\u0016\u0004?\u0005m2FAA\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dC\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0013\u0002B\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005=\u00131FI\u0001\n\u0003\t\t&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003'R3\u0001JA\u001e\u0011)\t9&a\u000b\u0012\u0002\u0013\u0005\u0011qG\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b")
public class SystemTimer
implements Timer {
    public final String kafka$utils$timer$SystemTimer$$executorName;
    private final ExecutorService taskExecutor;
    private final DelayQueue<TimerTaskList> delayQueue;
    private final AtomicInteger taskCounter;
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Function1<TimerTaskEntry, BoxedUnit> reinsert;

    public static long $lessinit$greater$default$4() {
        return SystemTimer$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return SystemTimer$.MODULE$.$lessinit$greater$default$3();
    }

    public static long $lessinit$greater$default$2() {
        return SystemTimer$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.kafka$utils$timer$SystemTimer$$addTimerTaskEntry(new TimerTaskEntry(timerTask, timerTask.delayMs() + Time.SYSTEM.hiResClockMs()));
            return;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void kafka$utils$timer$SystemTimer$$addTimerTaskEntry(TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry) && !timerTaskEntry.cancelled()) {
            this.taskExecutor.submit(timerTaskEntry.timerTask());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean advanceClock(long timeoutMs) {
        TimerTaskList bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        if (bucket == null) {
            return false;
        }
        this.writeLock.lock();
        try {
            while (true) {
                if (bucket == null) {
                    boolean bl = true;
                    return bl;
                }
                this.timingWheel.advanceClock(bucket.getExpiration());
                bucket.flush(this.reinsert);
                bucket = (TimerTaskList)this.delayQueue.poll();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.taskCounter.get();
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    public SystemTimer(String executorName, long tickMs, int wheelSize, long startMs) {
        this.kafka$utils$timer$SystemTimer$$executorName = executorName;
        this.taskExecutor = Executors.newFixedThreadPool(1, new ThreadFactory(this){
            private final /* synthetic */ SystemTimer $outer;

            public Thread newThread(Runnable runnable) {
                return KafkaThread.nonDaemon(new StringBuilder().append((Object)"executor-").append((Object)this.$outer.kafka$utils$timer$SystemTimer$$executorName).toString(), runnable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.delayQueue = new DelayQueue();
        this.taskCounter = new AtomicInteger(0);
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.reinsert = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SystemTimer $outer;

            public final void apply(TimerTaskEntry timerTaskEntry) {
                this.$outer.kafka$utils$timer$SystemTimer$$addTimerTaskEntry(timerTaskEntry);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

