/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;

public class ZipArchiveInputStream
extends ArchiveInputStream {
    private final ZipEncoding zipEncoding;
    private final boolean useUnicodeExtraFields;
    private final InputStream in;
    private final Inflater inf = new Inflater(true);
    private final CRC32 crc = new CRC32();
    private final Buffer buf = new Buffer();
    private CurrentEntry current = null;
    private boolean closed = false;
    private boolean hitCentralDirectory = false;
    private ByteArrayInputStream lastStoredEntry = null;
    private boolean allowStoredEntriesWithDataDescriptor = false;
    private static final int LFH_LEN = 30;
    private static final long TWO_EXP_32 = 0x100000000L;
    private static final byte[] LFH = ZipLong.LFH_SIG.getBytes();
    private static final byte[] CFH = ZipLong.CFH_SIG.getBytes();
    private static final byte[] DD = ZipLong.DD_SIG.getBytes();

    public ZipArchiveInputStream(InputStream inputStream) {
        this(inputStream, "UTF8", true);
    }

    public ZipArchiveInputStream(InputStream inputStream, String encoding, boolean useUnicodeExtraFields) {
        this(inputStream, encoding, useUnicodeExtraFields, false);
    }

    public ZipArchiveInputStream(InputStream inputStream, String encoding, boolean useUnicodeExtraFields, boolean allowStoredEntriesWithDataDescriptor) {
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(encoding);
        this.useUnicodeExtraFields = useUnicodeExtraFields;
        this.in = new PushbackInputStream(inputStream, this.buf.buf.length);
        this.allowStoredEntriesWithDataDescriptor = allowStoredEntriesWithDataDescriptor;
    }

    public ZipArchiveEntry getNextZipEntry() throws IOException {
        if (this.closed || this.hitCentralDirectory) {
            return null;
        }
        if (this.current != null) {
            this.closeEntry();
        }
        byte[] lfh = new byte[30];
        try {
            this.readFully(lfh);
        }
        catch (EOFException e) {
            return null;
        }
        ZipLong sig = new ZipLong(lfh);
        if (sig.equals(ZipLong.CFH_SIG)) {
            this.hitCentralDirectory = true;
            return null;
        }
        if (!sig.equals(ZipLong.LFH_SIG)) {
            return null;
        }
        int off = 4;
        this.current = new CurrentEntry();
        int versionMadeBy = ZipShort.getValue(lfh, off);
        this.current.entry.setPlatform(versionMadeBy >> 8 & 0xF);
        GeneralPurposeBit gpFlag = GeneralPurposeBit.parse(lfh, off += 2);
        boolean hasUTF8Flag = gpFlag.usesUTF8ForNames();
        ZipEncoding entryEncoding = hasUTF8Flag ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        this.current.hasDataDescriptor = gpFlag.usesDataDescriptor();
        this.current.entry.setGeneralPurposeBit(gpFlag);
        this.current.entry.setMethod(ZipShort.getValue(lfh, off += 2));
        long time = ZipUtil.dosToJavaTime(ZipLong.getValue(lfh, off += 2));
        this.current.entry.setTime(time);
        off += 4;
        ZipLong size2 = null;
        ZipLong cSize = null;
        if (!this.current.hasDataDescriptor) {
            this.current.entry.setCrc(ZipLong.getValue(lfh, off));
            cSize = new ZipLong(lfh, off += 4);
            size2 = new ZipLong(lfh, off += 4);
            off += 4;
        } else {
            off += 12;
        }
        int fileNameLen = ZipShort.getValue(lfh, off);
        int extraLen = ZipShort.getValue(lfh, off += 2);
        off += 2;
        byte[] fileName = new byte[fileNameLen];
        this.readFully(fileName);
        this.current.entry.setName(entryEncoding.decode(fileName), fileName);
        byte[] extraData = new byte[extraLen];
        this.readFully(extraData);
        this.current.entry.setExtra(extraData);
        if (!hasUTF8Flag && this.useUnicodeExtraFields) {
            ZipUtil.setNameAndCommentFromExtraFields(this.current.entry, fileName, null);
        }
        this.processZip64Extra(size2, cSize);
        return this.current.entry;
    }

    private void processZip64Extra(ZipLong size2, ZipLong cSize) {
        Zip64ExtendedInformationExtraField z64 = (Zip64ExtendedInformationExtraField)this.current.entry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        this.current.usesZip64 = z64 != null;
        if (!this.current.hasDataDescriptor) {
            if (this.current.usesZip64 && (cSize.equals(ZipLong.ZIP64_MAGIC) || size2.equals(ZipLong.ZIP64_MAGIC))) {
                this.current.entry.setCompressedSize(z64.getCompressedSize().getLongValue());
                this.current.entry.setSize(z64.getSize().getLongValue());
            } else {
                this.current.entry.setCompressedSize(cSize.getValue());
                this.current.entry.setSize(size2.getValue());
            }
        }
    }

    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextZipEntry();
    }

    public boolean canReadEntryData(ArchiveEntry ae) {
        if (ae instanceof ZipArchiveEntry) {
            ZipArchiveEntry ze = (ZipArchiveEntry)ae;
            return ZipUtil.canHandleEntryData(ze) && this.supportsDataDescriptorFor(ze);
        }
        return false;
    }

    public int read(byte[] buffer, int start, int length) throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.inf.finished() || this.current == null) {
            return -1;
        }
        if (start <= buffer.length && length >= 0 && start >= 0 && buffer.length - start >= length) {
            ZipUtil.checkRequestedFeatures(this.current.entry);
            if (!this.supportsDataDescriptorFor(this.current.entry)) {
                throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.DATA_DESCRIPTOR, this.current.entry);
            }
            if (this.current.entry.getMethod() == 0) {
                return this.readStored(buffer, start, length);
            }
            return this.readDeflated(buffer, start, length);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private int readStored(byte[] buffer, int start, int length) throws IOException {
        int toRead;
        if (this.current.hasDataDescriptor) {
            if (this.lastStoredEntry == null) {
                this.readStoredEntry();
            }
            return this.lastStoredEntry.read(buffer, start, length);
        }
        long csize = this.current.entry.getSize();
        if (this.current.bytesRead >= csize) {
            return -1;
        }
        if (this.buf.offsetInBuffer >= this.buf.lengthOfLastRead) {
            this.buf.offsetInBuffer = 0;
            if ((this.buf.lengthOfLastRead = this.in.read(this.buf.buf)) == -1) {
                return -1;
            }
            this.count(this.buf.lengthOfLastRead);
            this.current.bytesReadFromStream += this.buf.lengthOfLastRead;
        }
        int n = toRead = length > this.buf.lengthOfLastRead ? this.buf.lengthOfLastRead - this.buf.offsetInBuffer : length;
        if (csize - this.current.bytesRead < (long)toRead) {
            toRead = (int)(csize - this.current.bytesRead);
        }
        System.arraycopy(this.buf.buf, this.buf.offsetInBuffer, buffer, start, toRead);
        this.buf.offsetInBuffer += toRead;
        this.current.bytesRead += toRead;
        this.crc.update(buffer, start, toRead);
        return toRead;
    }

    private int readDeflated(byte[] buffer, int start, int length) throws IOException {
        if (this.inf.needsInput()) {
            this.fill();
            if (this.buf.lengthOfLastRead > 0) {
                this.current.bytesReadFromStream += this.buf.lengthOfLastRead;
            }
        }
        int read2 = 0;
        try {
            read2 = this.inf.inflate(buffer, start, length);
        }
        catch (DataFormatException e) {
            throw new ZipException(e.getMessage());
        }
        if (read2 == 0) {
            if (this.inf.finished()) {
                return -1;
            }
            if (this.buf.lengthOfLastRead == -1) {
                throw new IOException("Truncated ZIP file");
            }
        }
        this.crc.update(buffer, start, read2);
        return read2;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
            this.inf.end();
        }
    }

    public long skip(long value2) throws IOException {
        if (value2 >= 0L) {
            long skipped;
            int x;
            byte[] b = new byte[1024];
            for (skipped = 0L; skipped < value2; skipped += (long)x) {
                long rem = value2 - skipped;
                x = this.read(b, 0, (int)((long)b.length > rem ? rem : (long)b.length));
                if (x != -1) continue;
                return skipped;
            }
            return skipped;
        }
        throw new IllegalArgumentException();
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < ZipArchiveOutputStream.LFH_SIG.length) {
            return false;
        }
        return ZipArchiveInputStream.checksig(signature, ZipArchiveOutputStream.LFH_SIG) || ZipArchiveInputStream.checksig(signature, ZipArchiveOutputStream.EOCD_SIG);
    }

    private static boolean checksig(byte[] signature, byte[] expected) {
        for (int i = 0; i < expected.length; ++i) {
            if (signature[i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    private void closeEntry() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return;
        }
        if (this.current.bytesReadFromStream <= this.current.entry.getCompressedSize() && !this.current.hasDataDescriptor) {
            this.drainCurrentEntryData();
        } else {
            this.skip(Long.MAX_VALUE);
            long inB = this.current.entry.getMethod() == 8 ? this.getBytesInflated() : this.current.bytesRead;
            int diff2 = (int)(this.current.bytesReadFromStream - inB);
            if (diff2 > 0) {
                this.pushback(this.buf.buf, this.buf.lengthOfLastRead - diff2, diff2);
            }
        }
        if (this.lastStoredEntry == null && this.current.hasDataDescriptor) {
            this.readDataDescriptor();
        }
        this.inf.reset();
        this.buf.reset();
        this.crc.reset();
        this.current = null;
        this.lastStoredEntry = null;
    }

    private void drainCurrentEntryData() throws IOException {
        long n;
        for (long remaining = this.current.entry.getCompressedSize() - this.current.bytesReadFromStream; remaining > 0L; remaining -= n) {
            n = this.in.read(this.buf.buf, 0, (int)Math.min((long)this.buf.buf.length, remaining));
            if (n < 0L) {
                throw new EOFException("Truncated ZIP entry: " + this.current.entry.getName());
            }
            this.count(n);
        }
    }

    private long getBytesInflated() {
        long inB = this.inf.getBytesRead();
        if (this.current.bytesReadFromStream >= 0x100000000L) {
            while (inB + 0x100000000L <= this.current.bytesReadFromStream) {
                inB += 0x100000000L;
            }
        }
        return inB;
    }

    private void fill() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if ((this.buf.lengthOfLastRead = this.in.read(this.buf.buf)) > 0) {
            this.count(this.buf.lengthOfLastRead);
            this.inf.setInput(this.buf.buf, 0, this.buf.lengthOfLastRead);
        }
    }

    private void readFully(byte[] b) throws IOException {
        int x = 0;
        for (int count2 = 0; count2 != b.length; count2 += x) {
            x = this.in.read(b, count2, b.length - count2);
            if (x == -1) {
                throw new EOFException();
            }
            this.count(x);
        }
    }

    private void readDataDescriptor() throws IOException {
        byte[] b = new byte[4];
        this.readFully(b);
        ZipLong val = new ZipLong(b);
        if (ZipLong.DD_SIG.equals(val)) {
            this.readFully(b);
            val = new ZipLong(b);
        }
        this.current.entry.setCrc(val.getValue());
        b = new byte[16];
        this.readFully(b);
        ZipLong potentialSig = new ZipLong(b, 8);
        if (potentialSig.equals(ZipLong.CFH_SIG) || potentialSig.equals(ZipLong.LFH_SIG)) {
            this.pushback(b, 8, 8);
            this.current.entry.setCompressedSize(ZipLong.getValue(b));
            this.current.entry.setSize(ZipLong.getValue(b, 4));
        } else {
            this.current.entry.setCompressedSize(ZipEightByteInteger.getLongValue(b));
            this.current.entry.setSize(ZipEightByteInteger.getLongValue(b, 8));
        }
    }

    private boolean supportsDataDescriptorFor(ZipArchiveEntry entry2) {
        return this.allowStoredEntriesWithDataDescriptor || !entry2.getGeneralPurposeBit().usesDataDescriptor() || entry2.getMethod() == 8;
    }

    private void readStoredEntry() throws IOException {
        int ddLen;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int off = 0;
        boolean done = false;
        int n = ddLen = this.current.usesZip64 ? 20 : 12;
        while (!done) {
            int r = this.in.read(this.buf.buf, off, 512 - off);
            if (r <= 0) {
                throw new IOException("Truncated ZIP file");
            }
            if (r + off < 4) {
                off += r;
                continue;
            }
            done = this.bufferContainsSignature(bos, off, r, ddLen);
            if (done) continue;
            off = this.cacheBytesRead(bos, off, r, ddLen);
        }
        byte[] b = bos.toByteArray();
        this.lastStoredEntry = new ByteArrayInputStream(b);
    }

    private boolean bufferContainsSignature(ByteArrayOutputStream bos, int offset2, int lastRead, int expectedDDLen) throws IOException {
        boolean done = false;
        int readTooMuch = 0;
        for (int i = 0; !done && i < lastRead - 4; ++i) {
            if (this.buf.buf[i] != LFH[0] || this.buf.buf[i + 1] != LFH[1]) continue;
            if (this.buf.buf[i + 2] == LFH[2] && this.buf.buf[i + 3] == LFH[3] || this.buf.buf[i] == CFH[2] && this.buf.buf[i + 3] == CFH[3]) {
                readTooMuch = offset2 + lastRead - i - expectedDDLen;
                done = true;
            } else if (this.buf.buf[i + 2] == DD[2] && this.buf.buf[i + 3] == DD[3]) {
                readTooMuch = offset2 + lastRead - i;
                done = true;
            }
            if (!done) continue;
            this.pushback(this.buf.buf, offset2 + lastRead - readTooMuch, readTooMuch);
            bos.write(this.buf.buf, 0, i);
            this.readDataDescriptor();
        }
        return done;
    }

    private int cacheBytesRead(ByteArrayOutputStream bos, int offset2, int lastRead, int expecteDDLen) {
        int cacheable = offset2 + lastRead - expecteDDLen - 3;
        if (cacheable > 0) {
            bos.write(this.buf.buf, 0, cacheable);
            System.arraycopy(this.buf.buf, cacheable, this.buf.buf, 0, expecteDDLen + 3);
            offset2 = expecteDDLen + 3;
        } else {
            offset2 += lastRead;
        }
        return offset2;
    }

    private void pushback(byte[] buf, int offset2, int length) throws IOException {
        ((PushbackInputStream)this.in).unread(buf, offset2, length);
        this.pushedBackBytes(length);
    }

    private static final class Buffer {
        private final byte[] buf = new byte[512];
        private int offsetInBuffer = 0;
        private int lengthOfLastRead = 0;

        private Buffer() {
        }

        private void reset() {
            this.lengthOfLastRead = 0;
            this.offsetInBuffer = 0;
        }
    }

    private static final class CurrentEntry {
        private final ZipArchiveEntry entry = new ZipArchiveEntry();
        private boolean hasDataDescriptor;
        private boolean usesZip64;
        private long bytesRead;
        private long bytesReadFromStream;

        private CurrentEntry() {
        }
    }
}

