/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataConfiguration
extends AbstractConfiguration
implements Serializable {
    public static final String DATE_FORMAT_KEY = "org.apache.commons.configuration.format.date";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final long serialVersionUID = -69011336405718640L;
    protected Configuration configuration;

    public DataConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Object getProperty(String key) {
        return this.configuration.getProperty(key);
    }

    @Override
    protected void addPropertyDirect(String key, Object obj) {
        if (this.configuration instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.configuration).addPropertyDirect(key, obj);
        } else {
            this.configuration.addProperty(key, obj);
        }
    }

    @Override
    public void addProperty(String key, Object value2) {
        this.getConfiguration().addProperty(key, value2);
    }

    @Override
    public boolean isEmpty() {
        return this.configuration.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.configuration.containsKey(key);
    }

    @Override
    public void clearProperty(String key) {
        this.configuration.clearProperty(key);
    }

    @Override
    public void setProperty(String key, Object value2) {
        this.configuration.setProperty(key, value2);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.configuration.getKeys();
    }

    public <T> T get(Class<T> cls, String key) {
        T value2 = this.get(cls, key, null);
        if (value2 != null) {
            return value2;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public <T> T get(Class<T> cls, String key, T defaultValue) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        if (Date.class.equals(cls) || Calendar.class.equals(cls)) {
            return DataConfiguration.convert(cls, key, this.interpolate(value2), new String[]{this.getDefaultDateFormat()});
        }
        return DataConfiguration.convert(cls, key, this.interpolate(value2), null);
    }

    public <T> List<T> getList(Class<T> cls, String key) {
        return this.getList(cls, key, new ArrayList());
    }

    public <T> List<T> getList(Class<T> cls, String key, List<T> defaultValue) {
        List<T> list;
        Class<?> valueClass;
        Object value2 = this.getProperty(key);
        Class<?> clazz = valueClass = value2 != null ? value2.getClass() : null;
        if (value2 == null || value2 instanceof String && StringUtils.isEmpty((String)value2)) {
            list = defaultValue;
        } else {
            list = new ArrayList<T>();
            Object[] params = null;
            if (cls.equals(Date.class) || cls.equals(Calendar.class)) {
                params = new Object[]{this.getDefaultDateFormat()};
            }
            if (valueClass.isArray()) {
                Class<?> arrayType = valueClass.getComponentType();
                int length = Array.getLength(value2);
                if (arrayType.equals(cls) || arrayType.isPrimitive() && cls.equals(ClassUtils.primitiveToWrapper(arrayType))) {
                    for (int i = 0; i < length; ++i) {
                        list.add(cls.cast(Array.get(value2, i)));
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        list.add(DataConfiguration.convert(cls, key, this.interpolate(Array.get(value2, i)), params));
                    }
                }
            } else if (value2 instanceof Collection) {
                Collection values = (Collection)value2;
                for (Object o : values) {
                    list.add(DataConfiguration.convert(cls, key, this.interpolate(o), params));
                }
            } else {
                list.add(DataConfiguration.convert(cls, key, this.interpolate(value2), params));
            }
        }
        return list;
    }

    public Object getArray(Class<?> cls, String key) {
        return this.getArray(cls, key, Array.newInstance(cls, 0));
    }

    public Object getArray(Class<?> cls, String key, Object defaultValue) {
        if (!(defaultValue == null || defaultValue.getClass().isArray() && cls.isAssignableFrom(defaultValue.getClass().getComponentType()))) {
            throw new IllegalArgumentException("The type of the default value (" + defaultValue.getClass() + ")" + " is not an array of the specified class (" + cls + ")");
        }
        if (cls.isPrimitive()) {
            return this.getPrimitiveArray(cls, key, defaultValue);
        }
        List<?> list = this.getList(cls, key);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray((Object[])Array.newInstance(cls, list.size()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getPrimitiveArray(Class<?> cls, String key, Object defaultValue) {
        Object array;
        Object value2 = this.getProperty(key);
        Class<?> valueClass = value2 != null ? value2.getClass() : null;
        if (value2 == null) return defaultValue;
        if (value2 instanceof String && StringUtils.isEmpty((String)value2)) {
            return defaultValue;
        }
        if (valueClass.isArray()) {
            Class<?> arrayType = valueClass.getComponentType();
            int length = Array.getLength(value2);
            if (arrayType.equals(cls)) {
                return value2;
            }
            if (!arrayType.equals(ClassUtils.primitiveToWrapper(cls))) throw new ConversionException('\'' + key + "' (" + arrayType + ")" + " doesn't map to a compatible array of " + cls);
            array = Array.newInstance(cls, length);
            int i = 0;
            while (i < length) {
                Array.set(array, i, Array.get(value2, i));
                ++i;
            }
            return array;
        }
        if (value2 instanceof Collection) {
            Collection values = (Collection)value2;
            array = Array.newInstance(cls, values.size());
            int i = 0;
            Iterator i$ = values.iterator();
            while (i$.hasNext()) {
                Object o = i$.next();
                Object convertedValue = DataConfiguration.convert(ClassUtils.primitiveToWrapper(cls), key, this.interpolate(o), null);
                Array.set(array, i++, convertedValue);
            }
            return array;
        }
        Object convertedValue = DataConfiguration.convert(ClassUtils.primitiveToWrapper(cls), key, this.interpolate(value2), null);
        array = Array.newInstance(cls, 1);
        Array.set(array, 0, convertedValue);
        return array;
    }

    public List<Boolean> getBooleanList(String key) {
        return this.getBooleanList(key, new ArrayList<Boolean>());
    }

    public List<Boolean> getBooleanList(String key, List<Boolean> defaultValue) {
        return this.getList(Boolean.class, key, defaultValue);
    }

    public boolean[] getBooleanArray(String key) {
        return (boolean[])this.getArray(Boolean.TYPE, key);
    }

    public boolean[] getBooleanArray(String key, boolean[] defaultValue) {
        return (boolean[])this.getArray(Boolean.TYPE, key, defaultValue);
    }

    public List<Byte> getByteList(String key) {
        return this.getByteList(key, new ArrayList<Byte>());
    }

    public List<Byte> getByteList(String key, List<Byte> defaultValue) {
        return this.getList(Byte.class, key, defaultValue);
    }

    public byte[] getByteArray(String key) {
        return this.getByteArray(key, new byte[0]);
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        return (byte[])this.getArray(Byte.TYPE, key, defaultValue);
    }

    public List<Short> getShortList(String key) {
        return this.getShortList(key, new ArrayList<Short>());
    }

    public List<Short> getShortList(String key, List<Short> defaultValue) {
        return this.getList(Short.class, key, defaultValue);
    }

    public short[] getShortArray(String key) {
        return this.getShortArray(key, new short[0]);
    }

    public short[] getShortArray(String key, short[] defaultValue) {
        return (short[])this.getArray(Short.TYPE, key, defaultValue);
    }

    public List<Integer> getIntegerList(String key) {
        return this.getIntegerList(key, new ArrayList<Integer>());
    }

    public List<Integer> getIntegerList(String key, List<Integer> defaultValue) {
        return this.getList(Integer.class, key, defaultValue);
    }

    public int[] getIntArray(String key) {
        return this.getIntArray(key, new int[0]);
    }

    public int[] getIntArray(String key, int[] defaultValue) {
        return (int[])this.getArray(Integer.TYPE, key, defaultValue);
    }

    public List<Long> getLongList(String key) {
        return this.getLongList(key, new ArrayList<Long>());
    }

    public List<Long> getLongList(String key, List<Long> defaultValue) {
        return this.getList(Long.class, key, defaultValue);
    }

    public long[] getLongArray(String key) {
        return this.getLongArray(key, new long[0]);
    }

    public long[] getLongArray(String key, long[] defaultValue) {
        return (long[])this.getArray(Long.TYPE, key, defaultValue);
    }

    public List<Float> getFloatList(String key) {
        return this.getFloatList(key, new ArrayList<Float>());
    }

    public List<Float> getFloatList(String key, List<Float> defaultValue) {
        return this.getList(Float.class, key, defaultValue);
    }

    public float[] getFloatArray(String key) {
        return this.getFloatArray(key, new float[0]);
    }

    public float[] getFloatArray(String key, float[] defaultValue) {
        return (float[])this.getArray(Float.TYPE, key, defaultValue);
    }

    public List<Double> getDoubleList(String key) {
        return this.getDoubleList(key, new ArrayList<Double>());
    }

    public List<Double> getDoubleList(String key, List<Double> defaultValue) {
        return this.getList(Double.class, key, defaultValue);
    }

    public double[] getDoubleArray(String key) {
        return this.getDoubleArray(key, new double[0]);
    }

    public double[] getDoubleArray(String key, double[] defaultValue) {
        return (double[])this.getArray(Double.TYPE, key, defaultValue);
    }

    public List<BigInteger> getBigIntegerList(String key) {
        return this.getBigIntegerList(key, new ArrayList<BigInteger>());
    }

    public List<BigInteger> getBigIntegerList(String key, List<BigInteger> defaultValue) {
        return this.getList(BigInteger.class, key, defaultValue);
    }

    public BigInteger[] getBigIntegerArray(String key) {
        return this.getBigIntegerArray(key, new BigInteger[0]);
    }

    public BigInteger[] getBigIntegerArray(String key, BigInteger[] defaultValue) {
        return (BigInteger[])this.getArray(BigInteger.class, key, defaultValue);
    }

    public List<BigDecimal> getBigDecimalList(String key) {
        return this.getBigDecimalList(key, new ArrayList<BigDecimal>());
    }

    public List<BigDecimal> getBigDecimalList(String key, List<BigDecimal> defaultValue) {
        return this.getList(BigDecimal.class, key, defaultValue);
    }

    public BigDecimal[] getBigDecimalArray(String key) {
        return this.getBigDecimalArray(key, new BigDecimal[0]);
    }

    public BigDecimal[] getBigDecimalArray(String key, BigDecimal[] defaultValue) {
        return (BigDecimal[])this.getArray(BigDecimal.class, key, defaultValue);
    }

    public URL getURL(String key) {
        return this.get(URL.class, key);
    }

    public URL getURL(String key, URL defaultValue) {
        return this.get(URL.class, key, defaultValue);
    }

    public List<URL> getURLList(String key) {
        return this.getURLList(key, new ArrayList<URL>());
    }

    public List<URL> getURLList(String key, List<URL> defaultValue) {
        return this.getList(URL.class, key, defaultValue);
    }

    public URL[] getURLArray(String key) {
        return this.getURLArray(key, new URL[0]);
    }

    public URL[] getURLArray(String key, URL[] defaultValue) {
        return (URL[])this.getArray(URL.class, key, defaultValue);
    }

    public Date getDate(String key) {
        return this.get(Date.class, key);
    }

    public Date getDate(String key, String format2) {
        Date value2 = this.getDate(key, null, format2);
        if (value2 != null) {
            return value2;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public Date getDate(String key, Date defaultValue) {
        return this.getDate(key, defaultValue, this.getDefaultDateFormat());
    }

    public Date getDate(String key, Date defaultValue, String format2) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toDate(this.interpolate(value2), format2);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Date", e);
        }
    }

    public List<Date> getDateList(String key) {
        return this.getDateList(key, new ArrayList<Date>());
    }

    public List<Date> getDateList(String key, String format2) {
        return this.getDateList(key, new ArrayList<Date>(), format2);
    }

    public List<Date> getDateList(String key, List<Date> defaultValue) {
        return this.getDateList(key, defaultValue, this.getDefaultDateFormat());
    }

    public List<Date> getDateList(String key, List<Date> defaultValue, String format2) {
        List<Date> list;
        Object value2 = this.getProperty(key);
        if (value2 == null || value2 instanceof String && StringUtils.isEmpty((String)value2)) {
            list = defaultValue;
        } else if (value2.getClass().isArray()) {
            list = new ArrayList<Date>();
            int length = Array.getLength(value2);
            for (int i = 0; i < length; ++i) {
                list.add(DataConfiguration.convert(Date.class, key, this.interpolate(Array.get(value2, i)), new String[]{format2}));
            }
        } else if (value2 instanceof Collection) {
            Collection values = (Collection)value2;
            list = new ArrayList<Date>();
            for (Object o : values) {
                list.add(DataConfiguration.convert(Date.class, key, this.interpolate(o), new String[]{format2}));
            }
        } else {
            list = new ArrayList<Date>();
            list.add(DataConfiguration.convert(Date.class, key, this.interpolate(value2), new String[]{format2}));
        }
        return list;
    }

    public Date[] getDateArray(String key) {
        return this.getDateArray(key, new Date[0]);
    }

    public Date[] getDateArray(String key, String format2) {
        return this.getDateArray(key, new Date[0], format2);
    }

    public Date[] getDateArray(String key, Date[] defaultValue) {
        return this.getDateArray(key, defaultValue, this.getDefaultDateFormat());
    }

    public Date[] getDateArray(String key, Date[] defaultValue, String format2) {
        List<Date> list = this.getDateList(key, format2);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new Date[list.size()]);
    }

    public Calendar getCalendar(String key) {
        return this.get(Calendar.class, key);
    }

    public Calendar getCalendar(String key, String format2) {
        Calendar value2 = this.getCalendar(key, null, format2);
        if (value2 != null) {
            return value2;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public Calendar getCalendar(String key, Calendar defaultValue) {
        return this.getCalendar(key, defaultValue, this.getDefaultDateFormat());
    }

    public Calendar getCalendar(String key, Calendar defaultValue, String format2) {
        Object value2 = this.resolveContainerStore(key);
        if (value2 == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toCalendar(this.interpolate(value2), format2);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Calendar", e);
        }
    }

    public List<Calendar> getCalendarList(String key) {
        return this.getCalendarList(key, new ArrayList<Calendar>());
    }

    public List<Calendar> getCalendarList(String key, String format2) {
        return this.getCalendarList(key, new ArrayList<Calendar>(), format2);
    }

    public List<Calendar> getCalendarList(String key, List<Calendar> defaultValue) {
        return this.getCalendarList(key, defaultValue, this.getDefaultDateFormat());
    }

    public List<Calendar> getCalendarList(String key, List<Calendar> defaultValue, String format2) {
        List<Calendar> list;
        Object value2 = this.getProperty(key);
        if (value2 == null || value2 instanceof String && StringUtils.isEmpty((String)value2)) {
            list = defaultValue;
        } else if (value2.getClass().isArray()) {
            list = new ArrayList<Calendar>();
            int length = Array.getLength(value2);
            for (int i = 0; i < length; ++i) {
                list.add(DataConfiguration.convert(Calendar.class, key, this.interpolate(Array.get(value2, i)), new String[]{format2}));
            }
        } else if (value2 instanceof Collection) {
            Collection values = (Collection)value2;
            list = new ArrayList<Calendar>();
            for (Object o : values) {
                list.add(DataConfiguration.convert(Calendar.class, key, this.interpolate(o), new String[]{format2}));
            }
        } else {
            list = new ArrayList<Calendar>();
            list.add(DataConfiguration.convert(Calendar.class, key, this.interpolate(value2), new String[]{format2}));
        }
        return list;
    }

    public Calendar[] getCalendarArray(String key) {
        return this.getCalendarArray(key, new Calendar[0]);
    }

    public Calendar[] getCalendarArray(String key, String format2) {
        return this.getCalendarArray(key, new Calendar[0], format2);
    }

    public Calendar[] getCalendarArray(String key, Calendar[] defaultValue) {
        return this.getCalendarArray(key, defaultValue, this.getDefaultDateFormat());
    }

    public Calendar[] getCalendarArray(String key, Calendar[] defaultValue, String format2) {
        List<Calendar> list = this.getCalendarList(key, format2);
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.toArray(new Calendar[list.size()]);
    }

    private String getDefaultDateFormat() {
        return this.getString(DATE_FORMAT_KEY, DEFAULT_DATE_FORMAT);
    }

    public Locale getLocale(String key) {
        return this.get(Locale.class, key);
    }

    public Locale getLocale(String key, Locale defaultValue) {
        return this.get(Locale.class, key, defaultValue);
    }

    public List<Locale> getLocaleList(String key) {
        return this.getLocaleList(key, new ArrayList<Locale>());
    }

    public List<Locale> getLocaleList(String key, List<Locale> defaultValue) {
        return this.getList(Locale.class, key, defaultValue);
    }

    public Locale[] getLocaleArray(String key) {
        return this.getLocaleArray(key, new Locale[0]);
    }

    public Locale[] getLocaleArray(String key, Locale[] defaultValue) {
        return (Locale[])this.getArray(Locale.class, key, defaultValue);
    }

    public Color getColor(String key) {
        return this.get(Color.class, key);
    }

    public Color getColor(String key, Color defaultValue) {
        return this.get(Color.class, key, defaultValue);
    }

    public List<Color> getColorList(String key) {
        return this.getColorList(key, new ArrayList<Color>());
    }

    public List<Color> getColorList(String key, List<Color> defaultValue) {
        return this.getList(Color.class, key, defaultValue);
    }

    public Color[] getColorArray(String key) {
        return this.getColorArray(key, new Color[0]);
    }

    public Color[] getColorArray(String key, Color[] defaultValue) {
        return (Color[])this.getArray(Color.class, key, defaultValue);
    }

    private static <T> T convert(Class<T> cls, String key, Object value2, Object[] params) {
        try {
            Object result2 = PropertyConverter.to(cls, value2, params);
            return cls.cast(result2);
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a " + cls, e);
        }
    }
}

