/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.awt.Color;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyConverter {
    static final char LIST_ESC_CHAR = '\\';
    static final String LIST_ESCAPE = String.valueOf('\\');
    private static final String HEX_PREFIX = "0x";
    private static final int HEX_RADIX = 16;
    private static final String BIN_PREFIX = "0b";
    private static final int BIN_RADIX = 2;
    private static final Class<?>[] CONSTR_ARGS = new Class[]{String.class};
    private static final String INTERNET_ADDRESS_CLASSNAME = "javax.mail.internet.InternetAddress";

    private PropertyConverter() {
    }

    static Object to(Class<?> cls, Object value2, Object[] params) throws ConversionException {
        if (cls.isInstance(value2)) {
            return value2;
        }
        if (Boolean.class.equals(cls) || Boolean.TYPE.equals(cls)) {
            return PropertyConverter.toBoolean(value2);
        }
        if (Character.class.equals(cls) || Character.TYPE.equals(cls)) {
            return PropertyConverter.toCharacter(value2);
        }
        if (Number.class.isAssignableFrom(cls) || cls.isPrimitive()) {
            if (Integer.class.equals(cls) || Integer.TYPE.equals(cls)) {
                return PropertyConverter.toInteger(value2);
            }
            if (Long.class.equals(cls) || Long.TYPE.equals(cls)) {
                return PropertyConverter.toLong(value2);
            }
            if (Byte.class.equals(cls) || Byte.TYPE.equals(cls)) {
                return PropertyConverter.toByte(value2);
            }
            if (Short.class.equals(cls) || Short.TYPE.equals(cls)) {
                return PropertyConverter.toShort(value2);
            }
            if (Float.class.equals(cls) || Float.TYPE.equals(cls)) {
                return PropertyConverter.toFloat(value2);
            }
            if (Double.class.equals(cls) || Double.TYPE.equals(cls)) {
                return PropertyConverter.toDouble(value2);
            }
            if (BigInteger.class.equals(cls)) {
                return PropertyConverter.toBigInteger(value2);
            }
            if (BigDecimal.class.equals(cls)) {
                return PropertyConverter.toBigDecimal(value2);
            }
        } else {
            if (Date.class.equals(cls)) {
                return PropertyConverter.toDate(value2, (String)params[0]);
            }
            if (Calendar.class.equals(cls)) {
                return PropertyConverter.toCalendar(value2, (String)params[0]);
            }
            if (URL.class.equals(cls)) {
                return PropertyConverter.toURL(value2);
            }
            if (Locale.class.equals(cls)) {
                return PropertyConverter.toLocale(value2);
            }
            if (PropertyConverter.isEnum(cls)) {
                return PropertyConverter.convertToEnum(cls, value2);
            }
            if (Color.class.equals(cls)) {
                return PropertyConverter.toColor(value2);
            }
            if (cls.getName().equals(INTERNET_ADDRESS_CLASSNAME)) {
                return PropertyConverter.toInternetAddress(value2);
            }
            if (InetAddress.class.isAssignableFrom(cls)) {
                return PropertyConverter.toInetAddress(value2);
            }
        }
        throw new ConversionException("The value '" + value2 + "' (" + value2.getClass() + ")" + " can't be converted to a " + cls.getName() + " object");
    }

    public static Boolean toBoolean(Object value2) throws ConversionException {
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof String) {
            Boolean b = BooleanUtils.toBooleanObject((String)value2);
            if (b == null) {
                throw new ConversionException("The value " + value2 + " can't be converted to a Boolean object");
            }
            return b;
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a Boolean object");
    }

    public static Character toCharacter(Object value2) throws ConversionException {
        String strValue = String.valueOf(value2);
        if (strValue.length() == 1) {
            return Character.valueOf(strValue.charAt(0));
        }
        throw new ConversionException(String.format("The value '%s' cannot be converted to a Character object!", strValue));
    }

    public static Byte toByte(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, Byte.class);
        if (n instanceof Byte) {
            return (Byte)n;
        }
        return new Byte(n.byteValue());
    }

    public static Short toShort(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, Short.class);
        if (n instanceof Short) {
            return (Short)n;
        }
        return new Short(n.shortValue());
    }

    public static Integer toInteger(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, Integer.class);
        if (n instanceof Integer) {
            return (Integer)n;
        }
        return new Integer(n.intValue());
    }

    public static Long toLong(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, Long.class);
        if (n instanceof Long) {
            return (Long)n;
        }
        return new Long(n.longValue());
    }

    public static Float toFloat(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, Float.class);
        if (n instanceof Float) {
            return (Float)n;
        }
        return new Float(n.floatValue());
    }

    public static Double toDouble(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, Double.class);
        if (n instanceof Double) {
            return (Double)n;
        }
        return new Double(n.doubleValue());
    }

    public static BigInteger toBigInteger(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, BigInteger.class);
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        return BigInteger.valueOf(n.longValue());
    }

    public static BigDecimal toBigDecimal(Object value2) throws ConversionException {
        Number n = PropertyConverter.toNumber(value2, BigDecimal.class);
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return new BigDecimal(n.doubleValue());
    }

    static Number toNumber(Object value2, Class<?> targetClass) throws ConversionException {
        if (value2 instanceof Number) {
            return (Number)value2;
        }
        String str = value2.toString();
        if (str.startsWith(HEX_PREFIX)) {
            try {
                return new BigInteger(str.substring(HEX_PREFIX.length()), 16);
            }
            catch (NumberFormatException nex) {
                throw new ConversionException("Could not convert " + str + " to " + targetClass.getName() + "! Invalid hex number.", nex);
            }
        }
        if (str.startsWith(BIN_PREFIX)) {
            try {
                return new BigInteger(str.substring(BIN_PREFIX.length()), 2);
            }
            catch (NumberFormatException nex) {
                throw new ConversionException("Could not convert " + str + " to " + targetClass.getName() + "! Invalid binary number.", nex);
            }
        }
        try {
            Constructor<?> constr = targetClass.getConstructor(CONSTR_ARGS);
            return (Number)constr.newInstance(str);
        }
        catch (InvocationTargetException itex) {
            throw new ConversionException("Could not convert " + str + " to " + targetClass.getName(), itex.getTargetException());
        }
        catch (Exception ex) {
            throw new ConversionException("Conversion error when trying to convert " + str + " to " + targetClass.getName(), ex);
        }
    }

    public static URL toURL(Object value2) throws ConversionException {
        if (value2 instanceof URL) {
            return (URL)value2;
        }
        if (value2 instanceof String) {
            try {
                return new URL((String)value2);
            }
            catch (MalformedURLException e) {
                throw new ConversionException("The value " + value2 + " can't be converted to an URL", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to an URL");
    }

    public static Locale toLocale(Object value2) throws ConversionException {
        if (value2 instanceof Locale) {
            return (Locale)value2;
        }
        if (value2 instanceof String) {
            List<String> elements = PropertyConverter.split((String)value2, '_');
            int size2 = elements.size();
            if (size2 >= 1 && (elements.get(0).length() == 2 || elements.get(0).length() == 0)) {
                String language2 = elements.get(0);
                String country = size2 >= 2 ? elements.get(1) : "";
                String variant = size2 >= 3 ? elements.get(2) : "";
                return new Locale(language2, country, variant);
            }
            throw new ConversionException("The value " + value2 + " can't be converted to a Locale");
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a Locale");
    }

    public static List<String> split(String s2, char delimiter, boolean trim) {
        if (s2 == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        boolean inEscape = false;
        for (int begin = 0; begin < s2.length(); ++begin) {
            char c = s2.charAt(begin);
            if (inEscape) {
                if (c != delimiter && c != '\\') {
                    token.append('\\');
                }
                token.append(c);
                inEscape = false;
                continue;
            }
            if (c == delimiter) {
                String t = token.toString();
                if (trim) {
                    t = t.trim();
                }
                list.add(t);
                token = new StringBuilder();
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            token.append(c);
        }
        if (inEscape) {
            token.append('\\');
        }
        String t = token.toString();
        if (trim) {
            t = t.trim();
        }
        list.add(t);
        return list;
    }

    public static List<String> split(String s2, char delimiter) {
        return PropertyConverter.split(s2, delimiter, true);
    }

    public static String escapeDelimiters(String s2, char delimiter) {
        String s1 = StringUtils.replace(s2, LIST_ESCAPE, LIST_ESCAPE + LIST_ESCAPE);
        return PropertyConverter.escapeListDelimiter(s1, delimiter);
    }

    public static String escapeListDelimiter(String s2, char delimiter) {
        return StringUtils.replace(s2, String.valueOf(delimiter), LIST_ESCAPE + delimiter);
    }

    public static Color toColor(Object value2) throws ConversionException {
        if (value2 instanceof Color) {
            return (Color)value2;
        }
        if (value2 instanceof String && !StringUtils.isBlank((String)value2)) {
            String color = ((String)value2).trim();
            int[] components = new int[3];
            int minlength = components.length * 2;
            if (color.length() < minlength) {
                throw new ConversionException("The value " + value2 + " can't be converted to a Color");
            }
            if (color.startsWith("#")) {
                color = color.substring(1);
            }
            try {
                for (int i = 0; i < components.length; ++i) {
                    components[i] = Integer.parseInt(color.substring(2 * i, 2 * i + 2), 16);
                }
                int alpha = color.length() >= minlength + 2 ? Integer.parseInt(color.substring(minlength, minlength + 2), 16) : Color.black.getAlpha();
                return new Color(components[0], components[1], components[2], alpha);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a Color", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a Color");
    }

    static InetAddress toInetAddress(Object value2) throws ConversionException {
        if (value2 instanceof InetAddress) {
            return (InetAddress)value2;
        }
        if (value2 instanceof String) {
            try {
                return InetAddress.getByName((String)value2);
            }
            catch (UnknownHostException e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a InetAddress", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a InetAddress");
    }

    static Object toInternetAddress(Object value2) throws ConversionException {
        if (value2.getClass().getName().equals(INTERNET_ADDRESS_CLASSNAME)) {
            return value2;
        }
        if (value2 instanceof String) {
            try {
                Constructor<?> ctor = Class.forName(INTERNET_ADDRESS_CLASSNAME).getConstructor(String.class);
                return ctor.newInstance(value2);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a InternetAddress", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a InternetAddress");
    }

    static boolean isEnum(Class<?> cls) {
        return cls.isEnum();
    }

    static <E extends Enum<E>> E toEnum(Object value2, Class<E> cls) throws ConversionException {
        if (value2.getClass().equals(cls)) {
            return (E)((Enum)cls.cast(value2));
        }
        if (value2 instanceof String) {
            try {
                return Enum.valueOf(cls, (String)value2);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a " + cls.getName());
            }
        }
        if (value2 instanceof Number) {
            try {
                Enum[] enumConstants = (Enum[])cls.getEnumConstants();
                return (E)enumConstants[((Number)value2).intValue()];
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a " + cls.getName());
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a " + cls.getName());
    }

    public static Date toDate(Object value2, String format2) throws ConversionException {
        if (value2 instanceof Date) {
            return (Date)value2;
        }
        if (value2 instanceof Calendar) {
            return ((Calendar)value2).getTime();
        }
        if (value2 instanceof String) {
            try {
                return new SimpleDateFormat(format2).parse((String)value2);
            }
            catch (ParseException e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a Date", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a Date");
    }

    public static Calendar toCalendar(Object value2, String format2) throws ConversionException {
        if (value2 instanceof Calendar) {
            return (Calendar)value2;
        }
        if (value2 instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value2);
            return calendar;
        }
        if (value2 instanceof String) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new SimpleDateFormat(format2).parse((String)value2));
                return calendar;
            }
            catch (ParseException e) {
                throw new ConversionException("The value " + value2 + " can't be converted to a Calendar", e);
            }
        }
        throw new ConversionException("The value " + value2 + " can't be converted to a Calendar");
    }

    public static Iterator<?> toIterator(Object value2, char delimiter) {
        return PropertyConverter.flatten(value2, delimiter).iterator();
    }

    private static Collection<?> flatten(Object value2, char delimiter) {
        String s2;
        if (value2 instanceof String && (s2 = (String)value2).indexOf(delimiter) > 0) {
            return PropertyConverter.split(s2, delimiter);
        }
        LinkedList<Object> result2 = new LinkedList<Object>();
        if (value2 instanceof Iterable) {
            PropertyConverter.flattenIterator(result2, ((Iterable)value2).iterator(), delimiter);
        } else if (value2 instanceof Iterator) {
            PropertyConverter.flattenIterator(result2, (Iterator)value2, delimiter);
        } else if (value2 != null) {
            if (value2.getClass().isArray()) {
                int len = Array.getLength(value2);
                for (int idx = 0; idx < len; ++idx) {
                    result2.addAll(PropertyConverter.flatten(Array.get(value2, idx), delimiter));
                }
            } else {
                result2.add(value2);
            }
        }
        return result2;
    }

    private static void flattenIterator(Collection<Object> target, Iterator<?> it, char delimiter) {
        while (it.hasNext()) {
            target.addAll(PropertyConverter.flatten(it.next(), delimiter));
        }
    }

    public static Object interpolate(Object value2, AbstractConfiguration config) {
        if (value2 instanceof String) {
            return config.getSubstitutor().replace((String)value2);
        }
        return value2;
    }

    private static Object convertToEnum(Class<?> enumClass, Object value2) {
        return PropertyConverter.toEnum(value2, enumClass.asSubclass(Enum.class));
    }
}

