/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.resolver.DefaultEntityResolver;
import org.apache.commons.configuration.resolver.EntityRegistry;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration
extends AbstractHierarchicalFileConfiguration
implements EntityResolver,
EntityRegistry {
    private static final long serialVersionUID = 2453781111653383552L;
    private static final String DEFAULT_ROOT_NAME = "configuration";
    private static final String ATTR_SPACE = "xml:space";
    private static final String VALUE_PRESERVE = "preserve";
    private static final char ATTR_VALUE_DELIMITER = '|';
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private Document document;
    private String rootElementName;
    private String publicID;
    private String systemID;
    private DocumentBuilder documentBuilder;
    private boolean validating;
    private boolean schemaValidation;
    private boolean attributeSplittingDisabled;
    private EntityResolver entityResolver = new DefaultEntityResolver();

    public XMLConfiguration() {
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(HierarchicalConfiguration c) {
        super(c);
        XMLConfiguration.clearReferences(this.getRootNode());
        this.setRootElementName(this.getRootNode().getName());
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(File file) throws ConfigurationException {
        super(file);
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public XMLConfiguration(URL url) throws ConfigurationException {
        super(url);
        this.setLogger(LogFactory.getLog(XMLConfiguration.class));
    }

    public String getRootElementName() {
        if (this.getDocument() == null) {
            return this.rootElementName == null ? DEFAULT_ROOT_NAME : this.rootElementName;
        }
        return this.getDocument().getDocumentElement().getNodeName();
    }

    public void setRootElementName(String name) {
        if (this.getDocument() != null) {
            throw new UnsupportedOperationException("The name of the root element cannot be changed when loaded from an XML document!");
        }
        this.rootElementName = name;
        this.getRootNode().setName(name);
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public void setPublicID(String publicID) {
        this.publicID = publicID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String systemID) {
        this.systemID = systemID;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        if (!this.schemaValidation) {
            this.validating = validating;
        }
    }

    public boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    public void setSchemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
        if (schemaValidation) {
            this.validating = true;
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public boolean isAttributeSplittingDisabled() {
        return this.attributeSplittingDisabled;
    }

    public void setAttributeSplittingDisabled(boolean attributeSplittingDisabled) {
        this.attributeSplittingDisabled = attributeSplittingDisabled;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public void clear() {
        super.clear();
        this.setRoot(new HierarchicalConfiguration.Node());
        this.document = null;
    }

    public void initProperties(Document document, boolean elemRefs) {
        if (document.getDoctype() != null) {
            this.setPublicID(document.getDoctype().getPublicId());
            this.setSystemID(document.getDoctype().getSystemId());
        }
        this.constructHierarchy(this.getRoot(), document.getDocumentElement(), elemRefs, true);
        this.getRootNode().setName(document.getDocumentElement().getNodeName());
        if (elemRefs) {
            this.getRoot().setReference(document.getDocumentElement());
        }
    }

    private Map<String, Collection<String>> constructHierarchy(HierarchicalConfiguration.Node node, Element element, boolean elemRefs, boolean trim) {
        boolean trimFlag = this.shouldTrim(element, trim);
        Map<String, Collection<String>> attributes = this.processAttributes(node, element, elemRefs);
        attributes.put(ATTR_SPACE, Collections.singleton(String.valueOf(trimFlag)));
        StringBuilder buffer = new StringBuilder();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node w3cNode = list.item(i);
            if (w3cNode instanceof Element) {
                Element child = (Element)w3cNode;
                XMLNode childNode = new XMLNode(child.getTagName(), elemRefs ? child : null);
                Map<String, Collection<String>> attrmap = this.constructHierarchy(childNode, child, elemRefs, trimFlag);
                node.addChild(childNode);
                Collection<String> attrSpace = attrmap.remove(ATTR_SPACE);
                Boolean childTrim = CollectionUtils.isEmpty(attrSpace) ? Boolean.FALSE : Boolean.valueOf(attrSpace.iterator().next());
                this.handleDelimiters(node, childNode, childTrim, attrmap);
                continue;
            }
            if (!(w3cNode instanceof Text)) continue;
            Text data = (Text)w3cNode;
            buffer.append(data.getData());
        }
        String text = XMLConfiguration.determineValue(node, buffer.toString(), trimFlag);
        if (text.length() > 0 || !node.hasChildren() && node != this.getRoot()) {
            node.setValue(text);
        }
        return attributes;
    }

    private static String determineValue(ConfigurationNode node, String content, boolean trimFlag) {
        boolean shouldTrim = trimFlag || StringUtils.isBlank(content) && node.getChildrenCount() > 0;
        return shouldTrim ? content.trim() : content;
    }

    private Map<String, Collection<String>> processAttributes(HierarchicalConfiguration.Node node, Element element, boolean elemRefs) {
        NamedNodeMap attributes = element.getAttributes();
        HashMap<String, Collection<String>> attrmap = new HashMap<String, Collection<String>>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node w3cNode = attributes.item(i);
            if (!(w3cNode instanceof Attr)) continue;
            Attr attr = (Attr)w3cNode;
            List<String> values = this.isAttributeSplittingDisabled() ? Collections.singletonList(attr.getValue()) : PropertyConverter.split(attr.getValue(), this.isDelimiterParsingDisabled() ? (char)'|' : (char)this.getListDelimiter());
            this.appendAttributes(node, element, elemRefs, attr.getName(), values);
            attrmap.put(attr.getName(), values);
        }
        return attrmap;
    }

    private void appendAttributes(HierarchicalConfiguration.Node node, Element element, boolean elemRefs, String attr, Collection<String> values) {
        for (String value2 : values) {
            XMLNode child = new XMLNode(attr, elemRefs ? element : null);
            ((DefaultConfigurationNode)child).setValue(value2);
            node.addAttribute(child);
        }
    }

    private void handleDelimiters(HierarchicalConfiguration.Node parent, HierarchicalConfiguration.Node child, boolean trim, Map<String, Collection<String>> attrmap) {
        if (child.getValue() != null) {
            List<Object> values;
            if (this.isDelimiterParsingDisabled()) {
                values = new ArrayList<String>();
                values.add(child.getValue().toString());
            } else {
                values = PropertyConverter.split(child.getValue().toString(), this.getListDelimiter(), trim);
            }
            if (values.size() > 1) {
                Iterator<Object> it = values.iterator();
                HierarchicalConfiguration.Node c = this.createNode(child.getName());
                c.setValue(it.next());
                for (ConfigurationNode configurationNode : child.getAttributes()) {
                    configurationNode.setReference(null);
                    c.addAttribute(configurationNode);
                }
                parent.remove(child);
                parent.addChild(c);
                while (it.hasNext()) {
                    c = new XMLNode(child.getName(), null);
                    c.setValue(it.next());
                    for (Map.Entry entry2 : attrmap.entrySet()) {
                        this.appendAttributes(c, null, false, (String)entry2.getKey(), (Collection)entry2.getValue());
                    }
                    parent.addChild(c);
                }
            } else if (values.size() == 1) {
                child.setValue(values.get(0));
            }
        }
    }

    private boolean shouldTrim(Element element, boolean currentTrim) {
        Attr attr = element.getAttributeNode(ATTR_SPACE);
        if (attr == null) {
            return currentTrim;
        }
        return !VALUE_PRESERVE.equals(attr.getValue());
    }

    protected DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (this.getDocumentBuilder() != null) {
            return this.getDocumentBuilder();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (this.isValidating()) {
            factory.setValidating(true);
            if (this.isSchemaValidation()) {
                factory.setNamespaceAware(true);
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
        }
        DocumentBuilder result2 = factory.newDocumentBuilder();
        result2.setEntityResolver(this.entityResolver);
        if (this.isValidating()) {
            result2.setErrorHandler(new DefaultHandler(){

                public void error(SAXParseException ex) throws SAXException {
                    throw ex;
                }
            });
        }
        return result2;
    }

    protected Document createDocument() throws ConfigurationException {
        try {
            Object builder;
            if (this.document == null) {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document newDocument = ((DocumentBuilder)builder).newDocument();
                Element rootElem = newDocument.createElement(this.getRootElementName());
                newDocument.appendChild(rootElem);
                this.document = newDocument;
            }
            builder = new XMLBuilderVisitor(this.document, this.isDelimiterParsingDisabled() ? (char)'\u0000' : this.getListDelimiter(), this.isAttributeSplittingDisabled());
            ((XMLBuilderVisitor)builder).processDocument(this.getRoot());
            this.initRootElementText(this.document, this.getRootNode().getValue());
            return this.document;
        }
        catch (DOMException domEx) {
            throw new ConfigurationException(domEx);
        }
        catch (ParserConfigurationException pex) {
            throw new ConfigurationException(pex);
        }
    }

    private void initRootElementText(Document doc, Object value2) {
        Element elem = doc.getDocumentElement();
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node nd = children.item(i);
            if (nd.getNodeType() != 3) continue;
            elem.removeChild(nd);
        }
        if (value2 != null) {
            elem.appendChild(doc.createTextNode(String.valueOf(value2)));
        }
    }

    @Override
    protected HierarchicalConfiguration.Node createNode(String name) {
        return new XMLNode(name, null);
    }

    @Override
    public void load(InputStream in) throws ConfigurationException {
        this.load(new InputSource(in));
    }

    @Override
    public void load(Reader in) throws ConfigurationException {
        this.load(new InputSource(in));
    }

    private void load(InputSource source) throws ConfigurationException {
        try {
            URL sourceURL = this.getDelegate().getURL();
            if (sourceURL != null) {
                source.setSystemId(sourceURL.toString());
            }
            DocumentBuilder builder = this.createDocumentBuilder();
            Document newDocument = builder.parse(source);
            Document oldDocument = this.document;
            this.document = null;
            this.initProperties(newDocument, oldDocument == null);
            this.document = oldDocument == null ? newDocument : oldDocument;
        }
        catch (SAXParseException spe) {
            throw new ConfigurationException("Error parsing " + source.getSystemId(), spe);
        }
        catch (Exception e) {
            this.getLogger().debug("Unable to load the configuraton", e);
            throw new ConfigurationException("Unable to load the configuration", e);
        }
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        try {
            Transformer transformer = this.createTransformer();
            DOMSource source = new DOMSource(this.createDocument());
            StreamResult result2 = new StreamResult(writer);
            transformer.transform(source, result2);
        }
        catch (TransformerException e) {
            throw new ConfigurationException("Unable to save the configuration", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ConfigurationException("Unable to save the configuration", e);
        }
    }

    public void validate() throws ConfigurationException {
        try {
            Transformer transformer = this.createTransformer();
            DOMSource source = new DOMSource(this.createDocument());
            StringWriter writer = new StringWriter();
            StreamResult result2 = new StreamResult(writer);
            transformer.transform(source, result2);
            StringReader reader = new StringReader(writer.getBuffer().toString());
            DocumentBuilder builder = this.createDocumentBuilder();
            builder.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            throw new ConfigurationException("Validation failed", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Validation failed", e);
        }
        catch (TransformerException e) {
            throw new ConfigurationException("Validation failed", e);
        }
        catch (ParserConfigurationException pce) {
            throw new ConfigurationException("Validation failed", pce);
        }
    }

    protected Transformer createTransformer() throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        if (this.getEncoding() != null) {
            transformer.setOutputProperty("encoding", this.getEncoding());
        }
        if (this.getPublicID() != null) {
            transformer.setOutputProperty("doctype-public", this.getPublicID());
        }
        if (this.getSystemID() != null) {
            transformer.setOutputProperty("doctype-system", this.getSystemID());
        }
        return transformer;
    }

    @Override
    public Object clone() {
        XMLConfiguration copy = (XMLConfiguration)super.clone();
        copy.document = null;
        copy.setDelegate(copy.createDelegate());
        XMLConfiguration.clearReferences(copy.getRootNode());
        return copy;
    }

    @Override
    protected AbstractHierarchicalFileConfiguration.FileConfigurationDelegate createDelegate() {
        return new XMLFileConfigurationDelegate();
    }

    @Override
    public void addNodes(String key, Collection<? extends ConfigurationNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            ArrayList<XMLNode> xmlNodes = new ArrayList<XMLNode>(nodes.size());
            for (ConfigurationNode configurationNode : nodes) {
                xmlNodes.add(this.convertToXMLNode(configurationNode));
            }
            super.addNodes(key, xmlNodes);
        } else {
            super.addNodes(key, nodes);
        }
    }

    private XMLNode convertToXMLNode(ConfigurationNode node) {
        if (node instanceof XMLNode) {
            return (XMLNode)node;
        }
        XMLNode nd = (XMLNode)this.createNode(node.getName());
        nd.setValue(node.getValue());
        nd.setAttribute(node.isAttribute());
        for (ConfigurationNode child : node.getChildren()) {
            nd.addChild(this.convertToXMLNode(child));
        }
        for (ConfigurationNode attr : node.getAttributes()) {
            nd.addAttribute(this.convertToXMLNode(attr));
        }
        return nd;
    }

    @Override
    public void registerEntityId(String publicId, URL entityURL) {
        if (this.entityResolver instanceof EntityRegistry) {
            ((EntityRegistry)((Object)this.entityResolver)).registerEntityId(publicId, entityURL);
        }
    }

    @Override
    @Deprecated
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return this.entityResolver.resolveEntity(publicId, systemId);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public Map<String, URL> getRegisteredEntities() {
        if (this.entityResolver instanceof EntityRegistry) {
            return ((EntityRegistry)((Object)this.entityResolver)).getRegisteredEntities();
        }
        return new HashMap<String, URL>();
    }

    private class XMLFileConfigurationDelegate
    extends AbstractHierarchicalFileConfiguration.FileConfigurationDelegate {
        private XMLFileConfigurationDelegate() {
        }

        public void load(InputStream in) throws ConfigurationException {
            XMLConfiguration.this.load(in);
        }
    }

    static class XMLBuilderVisitor
    extends HierarchicalConfiguration.BuilderVisitor {
        private Document document;
        private final char listDelimiter;
        private boolean isAttributeSplittingDisabled;

        public XMLBuilderVisitor(Document doc, char listDelimiter, boolean isAttributeSplittingDisabled) {
            this.document = doc;
            this.listDelimiter = listDelimiter;
            this.isAttributeSplittingDisabled = isAttributeSplittingDisabled;
        }

        public void processDocument(HierarchicalConfiguration.Node rootNode) {
            rootNode.visit(this, null);
        }

        protected Object insert(HierarchicalConfiguration.Node newNode, HierarchicalConfiguration.Node parent, HierarchicalConfiguration.Node sibling1, HierarchicalConfiguration.Node sibling2) {
            if (newNode.isAttribute()) {
                XMLBuilderVisitor.updateAttribute(parent, this.getElement(parent), newNode.getName(), this.listDelimiter, this.isAttributeSplittingDisabled);
                return null;
            }
            Element elem = this.document.createElement(newNode.getName());
            if (newNode.getValue() != null) {
                String txt = newNode.getValue().toString();
                if (this.listDelimiter != '\u0000') {
                    txt = PropertyConverter.escapeListDelimiter(txt, this.listDelimiter);
                }
                elem.appendChild(this.document.createTextNode(txt));
            }
            if (sibling2 == null) {
                this.getElement(parent).appendChild(elem);
            } else if (sibling1 != null) {
                this.getElement(parent).insertBefore(elem, this.getElement(sibling1).getNextSibling());
            } else {
                this.getElement(parent).insertBefore(elem, this.getElement(parent).getFirstChild());
            }
            return elem;
        }

        private static void updateAttribute(HierarchicalConfiguration.Node node, Element elem, String name, char listDelimiter, boolean isAttributeSplittingDisabled) {
            if (node != null && elem != null) {
                boolean hasAttribute = false;
                List<ConfigurationNode> attrs = node.getAttributes(name);
                StringBuilder buf = new StringBuilder();
                char delimiter = listDelimiter != '\u0000' ? listDelimiter : (char)'|';
                for (ConfigurationNode attr : attrs) {
                    if (attr.getValue() != null) {
                        hasAttribute = true;
                        if (buf.length() > 0) {
                            buf.append(delimiter);
                        }
                        String value2 = isAttributeSplittingDisabled ? attr.getValue().toString() : PropertyConverter.escapeDelimiters(attr.getValue().toString(), delimiter);
                        buf.append(value2);
                    }
                    attr.setReference(elem);
                }
                if (!hasAttribute) {
                    elem.removeAttribute(name);
                } else {
                    elem.setAttribute(name, buf.toString());
                }
            }
        }

        static void updateAttribute(HierarchicalConfiguration.Node node, String name, char listDelimiter, boolean isAttributeSplittingDisabled) {
            if (node != null) {
                XMLBuilderVisitor.updateAttribute(node, (Element)node.getReference(), name, listDelimiter, isAttributeSplittingDisabled);
            }
        }

        private Element getElement(HierarchicalConfiguration.Node node) {
            return node.getName() != null && node.getReference() != null ? (Element)node.getReference() : this.document.getDocumentElement();
        }
    }

    class XMLNode
    extends HierarchicalConfiguration.Node {
        private static final long serialVersionUID = -4133988932174596562L;

        public XMLNode(String name, Element elem) {
            super(name);
            this.setReference(elem);
        }

        public void setValue(Object value2) {
            super.setValue(value2);
            if (this.getReference() != null && XMLConfiguration.this.document != null) {
                if (this.isAttribute()) {
                    this.updateAttribute();
                } else {
                    this.updateElement(value2);
                }
            }
        }

        protected void removeReference() {
            if (this.getReference() != null) {
                Element element = (Element)this.getReference();
                if (this.isAttribute()) {
                    this.updateAttribute();
                } else {
                    Node parentElem = element.getParentNode();
                    if (parentElem != null) {
                        parentElem.removeChild(element);
                    }
                }
            }
        }

        private void updateElement(Object value2) {
            Text txtNode = this.findTextNodeForUpdate();
            if (value2 == null) {
                if (txtNode != null) {
                    ((Element)this.getReference()).removeChild(txtNode);
                }
            } else if (txtNode == null) {
                String newValue = XMLConfiguration.this.isDelimiterParsingDisabled() ? value2.toString() : PropertyConverter.escapeDelimiters(value2.toString(), XMLConfiguration.this.getListDelimiter());
                txtNode = XMLConfiguration.this.document.createTextNode(newValue);
                if (((Element)this.getReference()).getFirstChild() != null) {
                    ((Element)this.getReference()).insertBefore(txtNode, ((Element)this.getReference()).getFirstChild());
                } else {
                    ((Element)this.getReference()).appendChild(txtNode);
                }
            } else {
                String newValue = XMLConfiguration.this.isDelimiterParsingDisabled() ? value2.toString() : PropertyConverter.escapeDelimiters(value2.toString(), XMLConfiguration.this.getListDelimiter());
                txtNode.setNodeValue(newValue);
            }
        }

        private void updateAttribute() {
            XMLBuilderVisitor.updateAttribute(this.getParent(), this.getName(), XMLConfiguration.this.getListDelimiter(), XMLConfiguration.this.isAttributeSplittingDisabled());
        }

        private Text findTextNodeForUpdate() {
            Text result2 = null;
            Element elem = (Element)this.getReference();
            NodeList children = elem.getChildNodes();
            ArrayList<Node> textNodes = new ArrayList<Node>();
            for (int i = 0; i < children.getLength(); ++i) {
                Node nd = children.item(i);
                if (!(nd instanceof Text)) continue;
                if (result2 == null) {
                    result2 = (Text)nd;
                    continue;
                }
                textNodes.add(nd);
            }
            if (result2 instanceof CDATASection) {
                textNodes.add(result2);
                result2 = null;
            }
            for (Node tn : textNodes) {
                elem.removeChild(tn);
            }
            return result2;
        }
    }
}

