/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.configuration.beanutils.ConfigurationDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationDynaBean
extends ConfigurationMap
implements DynaBean {
    private static final String PROPERTY_DELIMITER = ".";
    private static final Log LOG = LogFactory.getLog(ConfigurationDynaBean.class);

    public ConfigurationDynaBean(Configuration configuration) {
        super(configuration);
        if (LOG.isTraceEnabled()) {
            LOG.trace("ConfigurationDynaBean(" + configuration + ")");
        }
    }

    public void set(String name, Object value2) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("set(" + name + "," + value2 + ")");
        }
        if (value2 == null) {
            throw new NullPointerException("Error trying to set property to null.");
        }
        if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            for (Object v : collection) {
                this.getConfiguration().addProperty(name, v);
            }
        } else if (value2.getClass().isArray()) {
            int length = Array.getLength(value2);
            for (int i = 0; i < length; ++i) {
                this.getConfiguration().addProperty(name, Array.get(value2, i));
            }
        } else {
            this.getConfiguration().setProperty(name, value2);
        }
    }

    public Object get(String name) {
        SubsetConfiguration subset;
        Object result2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("get(" + name + ")");
        }
        if ((result2 = this.getConfiguration().getProperty(name)) == null && !(subset = new SubsetConfiguration(this.getConfiguration(), name, PROPERTY_DELIMITER)).isEmpty()) {
            result2 = new ConfigurationDynaBean(subset);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(name + "=[" + result2 + "]");
        }
        if (result2 == null) {
            throw new IllegalArgumentException("Property '" + name + "' does not exist.");
        }
        return result2;
    }

    public boolean contains(String name, String key) {
        Configuration subset = this.getConfiguration().subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        return subset.containsKey(key);
    }

    public Object get(String name, int index) {
        if (!this.checkIndexedProperty(name)) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
        }
        List<Object> list = this.getConfiguration().getList(name);
        return list.get(index);
    }

    public Object get(String name, String key) {
        Configuration subset = this.getConfiguration().subset(name);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name + "' does not exist.");
        }
        return subset.getProperty(key);
    }

    public DynaClass getDynaClass() {
        return new ConfigurationDynaClass(this.getConfiguration());
    }

    public void remove(String name, String key) {
        SubsetConfiguration subset = new SubsetConfiguration(this.getConfiguration(), name, PROPERTY_DELIMITER);
        subset.setProperty(key, null);
    }

    public void set(String name, int index, Object value2) {
        if (!this.checkIndexedProperty(name) && index > 0) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed.");
        }
        Object property = this.getConfiguration().getProperty(name);
        if (property instanceof List) {
            List list = (List)property;
            list.set(index, value2);
            this.getConfiguration().setProperty(name, list);
        } else if (property.getClass().isArray()) {
            Array.set(property, index, value2);
        } else if (index == 0) {
            this.getConfiguration().setProperty(name, value2);
        }
    }

    public void set(String name, String key, Object value2) {
        this.getConfiguration().setProperty(name + PROPERTY_DELIMITER + key, value2);
    }

    private boolean checkIndexedProperty(String name) {
        Object property = this.getConfiguration().getProperty(name);
        if (property == null) {
            throw new IllegalArgumentException("Property '" + name + "' does not exist.");
        }
        return property instanceof List || property.getClass().isArray();
    }
}

