/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.plist;

import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.plist.ParseException;
import org.apache.commons.configuration.plist.PropertyListParser;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListConfiguration
extends AbstractHierarchicalFileConfiguration {
    private static final DateComponentParser DATE_SEPARATOR_PARSER = new DateSeparatorParser("-");
    private static final DateComponentParser TIME_SEPARATOR_PARSER = new DateSeparatorParser(":");
    private static final DateComponentParser BLANK_SEPARATOR_PARSER = new DateSeparatorParser(" ");
    private static final DateComponentParser[] DATE_PARSERS = new DateComponentParser[]{new DateSeparatorParser("<*D"), new DateFieldParser(1, 4), DATE_SEPARATOR_PARSER, new DateFieldParser(2, 2, 1), DATE_SEPARATOR_PARSER, new DateFieldParser(5, 2), BLANK_SEPARATOR_PARSER, new DateFieldParser(11, 2), TIME_SEPARATOR_PARSER, new DateFieldParser(12, 2), TIME_SEPARATOR_PARSER, new DateFieldParser(13, 2), BLANK_SEPARATOR_PARSER, new DateTimeZoneParser(), new DateSeparatorParser(">")};
    private static final String TIME_ZONE_PREFIX = "GMT";
    private static final long serialVersionUID = 3227248503779092127L;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int INDENT_SIZE = 4;
    private static final int TIME_ZONE_LENGTH = 5;
    private static final char PAD_CHAR = '0';

    public PropertyListConfiguration() {
    }

    public PropertyListConfiguration(HierarchicalConfiguration c) {
        super(c);
    }

    public PropertyListConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
    }

    public PropertyListConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public PropertyListConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String key, Object value2) {
        if (value2 instanceof byte[]) {
            this.fireEvent(3, key, value2, true);
            this.setDetailEvents(false);
            try {
                this.clearProperty(key);
                this.addPropertyDirect(key, value2);
            }
            finally {
                this.setDetailEvents(true);
            }
            this.fireEvent(3, key, value2, false);
        } else {
            super.setProperty(key, value2);
        }
    }

    @Override
    public void addProperty(String key, Object value2) {
        if (value2 instanceof byte[]) {
            this.fireEvent(1, key, value2, true);
            this.addPropertyDirect(key, value2);
            this.fireEvent(1, key, value2, false);
        } else {
            super.addProperty(key, value2);
        }
    }

    @Override
    public void load(Reader in) throws ConfigurationException {
        PropertyListParser parser = new PropertyListParser(in);
        try {
            PropertyListConfiguration config = parser.parse();
            this.setRoot(config.getRoot());
        }
        catch (ParseException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    public void save(Writer out) throws ConfigurationException {
        PrintWriter writer = new PrintWriter(out);
        this.printNode(writer, 0, this.getRoot());
        writer.flush();
    }

    private void printNode(PrintWriter out, int indentLevel, ConfigurationNode node) {
        ArrayList<ConfigurationNode> children;
        String padding2 = StringUtils.repeat(" ", indentLevel * 4);
        if (node.getName() != null) {
            out.print(padding2 + this.quoteString(node.getName()) + " = ");
        }
        if (!(children = new ArrayList<ConfigurationNode>(node.getChildren())).isEmpty()) {
            if (indentLevel > 0) {
                out.println();
            }
            out.println(padding2 + "{");
            Iterator it = children.iterator();
            while (it.hasNext()) {
                ConfigurationNode child = (ConfigurationNode)it.next();
                this.printNode(out, indentLevel + 1, child);
                Object value2 = child.getValue();
                if (value2 != null && !(value2 instanceof Map) && !(value2 instanceof Configuration)) {
                    out.println(";");
                }
                if (!it.hasNext() || value2 != null && !(value2 instanceof List)) continue;
                out.println();
            }
            out.print(padding2 + "}");
            if (node.getParentNode() != null) {
                out.println();
            }
        } else if (node.getValue() == null) {
            out.println();
            out.print(padding2 + "{ };");
            if (node.getParentNode() != null) {
                out.println();
            }
        } else {
            Object value3 = node.getValue();
            this.printValue(out, indentLevel, value3);
        }
    }

    private void printValue(PrintWriter out, int indentLevel, Object value2) {
        String padding2 = StringUtils.repeat(" ", indentLevel * 4);
        if (value2 instanceof List) {
            out.print("( ");
            Iterator it = ((List)value2).iterator();
            while (it.hasNext()) {
                this.printValue(out, indentLevel + 1, it.next());
                if (!it.hasNext()) continue;
                out.print(", ");
            }
            out.print(" )");
        } else if (value2 instanceof HierarchicalConfiguration) {
            this.printNode(out, indentLevel, ((HierarchicalConfiguration)value2).getRoot());
        } else if (value2 instanceof Configuration) {
            out.println();
            out.println(padding2 + "{");
            Configuration config = (Configuration)value2;
            Iterator<String> it = config.getKeys();
            while (it.hasNext()) {
                String key = it.next();
                HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(key);
                node.setValue(config.getProperty(key));
                this.printNode(out, indentLevel + 1, node);
                out.println(";");
            }
            out.println(padding2 + "}");
        } else if (value2 instanceof Map) {
            Map<String, Object> map2 = PropertyListConfiguration.transformMap((Map)value2);
            this.printValue(out, indentLevel, new MapConfiguration(map2));
        } else if (value2 instanceof byte[]) {
            out.print("<" + new String(Hex.encodeHex((byte[])value2)) + ">");
        } else if (value2 instanceof Date) {
            out.print(PropertyListConfiguration.formatDate((Date)value2));
        } else if (value2 != null) {
            out.print(this.quoteString(String.valueOf(value2)));
        }
    }

    String quoteString(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.indexOf(32) != -1 || s2.indexOf(9) != -1 || s2.indexOf(13) != -1 || s2.indexOf(10) != -1 || s2.indexOf(34) != -1 || s2.indexOf(40) != -1 || s2.indexOf(41) != -1 || s2.indexOf(123) != -1 || s2.indexOf(125) != -1 || s2.indexOf(61) != -1 || s2.indexOf(44) != -1 || s2.indexOf(59) != -1) {
            s2 = s2.replaceAll("\"", "\\\\\\\"");
            s2 = "\"" + s2 + "\"";
        }
        return s2;
    }

    static Date parseDate(String s2) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        int index = 0;
        for (DateComponentParser parser : DATE_PARSERS) {
            index += parser.parseComponent(s2, index, cal);
        }
        return cal.getTime();
    }

    static String formatDate(Calendar cal) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < DATE_PARSERS.length; ++i) {
            DATE_PARSERS[i].formatComponent(buf, cal);
        }
        return buf.toString();
    }

    static String formatDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return PropertyListConfiguration.formatDate(cal);
    }

    private static Map<String, Object> transformMap(Map<?, ?> src) {
        HashMap<String, Object> dest = new HashMap<String, Object>();
        for (Map.Entry<?, ?> e : src.entrySet()) {
            if (!(e.getKey() instanceof String)) continue;
            dest.put((String)e.getKey(), e.getValue());
        }
        return dest;
    }

    private static class DateTimeZoneParser
    extends DateComponentParser {
        private DateTimeZoneParser() {
        }

        public void formatComponent(StringBuilder buf, Calendar cal) {
            TimeZone tz = cal.getTimeZone();
            int ofs = tz.getRawOffset() / 60000;
            if (ofs < 0) {
                buf.append('-');
                ofs = -ofs;
            } else {
                buf.append('+');
            }
            int hour = ofs / 60;
            int min2 = ofs % 60;
            this.padNum(buf, hour, 2);
            this.padNum(buf, min2, 2);
        }

        public int parseComponent(String s2, int index, Calendar cal) throws ParseException {
            this.checkLength(s2, index, 5);
            TimeZone tz = TimeZone.getTimeZone(PropertyListConfiguration.TIME_ZONE_PREFIX + s2.substring(index, index + 5));
            cal.setTimeZone(tz);
            return 5;
        }
    }

    private static class DateSeparatorParser
    extends DateComponentParser {
        private String separator;

        public DateSeparatorParser(String sep) {
            this.separator = sep;
        }

        public void formatComponent(StringBuilder buf, Calendar cal) {
            buf.append(this.separator);
        }

        public int parseComponent(String s2, int index, Calendar cal) throws ParseException {
            this.checkLength(s2, index, this.separator.length());
            if (!s2.startsWith(this.separator, index)) {
                throw new ParseException("Invalid input: " + s2 + ", index " + index + ", expected " + this.separator);
            }
            return this.separator.length();
        }
    }

    private static class DateFieldParser
    extends DateComponentParser {
        private int calendarField;
        private int length;
        private int offset;

        public DateFieldParser(int calFld, int len) {
            this(calFld, len, 0);
        }

        public DateFieldParser(int calFld, int len, int ofs) {
            this.calendarField = calFld;
            this.length = len;
            this.offset = ofs;
        }

        public void formatComponent(StringBuilder buf, Calendar cal) {
            this.padNum(buf, cal.get(this.calendarField) + this.offset, this.length);
        }

        public int parseComponent(String s2, int index, Calendar cal) throws ParseException {
            this.checkLength(s2, index, this.length);
            try {
                cal.set(this.calendarField, Integer.parseInt(s2.substring(index, index + this.length)) - this.offset);
                return this.length;
            }
            catch (NumberFormatException nfex) {
                throw new ParseException("Invalid number: " + s2 + ", index " + index);
            }
        }
    }

    private static abstract class DateComponentParser {
        private DateComponentParser() {
        }

        public abstract int parseComponent(String var1, int var2, Calendar var3) throws ParseException;

        public abstract void formatComponent(StringBuilder var1, Calendar var2);

        protected void checkLength(String s2, int index, int length) throws ParseException {
            int len;
            int n = len = s2 == null ? 0 : s2.length();
            if (index + length > len) {
                throw new ParseException("Input string too short: " + s2 + ", index: " + index);
            }
        }

        protected void padNum(StringBuilder buf, int num, int length) {
            buf.append(StringUtils.leftPad(String.valueOf(num), length, '0'));
        }
    }
}

