/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.atomic;

import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.framework.recipes.atomic.MutableAtomicValue;

public class CachedAtomicLong {
    private final DistributedAtomicLong number;
    private final long cacheFactor;
    private AtomicValue<Long> currentValue = null;
    private int currentIndex = 0;

    public CachedAtomicLong(DistributedAtomicLong number, int cacheFactor) {
        this.number = number;
        this.cacheFactor = cacheFactor;
    }

    public AtomicValue<Long> next() throws Exception {
        MutableAtomicValue<Long> result2 = new MutableAtomicValue<Long>(0L, 0L);
        if (this.currentValue == null) {
            this.currentValue = this.number.add(this.cacheFactor);
            if (!this.currentValue.succeeded()) {
                this.currentValue = null;
                result2.succeeded = false;
                return result2;
            }
            this.currentIndex = 0;
        }
        result2.succeeded = true;
        result2.preValue = this.currentValue.preValue() + (long)this.currentIndex;
        result2.postValue = (Long)result2.preValue + 1L;
        if ((long)(++this.currentIndex) >= this.cacheFactor) {
            this.currentValue = null;
        }
        return result2;
    }
}

