/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.NativeCodeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class OpensslCipher {
    private static final Logger LOG = LoggerFactory.getLogger(OpensslCipher.class.getName());
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 0;
    private long context = 0L;
    private final int alg;
    private final int padding;
    private static final String loadingFailureReason;

    public static String getLoadingFailureReason() {
        return loadingFailureReason;
    }

    private OpensslCipher(long context, int alg, int padding2) {
        this.context = context;
        this.alg = alg;
        this.padding = padding2;
    }

    public static final OpensslCipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Transform transform2 = OpensslCipher.tokenizeTransformation(transformation);
        int algMode = AlgMode.get(transform2.alg, transform2.mode);
        int padding2 = Padding.get(transform2.padding);
        long context = OpensslCipher.initContext(algMode, padding2);
        return new OpensslCipher(context, algMode, padding2);
    }

    private static Transform tokenizeTransformation(String transformation) throws NoSuchAlgorithmException {
        if (transformation == null) {
            throw new NoSuchAlgorithmException("No transformation given.");
        }
        String[] parts = new String[3];
        int count2 = 0;
        StringTokenizer parser = new StringTokenizer(transformation, "/");
        while (parser.hasMoreTokens() && count2 < 3) {
            parts[count2++] = parser.nextToken().trim();
        }
        if (count2 != 3 || parser.hasMoreTokens()) {
            throw new NoSuchAlgorithmException("Invalid transformation format: " + transformation);
        }
        return new Transform(parts[0], parts[1], parts[2]);
    }

    public void init(int mode, byte[] key, byte[] iv) {
        this.context = this.init(this.context, mode, this.alg, this.padding, key, iv);
    }

    public int update(ByteBuffer input2, ByteBuffer output) throws ShortBufferException {
        this.checkState();
        Preconditions.checkArgument(input2.isDirect() && output.isDirect(), "Direct buffers are required.");
        int len = this.update(this.context, input2, input2.position(), input2.remaining(), output, output.position(), output.remaining());
        input2.position(input2.limit());
        output.position(output.position() + len);
        return len;
    }

    public int doFinal(ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkState();
        Preconditions.checkArgument(output.isDirect(), "Direct buffer is required.");
        int len = this.doFinal(this.context, output, output.position(), output.remaining());
        output.position(output.position() + len);
        return len;
    }

    public void clean() {
        if (this.context != 0L) {
            this.clean(this.context);
            this.context = 0L;
        }
    }

    private void checkState() {
        Preconditions.checkState(this.context != 0L);
    }

    protected void finalize() throws Throwable {
        this.clean();
    }

    private static native void initIDs();

    private static native long initContext(int var0, int var1);

    private native long init(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7);

    private native int update(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    private native int doFinal(long var1, ByteBuffer var3, int var4, int var5);

    private native void clean(long var1);

    public static native String getLibraryName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String loadingFailure = null;
        try {
            if (!NativeCodeLoader.buildSupportsOpenssl()) {
                loadingFailure = "build does not support openssl.";
            } else {
                OpensslCipher.initIDs();
            }
        }
        catch (Throwable t) {
            loadingFailure = t.getMessage();
            LOG.debug("Failed to load OpenSSL Cipher.", t);
        }
        finally {
            loadingFailureReason = loadingFailure;
        }
    }

    private static class Transform {
        final String alg;
        final String mode;
        final String padding;

        public Transform(String alg, String mode, String padding2) {
            this.alg = alg;
            this.mode = mode;
            this.padding = padding2;
        }
    }

    private static enum Padding {
        NoPadding;


        static int get(String padding2) throws NoSuchPaddingException {
            try {
                return Padding.valueOf(padding2).ordinal();
            }
            catch (Exception e) {
                throw new NoSuchPaddingException("Doesn't support padding: " + padding2);
            }
        }
    }

    private static enum AlgMode {
        AES_CTR;


        static int get(String algorithm, String mode) throws NoSuchAlgorithmException {
            try {
                return AlgMode.valueOf(algorithm + "_" + mode).ordinal();
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Doesn't support algorithm: " + algorithm + " and mode: " + mode);
            }
        }
    }
}

