/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public enum XAttrCodec {
    TEXT,
    HEX,
    BASE64;

    private static final String HEX_PREFIX = "0x";
    private static final String BASE64_PREFIX = "0s";
    private static final Base64 base64;

    public static byte[] decodeValue(String value2) throws IOException {
        byte[] result2 = null;
        if (value2 != null) {
            if (value2.length() >= 2) {
                String en = value2.substring(0, 2);
                if (value2.startsWith("\"") && value2.endsWith("\"")) {
                    value2 = value2.substring(1, value2.length() - 1);
                    result2 = value2.getBytes("utf-8");
                } else if (en.equalsIgnoreCase(HEX_PREFIX)) {
                    value2 = value2.substring(2, value2.length());
                    try {
                        result2 = Hex.decodeHex(value2.toCharArray());
                    }
                    catch (DecoderException e) {
                        throw new IOException(e);
                    }
                } else if (en.equalsIgnoreCase(BASE64_PREFIX)) {
                    value2 = value2.substring(2, value2.length());
                    result2 = base64.decode(value2);
                }
            }
            if (result2 == null) {
                result2 = value2.getBytes("utf-8");
            }
        }
        return result2;
    }

    public static String encodeValue(byte[] value2, XAttrCodec encoding) throws IOException {
        Preconditions.checkNotNull(value2, "Value can not be null.");
        if (encoding == HEX) {
            return HEX_PREFIX + Hex.encodeHexString(value2);
        }
        if (encoding == BASE64) {
            return BASE64_PREFIX + base64.encodeToString(value2);
        }
        return "\"" + new String(value2, "utf-8") + "\"";
    }

    static {
        base64 = new Base64(0);
    }
}

