/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import com.google.common.annotations.VisibleForTesting;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.FenceMethod;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.StreamPumper;
import org.slf4j.LoggerFactory;

public class SshFenceByTcpPort
extends Configured
implements FenceMethod {
    static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SshFenceByTcpPort.class);
    static final String CONF_CONNECT_TIMEOUT_KEY = "dfs.ha.fencing.ssh.connect-timeout";
    private static final int CONF_CONNECT_TIMEOUT_DEFAULT = 30000;
    static final String CONF_IDENTITIES_KEY = "dfs.ha.fencing.ssh.private-key-files";

    @Override
    public void checkArgs(String argStr) throws BadFencingConfigurationException {
        if (argStr != null) {
            new Args(argStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryFence(HAServiceTarget target, String argsStr) throws BadFencingConfigurationException {
        Session session;
        Args args = new Args(argsStr);
        InetSocketAddress serviceAddr = target.getAddress();
        String host = serviceAddr.getHostName();
        try {
            session = this.createSession(serviceAddr.getHostName(), args);
        }
        catch (JSchException e) {
            LOG.warn("Unable to create SSH session", e);
            return false;
        }
        LOG.info("Connecting to " + host + "...");
        try {
            session.connect(this.getSshConnectTimeout());
        }
        catch (JSchException e) {
            LOG.warn("Unable to connect to " + host + " as user " + args.user, e);
            return false;
        }
        LOG.info("Connected to " + host);
        try {
            boolean e = this.doFence(session, serviceAddr);
            return e;
        }
        catch (JSchException e) {
            LOG.warn("Unable to achieve fencing on remote host", e);
            boolean bl = false;
            return bl;
        }
        finally {
            session.disconnect();
        }
    }

    private Session createSession(String host, Args args) throws JSchException {
        JSch jsch = new JSch();
        for (String keyFile : this.getKeyFiles()) {
            jsch.addIdentity(keyFile);
        }
        JSch.setLogger(new LogAdapter());
        Session session = jsch.getSession(args.user, host, args.sshPort);
        session.setConfig("StrictHostKeyChecking", "no");
        return session;
    }

    private boolean doFence(Session session, InetSocketAddress serviceAddr) throws JSchException {
        int port = serviceAddr.getPort();
        try {
            LOG.info("Looking for process running on port " + port);
            int rc = this.execCommand(session, "PATH=$PATH:/sbin:/usr/sbin fuser -v -k -n tcp " + port);
            if (rc == 0) {
                LOG.info("Successfully killed process that was listening on port " + port);
                return true;
            }
            if (rc == 1) {
                LOG.info("Indeterminate response from trying to kill service. Verifying whether it is running using nc...");
                rc = this.execCommand(session, "nc -z " + serviceAddr.getHostName() + " " + serviceAddr.getPort());
                if (rc == 0) {
                    LOG.warn("Unable to fence - it is running but we cannot kill it");
                    return false;
                }
                LOG.info("Verified that the service is down.");
                return true;
            }
            LOG.info("rc: " + rc);
            return rc == 0;
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while trying to fence via ssh", e);
            return false;
        }
        catch (IOException e) {
            LOG.warn("Unknown failure while trying to fence via ssh", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execCommand(Session session, String cmd) throws JSchException, InterruptedException, IOException {
        int n;
        LOG.debug("Running cmd: " + cmd);
        ChannelExec exec2 = null;
        try {
            exec2 = (ChannelExec)session.openChannel("exec");
            exec2.setCommand(cmd);
            exec2.setInputStream(null);
            exec2.connect();
            StreamPumper outPumper = new StreamPumper(LOG, cmd + " via ssh", exec2.getInputStream(), StreamPumper.StreamType.STDOUT);
            outPumper.start();
            StreamPumper errPumper = new StreamPumper(LOG, cmd + " via ssh", exec2.getErrStream(), StreamPumper.StreamType.STDERR);
            errPumper.start();
            outPumper.join();
            errPumper.join();
            n = exec2.getExitStatus();
        }
        catch (Throwable throwable) {
            SshFenceByTcpPort.cleanup(exec2);
            throw throwable;
        }
        SshFenceByTcpPort.cleanup(exec2);
        return n;
    }

    private static void cleanup(ChannelExec exec2) {
        if (exec2 != null) {
            try {
                exec2.disconnect();
            }
            catch (Throwable t) {
                LOG.warn("Couldn't disconnect ssh channel", t);
            }
        }
    }

    private int getSshConnectTimeout() {
        return this.getConf().getInt(CONF_CONNECT_TIMEOUT_KEY, 30000);
    }

    private Collection<String> getKeyFiles() {
        return this.getConf().getTrimmedStringCollection(CONF_IDENTITIES_KEY);
    }

    private static class LogAdapter
    implements Logger {
        static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SshFenceByTcpPort.class.getName() + ".jsch");

        private LogAdapter() {
        }

        @Override
        public boolean isEnabled(int level) {
            switch (level) {
                case 0: {
                    return LOG.isDebugEnabled();
                }
                case 1: {
                    return LOG.isInfoEnabled();
                }
                case 2: {
                    return LOG.isWarnEnabled();
                }
                case 3: 
                case 4: {
                    return LOG.isErrorEnabled();
                }
            }
            return false;
        }

        @Override
        public void log(int level, String message) {
            switch (level) {
                case 0: {
                    LOG.debug(message);
                    break;
                }
                case 1: {
                    LOG.info(message);
                    break;
                }
                case 2: {
                    LOG.warn(message);
                    break;
                }
                case 3: 
                case 4: {
                    LOG.error(message);
                    break;
                }
            }
        }
    }

    @VisibleForTesting
    static class Args {
        private static final Pattern USER_PORT_RE = Pattern.compile("([^:]+?)?(?:\\:(\\d+))?");
        private static final int DEFAULT_SSH_PORT = 22;
        String user = System.getProperty("user.name");
        int sshPort = 22;

        public Args(String arg) throws BadFencingConfigurationException {
            if (arg != null && !arg.isEmpty()) {
                Matcher m3 = USER_PORT_RE.matcher(arg);
                if (!m3.matches()) {
                    throw new BadFencingConfigurationException("Unable to parse user and SSH port: " + arg);
                }
                if (m3.group(1) != null) {
                    this.user = m3.group(1);
                }
                if (m3.group(2) != null) {
                    this.sshPort = this.parseConfiggedPort(m3.group(2));
                }
            }
        }

        private int parseConfiggedPort(String portStr) throws BadFencingConfigurationException {
            try {
                return Integer.parseInt(portStr);
            }
            catch (NumberFormatException nfe) {
                throw new BadFencingConfigurationException("Port number '" + portStr + "' invalid");
            }
        }
    }
}

