/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HttpConfig {

    public static enum Policy {
        HTTP_ONLY,
        HTTPS_ONLY,
        HTTP_AND_HTTPS;

        private static final Policy[] VALUES;

        public static Policy fromString(String value2) {
            for (Policy p : VALUES) {
                if (!p.name().equalsIgnoreCase(value2)) continue;
                return p;
            }
            return null;
        }

        public boolean isHttpEnabled() {
            return this == HTTP_ONLY || this == HTTP_AND_HTTPS;
        }

        public boolean isHttpsEnabled() {
            return this == HTTPS_ONLY || this == HTTP_AND_HTTPS;
        }

        static {
            VALUES = Policy.values();
        }
    }
}

