/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class DataInputBuffer
extends DataInputStream {
    private Buffer buffer;

    public DataInputBuffer() {
        this(new Buffer());
    }

    private DataInputBuffer(Buffer buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public void reset(byte[] input2, int length) {
        this.buffer.reset(input2, 0, length);
    }

    public void reset(byte[] input2, int start, int length) {
        this.buffer.reset(input2, start, length);
    }

    public byte[] getData() {
        return this.buffer.getData();
    }

    public int getPosition() {
        return this.buffer.getPosition();
    }

    public int getLength() {
        return this.buffer.getLength();
    }

    private static class Buffer
    extends ByteArrayInputStream {
        public Buffer() {
            super(new byte[0]);
        }

        public void reset(byte[] input2, int start, int length) {
            this.buf = input2;
            this.count = start + length;
            this.mark = start;
            this.pos = start;
        }

        public byte[] getData() {
            return this.buf;
        }

        public int getPosition() {
            return this.pos;
        }

        public int getLength() {
            return this.count;
        }

        @Override
        public int read() {
            return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + len > this.count) {
                len = this.count - this.pos;
            }
            if (len <= 0) {
                return 0;
            }
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        @Override
        public long skip(long n) {
            if ((long)this.pos + n > (long)this.count) {
                n = this.count - this.pos;
            }
            if (n < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + n);
            return n;
        }

        @Override
        public int available() {
            return this.count - this.pos;
        }
    }
}

