/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.lib.MutableMetricsFactory;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsSourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsSourceBuilder.class);
    private final Object source;
    private final MutableMetricsFactory factory;
    private final MetricsRegistry registry;
    private MetricsInfo info;
    private boolean hasAtMetric = false;
    private boolean hasRegistry = false;

    MetricsSourceBuilder(Object source, MutableMetricsFactory factory) {
        this.source = Preconditions.checkNotNull(source, "source");
        this.factory = Preconditions.checkNotNull(factory, "mutable metrics factory");
        Class<?> cls = source.getClass();
        this.registry = this.initRegistry(source);
        for (Field field2 : ReflectionUtils.getDeclaredFieldsIncludingInherited(cls)) {
            this.add(source, field2);
        }
        for (Method method : ReflectionUtils.getDeclaredMethodsIncludingInherited(cls)) {
            this.add(source, method);
        }
    }

    public MetricsSource build() {
        if (this.source instanceof MetricsSource) {
            if (this.hasAtMetric && !this.hasRegistry) {
                throw new MetricsException("Hybrid metrics: registry required.");
            }
            return (MetricsSource)this.source;
        }
        if (!this.hasAtMetric) {
            throw new MetricsException("No valid @Metric annotation found.");
        }
        return new MetricsSource(){

            @Override
            public void getMetrics(MetricsCollector builder, boolean all) {
                MetricsSourceBuilder.this.registry.snapshot(builder.addRecord(MetricsSourceBuilder.this.registry.info()), all);
            }
        };
    }

    public MetricsInfo info() {
        return this.info;
    }

    private MetricsRegistry initRegistry(Object source) {
        Class<?> cls = source.getClass();
        MetricsRegistry r = null;
        for (Field field2 : ReflectionUtils.getDeclaredFieldsIncludingInherited(cls)) {
            if (field2.getType() != MetricsRegistry.class) continue;
            try {
                field2.setAccessible(true);
                r = (MetricsRegistry)field2.get(source);
                this.hasRegistry = r != null;
                break;
            }
            catch (Exception e) {
                LOG.warn("Error accessing field " + field2, e);
            }
        }
        for (Annotation annotation : cls.getAnnotations()) {
            if (!(annotation instanceof Metrics)) continue;
            Metrics ma = (Metrics)annotation;
            this.info = this.factory.getInfo(cls, ma);
            if (r == null) {
                r = new MetricsRegistry(this.info);
            }
            r.setContext(ma.context());
        }
        if (r == null) {
            return new MetricsRegistry(cls.getSimpleName());
        }
        return r;
    }

    private void add(Object source, Field field2) {
        for (Annotation annotation : field2.getAnnotations()) {
            block6: {
                if (!(annotation instanceof Metric)) continue;
                try {
                    field2.setAccessible(true);
                    if (field2.get(source) != null) {
                    }
                    break block6;
                }
                catch (Exception e) {
                    LOG.warn("Error accessing field " + field2 + " annotated with" + annotation, e);
                }
                continue;
            }
            MutableMetric mutable = this.factory.newForField(field2, (Metric)annotation, this.registry);
            if (mutable == null) continue;
            try {
                field2.set(source, mutable);
                this.hasAtMetric = true;
            }
            catch (Exception e) {
                throw new MetricsException("Error setting field " + field2 + " annotated with " + annotation, e);
            }
        }
    }

    private void add(Object source, Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!(annotation instanceof Metric)) continue;
            this.factory.newForMethod(source, method, (Metric)annotation, this.registry);
            this.hasAtMetric = true;
        }
    }
}

