/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.util.PriorityQueue;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class Metrics2Util {

    @InterfaceAudience.Private
    public static class TopN
    extends PriorityQueue<NameValuePair> {
        private static final long serialVersionUID = 5134028249611535803L;
        private int n;
        private long total = 0L;

        public TopN(int n) {
            super(n);
            this.n = n;
        }

        @Override
        public boolean offer(NameValuePair entry2) {
            this.updateTotal(entry2.value);
            if (this.size() == this.n) {
                NameValuePair smallest = (NameValuePair)this.peek();
                if (smallest.value >= entry2.value) {
                    return false;
                }
                this.poll();
            }
            return super.offer(entry2);
        }

        private void updateTotal(long value2) {
            this.total += value2;
        }

        public long getTotal() {
            return this.total;
        }
    }

    @InterfaceAudience.Private
    public static class NameValuePair
    implements Comparable<NameValuePair> {
        private String name;
        private long value;

        public NameValuePair(String metricName, long value2) {
            this.name = metricName;
            this.value = value2;
        }

        public String getName() {
            return this.name;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public int compareTo(NameValuePair other) {
            return (int)(this.value - other.value);
        }

        public boolean equals(Object other) {
            if (other instanceof NameValuePair) {
                return this.compareTo((NameValuePair)other) == 0;
            }
            return false;
        }

        public int hashCode() {
            return Long.valueOf(this.value).hashCode();
        }
    }
}

