/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.record.compiler.CodeBuffer;
import org.apache.hadoop.record.compiler.JBuffer;
import org.apache.hadoop.record.compiler.JCompType;
import org.apache.hadoop.record.compiler.JField;
import org.apache.hadoop.record.compiler.JType;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class JRecord
extends JCompType {
    private String signature;

    public JRecord(String name, ArrayList<JField<JType>> flist) {
        this.setJavaType(new JavaRecord(name, flist));
        this.setCppType(new CppRecord(name, flist));
        this.setCType(new CRecord());
        int idx = name.lastIndexOf(46);
        String recName = name.substring(idx + 1);
        StringBuilder sb = new StringBuilder();
        sb.append("L").append(recName).append("(");
        Iterator<JField<JType>> i = flist.iterator();
        while (i.hasNext()) {
            String s2 = i.next().getType().getSignature();
            sb.append(s2);
        }
        sb.append(")");
        this.signature = sb.toString();
    }

    @Override
    String getSignature() {
        return this.signature;
    }

    void genCppCode(Writer hh, Writer cc, ArrayList<String> options) throws IOException {
        ((CppRecord)this.getCppType()).genCode(hh, cc, options);
    }

    void genJavaCode(String destDir, ArrayList<String> options) throws IOException {
        ((JavaRecord)this.getJavaType()).genCode(destDir, options);
    }

    class CRecord
    extends JCompType.CCompType {
        CRecord() {
            super(JRecord.this);
        }
    }

    class CppRecord
    extends JCompType.CppCompType {
        private String fullName;
        private String name;
        private String module;
        private ArrayList<JField<JType.CppType>> fields;

        CppRecord(String name, ArrayList<JField<JType>> flist) {
            super(JRecord.this, name.replaceAll("\\.", "::"));
            this.fields = new ArrayList();
            this.fullName = name.replaceAll("\\.", "::");
            int idx = name.lastIndexOf(46);
            this.name = name.substring(idx + 1);
            this.module = name.substring(0, idx).replaceAll("\\.", "::");
            for (JField<JType> f : flist) {
                this.fields.add(new JField<JType.CppType>(f.getName(), f.getType().getCppType()));
            }
        }

        @Override
        String getTypeIDObjectString() {
            return "new ::hadoop::StructTypeID(" + this.fullName + "::getTypeInfo().getFieldTypeInfos())";
        }

        String genDecl(String fname) {
            return "  " + this.name + " " + fname + ";\n";
        }

        @Override
        void genSetRTIFilter(CodeBuffer cb) {
            cb.append(this.fullName + "::setTypeFilter(rti.getNestedStructTypeInfo(\"" + this.name + "\"));\n");
        }

        void genSetupRTIFields(CodeBuffer cb) {
            cb.append("void " + this.fullName + "::setupRtiFields() {\n");
            cb.append("if (NULL == p_rio_rtiFilter) return;\n");
            cb.append("if (NULL != p_rio_rtiFilterFields) return;\n");
            cb.append("p_rio_rtiFilterFields = new int[p_rio_rtiFilter->getFieldTypeInfos().size()];\n");
            cb.append("for (unsigned int _rio_i=0; _rio_i<p_rio_rtiFilter->getFieldTypeInfos().size(); _rio_i++) {\n");
            cb.append("p_rio_rtiFilterFields[_rio_i] = 0;\n");
            cb.append("}\n");
            cb.append("for (unsigned int _rio_i=0; _rio_i<p_rio_rtiFilter->getFieldTypeInfos().size(); _rio_i++) {\n");
            cb.append("for (unsigned int _rio_j=0; _rio_j<p_rio_recTypeInfo->getFieldTypeInfos().size(); _rio_j++) {\n");
            cb.append("if (*(p_rio_rtiFilter->getFieldTypeInfos()[_rio_i]) == *(p_rio_recTypeInfo->getFieldTypeInfos()[_rio_j])) {\n");
            cb.append("p_rio_rtiFilterFields[_rio_i] = _rio_j+1;\n");
            cb.append("break;\n");
            cb.append("}\n");
            cb.append("}\n");
            cb.append("}\n");
            cb.append("}\n");
        }

        void genCode(Writer hh, Writer cc, ArrayList<String> options) throws IOException {
            String name;
            JType.CppType type;
            String name2;
            JType.CppType type2;
            String name3;
            CodeBuffer hb = new CodeBuffer();
            String[] ns = this.module.split("::");
            for (int i = 0; i < ns.length; ++i) {
                hb.append("namespace " + ns[i] + " {\n");
            }
            hb.append("class " + this.name + " : public ::hadoop::Record {\n");
            hb.append("private:\n");
            for (JField<JType.CppType> jf : this.fields) {
                name3 = jf.getName();
                type2 = jf.getType();
                type2.genDecl(hb, name3);
            }
            hb.append("static ::hadoop::RecordTypeInfo* p_rio_recTypeInfo;\n");
            hb.append("static ::hadoop::RecordTypeInfo* p_rio_rtiFilter;\n");
            hb.append("static int* p_rio_rtiFilterFields;\n");
            hb.append("static ::hadoop::RecordTypeInfo* setupTypeInfo();\n");
            hb.append("static void setupRtiFields();\n");
            hb.append("virtual void deserializeWithoutFilter(::hadoop::IArchive& _rio_a, const char* _rio_tag);\n");
            hb.append("public:\n");
            hb.append("static const ::hadoop::RecordTypeInfo& getTypeInfo() {return *p_rio_recTypeInfo;}\n");
            hb.append("static void setTypeFilter(const ::hadoop::RecordTypeInfo& rti);\n");
            hb.append("static void setTypeFilter(const ::hadoop::RecordTypeInfo* prti);\n");
            hb.append("virtual void serialize(::hadoop::OArchive& _rio_a, const char* _rio_tag) const;\n");
            hb.append("virtual void deserialize(::hadoop::IArchive& _rio_a, const char* _rio_tag);\n");
            hb.append("virtual const ::std::string& type() const;\n");
            hb.append("virtual const ::std::string& signature() const;\n");
            hb.append("virtual bool operator<(const " + this.name + "& peer_) const;\n");
            hb.append("virtual bool operator==(const " + this.name + "& peer_) const;\n");
            hb.append("virtual ~" + this.name + "() {};\n");
            for (JField<JType.CppType> jf : this.fields) {
                name3 = jf.getName();
                type2 = jf.getType();
                type2.genGetSet(hb, name3);
            }
            hb.append("}; // end record " + this.name + "\n");
            for (int i = ns.length - 1; i >= 0; --i) {
                hb.append("} // end namespace " + ns[i] + "\n");
            }
            hh.write(hb.toString());
            CodeBuffer cb = new CodeBuffer();
            cb.append("::hadoop::RecordTypeInfo* " + this.fullName + "::p" + "_rio_recTypeInfo" + " = " + this.fullName + "::setupTypeInfo();\n");
            cb.append("::hadoop::RecordTypeInfo* " + this.fullName + "::p" + "_rio_rtiFilter" + " = NULL;\n");
            cb.append("int* " + this.fullName + "::p" + "_rio_rtiFilterFields" + " = NULL;\n\n");
            cb.append("::hadoop::RecordTypeInfo* " + this.fullName + "::setupTypeInfo() {\n");
            cb.append("::hadoop::RecordTypeInfo* p = new ::hadoop::RecordTypeInfo(\"" + this.name + "\");\n");
            for (JField<JType.CppType> jf : this.fields) {
                name2 = jf.getName();
                type = jf.getType();
                type.genStaticTypeInfo(cb, name2);
            }
            cb.append("return p;\n");
            cb.append("}\n");
            cb.append("void " + this.fullName + "::setTypeFilter(const " + "::hadoop::RecordTypeInfo& rti) {\n");
            cb.append("if (NULL != p_rio_rtiFilter) {\n");
            cb.append("delete p_rio_rtiFilter;\n");
            cb.append("}\n");
            cb.append("p_rio_rtiFilter = new ::hadoop::RecordTypeInfo(rti);\n");
            cb.append("if (NULL != p_rio_rtiFilterFields) {\n");
            cb.append("delete p_rio_rtiFilterFields;\n");
            cb.append("}\n");
            cb.append("p_rio_rtiFilterFields = NULL;\n");
            for (JField<JType.CppType> jf : this.fields) {
                type2 = jf.getType();
                type2.genSetRTIFilter(cb);
            }
            cb.append("}\n");
            cb.append("void " + this.fullName + "::setTypeFilter(const " + "::hadoop::RecordTypeInfo* prti) {\n");
            cb.append("if (NULL != prti) {\n");
            cb.append("setTypeFilter(*prti);\n");
            cb.append("}\n");
            cb.append("}\n");
            this.genSetupRTIFields(cb);
            cb.append("void " + this.fullName + "::serialize(::hadoop::OArchive& " + "_rio_a" + ", const char* " + "_rio_tag" + ") const {\n");
            cb.append("_rio_a.startRecord(*this,_rio_tag);\n");
            for (JField<JType.CppType> jf : this.fields) {
                name2 = jf.getName();
                type = jf.getType();
                if (type instanceof JBuffer.CppBuffer) {
                    cb.append("_rio_a.serialize(" + name2 + "," + name2 + ".length(),\"" + name2 + "\");\n");
                    continue;
                }
                cb.append("_rio_a.serialize(" + name2 + ",\"" + name2 + "\");\n");
            }
            cb.append("_rio_a.endRecord(*this,_rio_tag);\n");
            cb.append("return;\n");
            cb.append("}\n");
            cb.append("void " + this.fullName + "::deserializeWithoutFilter(::hadoop::IArchive& " + "_rio_a" + ", const char* " + "_rio_tag" + ") {\n");
            cb.append("_rio_a.startRecord(*this,_rio_tag);\n");
            for (JField<JType.CppType> jf : this.fields) {
                name2 = jf.getName();
                type = jf.getType();
                if (type instanceof JBuffer.CppBuffer) {
                    cb.append("{\nsize_t len=0; _rio_a.deserialize(" + name2 + ",len,\"" + name2 + "\");\n}\n");
                    continue;
                }
                cb.append("_rio_a.deserialize(" + name2 + ",\"" + name2 + "\");\n");
            }
            cb.append("_rio_a.endRecord(*this,_rio_tag);\n");
            cb.append("return;\n");
            cb.append("}\n");
            cb.append("void " + this.fullName + "::deserialize(::hadoop::IArchive& " + "_rio_a" + ", const char* " + "_rio_tag" + ") {\n");
            cb.append("if (NULL == p_rio_rtiFilter) {\n");
            cb.append("deserializeWithoutFilter(_rio_a, _rio_tag);\n");
            cb.append("return;\n");
            cb.append("}\n");
            cb.append("// if we're here, we need to read based on version info\n");
            cb.append("_rio_a.startRecord(*this,_rio_tag);\n");
            cb.append("setupRtiFields();\n");
            cb.append("for (unsigned int _rio_i=0; _rio_i<p_rio_rtiFilter->getFieldTypeInfos().size(); _rio_i++) {\n");
            int ct = 0;
            for (JField<JType.CppType> jf : this.fields) {
                name = jf.getName();
                JType.CppType type3 = jf.getType();
                if (1 != ++ct) {
                    cb.append("else ");
                }
                cb.append("if (" + ct + " == p" + "_rio_rtiFilterFields" + "[" + "_rio_" + "i]) {\n");
                if (type3 instanceof JBuffer.CppBuffer) {
                    cb.append("{\nsize_t len=0; _rio_a.deserialize(" + name + ",len,\"" + name + "\");\n}\n");
                } else {
                    cb.append("_rio_a.deserialize(" + name + ",\"" + name + "\");\n");
                }
                cb.append("}\n");
            }
            if (0 != ct) {
                cb.append("else {\n");
                cb.append("const std::vector< ::hadoop::FieldTypeInfo* >& typeInfos = p_rio_rtiFilter->getFieldTypeInfos();\n");
                cb.append("::hadoop::Utils::skip(_rio_a, typeInfos[_rio_i]->getFieldID()->c_str(), *(typeInfos[_rio_i]->getTypeID()));\n");
                cb.append("}\n");
            }
            cb.append("}\n");
            cb.append("_rio_a.endRecord(*this, _rio_tag);\n");
            cb.append("}\n");
            cb.append("bool " + this.fullName + "::operator< (const " + this.fullName + "& peer_) const {\n");
            cb.append("return (1\n");
            for (JField<JType.CppType> jf : this.fields) {
                name = jf.getName();
                cb.append("&& (" + name + " < peer_." + name + ")\n");
            }
            cb.append(");\n");
            cb.append("}\n");
            cb.append("bool " + this.fullName + "::operator== (const " + this.fullName + "& peer_) const {\n");
            cb.append("return (1\n");
            for (JField<JType.CppType> jf : this.fields) {
                name = jf.getName();
                cb.append("&& (" + name + " == peer_." + name + ")\n");
            }
            cb.append(");\n");
            cb.append("}\n");
            cb.append("const ::std::string&" + this.fullName + "::type() const {\n");
            cb.append("static const ::std::string type_(\"" + this.name + "\");\n");
            cb.append("return type_;\n");
            cb.append("}\n");
            cb.append("const ::std::string&" + this.fullName + "::signature() const {\n");
            cb.append("static const ::std::string sig_(\"" + JRecord.this.getSignature() + "\");\n");
            cb.append("return sig_;\n");
            cb.append("}\n");
            cc.write(cb.toString());
        }
    }

    class JavaRecord
    extends JCompType.JavaCompType {
        private String fullName;
        private String name;
        private String module;
        private ArrayList<JField<JType.JavaType>> fields;

        JavaRecord(String name, ArrayList<JField<JType>> flist) {
            super(JRecord.this, name, "Record", name, "TypeID.RIOType.STRUCT");
            this.fields = new ArrayList();
            this.fullName = name;
            int idx = name.lastIndexOf(46);
            this.name = name.substring(idx + 1);
            this.module = name.substring(0, idx);
            for (JField<JType> f : flist) {
                this.fields.add(new JField<JType.JavaType>(f.getName(), f.getType().getJavaType()));
            }
        }

        @Override
        String getTypeIDObjectString() {
            return "new org.apache.hadoop.record.meta.StructTypeID(" + this.fullName + ".getTypeInfo())";
        }

        @Override
        void genSetRTIFilter(CodeBuffer cb, Map<String, Integer> nestedStructMap) {
            if (!nestedStructMap.containsKey(this.fullName)) {
                cb.append(this.fullName + ".setTypeFilter(rti.getNestedStructTypeInfo(\"" + this.name + "\"));\n");
                nestedStructMap.put(this.fullName, null);
            }
        }

        void genSetupRtiFields(CodeBuffer cb) {
            cb.append("private static void setupRtiFields()\n{\n");
            cb.append("if (null == _rio_rtiFilter) return;\n");
            cb.append("// we may already have done this\n");
            cb.append("if (null != _rio_rtiFilterFields) return;\n");
            cb.append("int _rio_i, _rio_j;\n");
            cb.append("_rio_rtiFilterFields = new int [_rio_rtiFilter.getFieldTypeInfos().size()];\n");
            cb.append("for (_rio_i=0; _rio_i<_rio_rtiFilterFields.length; _rio_i++) {\n");
            cb.append("_rio_rtiFilterFields[_rio_i] = 0;\n");
            cb.append("}\n");
            cb.append("java.util.Iterator<org.apache.hadoop.record.meta.FieldTypeInfo> _rio_itFilter = _rio_rtiFilter.getFieldTypeInfos().iterator();\n");
            cb.append("_rio_i=0;\n");
            cb.append("while (_rio_itFilter.hasNext()) {\n");
            cb.append("org.apache.hadoop.record.meta.FieldTypeInfo _rio_tInfoFilter = _rio_itFilter.next();\n");
            cb.append("java.util.Iterator<org.apache.hadoop.record.meta.FieldTypeInfo> _rio_it = _rio_recTypeInfo.getFieldTypeInfos().iterator();\n");
            cb.append("_rio_j=1;\n");
            cb.append("while (_rio_it.hasNext()) {\n");
            cb.append("org.apache.hadoop.record.meta.FieldTypeInfo _rio_tInfo = _rio_it.next();\n");
            cb.append("if (_rio_tInfo.equals(_rio_tInfoFilter)) {\n");
            cb.append("_rio_rtiFilterFields[_rio_i] = _rio_j;\n");
            cb.append("break;\n");
            cb.append("}\n");
            cb.append("_rio_j++;\n");
            cb.append("}\n");
            cb.append("_rio_i++;\n");
            cb.append("}\n");
            cb.append("}\n");
        }

        @Override
        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.fullName + " " + fname + ";\n");
            }
            cb.append(fname + "= new " + this.fullName + "();\n");
            cb.append(fname + ".deserialize(" + "_rio_a" + ",\"" + tag + "\");\n");
        }

        @Override
        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            cb.append(fname + ".serialize(" + "_rio_a" + ",\"" + tag + "\");\n");
        }

        @Override
        void genSlurpBytes(CodeBuffer cb, String b, String s2, String l) {
            cb.append("{\n");
            cb.append("int r = " + this.fullName + ".Comparator.slurpRaw(" + b + "," + s2 + "," + l + ");\n");
            cb.append(s2 + "+=r; " + l + "-=r;\n");
            cb.append("}\n");
        }

        @Override
        void genCompareBytes(CodeBuffer cb) {
            cb.append("{\n");
            cb.append("int r1 = " + this.fullName + ".Comparator.compareRaw(b1,s1,l1,b2,s2,l2);\n");
            cb.append("if (r1 <= 0) { return r1; }\n");
            cb.append("s1+=r1; s2+=r1; l1-=r1; l2-=r1;\n");
            cb.append("}\n");
        }

        void genCode(String destDir, ArrayList<String> options) throws IOException {
            JType.JavaType type;
            String name;
            JType.JavaType type2;
            String name2;
            JType.JavaType type3;
            String name3;
            JType.JavaType type4;
            String name4;
            String pkg = this.module;
            String pkgpath = pkg.replaceAll("\\.", "/");
            File pkgdir = new File(destDir, pkgpath);
            File jfile = new File(pkgdir, this.name + ".java");
            if (!pkgdir.exists()) {
                boolean ret = pkgdir.mkdirs();
                if (!ret) {
                    throw new IOException("Cannnot create directory: " + pkgpath);
                }
            } else if (!pkgdir.isDirectory()) {
                throw new IOException(pkgpath + " is not a directory.");
            }
            CodeBuffer cb = new CodeBuffer();
            cb.append("// File generated by hadoop record compiler. Do not edit.\n");
            cb.append("package " + this.module + ";\n\n");
            cb.append("public class " + this.name + " extends org.apache.hadoop.record.Record {\n");
            cb.append("private static final org.apache.hadoop.record.meta.RecordTypeInfo _rio_recTypeInfo;\n");
            cb.append("private static org.apache.hadoop.record.meta.RecordTypeInfo _rio_rtiFilter;\n");
            cb.append("private static int[] _rio_rtiFilterFields;\n");
            cb.append("static {\n");
            cb.append("_rio_recTypeInfo = new org.apache.hadoop.record.meta.RecordTypeInfo(\"" + this.name + "\");\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name4 = jf.getName();
                type4 = jf.getType();
                type4.genStaticTypeInfo(cb, name4);
            }
            cb.append("}\n\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name4 = jf.getName();
                type4 = jf.getType();
                type4.genDecl(cb, name4);
            }
            cb.append("public " + this.name + "() { }\n");
            cb.append("public " + this.name + "(\n");
            int fIdx = 0;
            Iterator<JField<JType.JavaType>> i = this.fields.iterator();
            while (i.hasNext()) {
                JField<JType.JavaType> jf = i.next();
                name3 = jf.getName();
                type3 = jf.getType();
                type3.genConstructorParam(cb, name3);
                cb.append(!i.hasNext() ? "" : ",\n");
                ++fIdx;
            }
            cb.append(") {\n");
            fIdx = 0;
            for (JField<JType.JavaType> jf : this.fields) {
                name3 = jf.getName();
                type3 = jf.getType();
                type3.genConstructorSet(cb, name3);
                ++fIdx;
            }
            cb.append("}\n");
            cb.append("public static org.apache.hadoop.record.meta.RecordTypeInfo getTypeInfo() {\n");
            cb.append("return _rio_recTypeInfo;\n");
            cb.append("}\n");
            cb.append("public static void setTypeFilter(org.apache.hadoop.record.meta.RecordTypeInfo rti) {\n");
            cb.append("if (null == rti) return;\n");
            cb.append("_rio_rtiFilter = rti;\n");
            cb.append("_rio_rtiFilterFields = null;\n");
            HashMap<String, Integer> nestedStructMap = new HashMap<String, Integer>();
            for (JField<JType.JavaType> jf : this.fields) {
                type3 = jf.getType();
                type3.genSetRTIFilter(cb, nestedStructMap);
            }
            cb.append("}\n");
            this.genSetupRtiFields(cb);
            for (JField<JType.JavaType> jf : this.fields) {
                name2 = jf.getName();
                type2 = jf.getType();
                type2.genGetSet(cb, name2);
            }
            cb.append("public void serialize(final org.apache.hadoop.record.RecordOutput _rio_a, final String _rio_tag)\nthrows java.io.IOException {\n");
            cb.append("_rio_a.startRecord(this,_rio_tag);\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name2 = jf.getName();
                type2 = jf.getType();
                type2.genWriteMethod(cb, name2, name2);
            }
            cb.append("_rio_a.endRecord(this,_rio_tag);\n");
            cb.append("}\n");
            cb.append("private void deserializeWithoutFilter(final org.apache.hadoop.record.RecordInput _rio_a, final String _rio_tag)\nthrows java.io.IOException {\n");
            cb.append("_rio_a.startRecord(_rio_tag);\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name2 = jf.getName();
                type2 = jf.getType();
                type2.genReadMethod(cb, name2, name2, false);
            }
            cb.append("_rio_a.endRecord(_rio_tag);\n");
            cb.append("}\n");
            cb.append("public void deserialize(final org.apache.hadoop.record.RecordInput _rio_a, final String _rio_tag)\nthrows java.io.IOException {\n");
            cb.append("if (null == _rio_rtiFilter) {\n");
            cb.append("deserializeWithoutFilter(_rio_a, _rio_tag);\n");
            cb.append("return;\n");
            cb.append("}\n");
            cb.append("// if we're here, we need to read based on version info\n");
            cb.append("_rio_a.startRecord(_rio_tag);\n");
            cb.append("setupRtiFields();\n");
            cb.append("for (int _rio_i=0; _rio_i<_rio_rtiFilter.getFieldTypeInfos().size(); _rio_i++) {\n");
            int ct = 0;
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                if (1 != ++ct) {
                    cb.append("else ");
                }
                cb.append("if (" + ct + " == " + "_rio_rtiFilterFields" + "[" + "_rio_" + "i]) {\n");
                type.genReadMethod(cb, name, name, false);
                cb.append("}\n");
            }
            if (0 != ct) {
                cb.append("else {\n");
                cb.append("java.util.ArrayList<org.apache.hadoop.record.meta.FieldTypeInfo> typeInfos = (java.util.ArrayList<org.apache.hadoop.record.meta.FieldTypeInfo>)(_rio_rtiFilter.getFieldTypeInfos());\n");
                cb.append("org.apache.hadoop.record.meta.Utils.skip(_rio_a, typeInfos.get(_rio_i).getFieldID(), typeInfos.get(_rio_i).getTypeID());\n");
                cb.append("}\n");
            }
            cb.append("}\n");
            cb.append("_rio_a.endRecord(_rio_tag);\n");
            cb.append("}\n");
            cb.append("public int compareTo (final Object _rio_peer_) throws ClassCastException {\n");
            cb.append("if (!(_rio_peer_ instanceof " + this.name + ")) {\n");
            cb.append("throw new ClassCastException(\"Comparing different types of records.\");\n");
            cb.append("}\n");
            cb.append(this.name + " " + "_rio_" + "peer = (" + this.name + ") " + "_rio_" + "peer_;\n");
            cb.append("int _rio_ret = 0;\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genCompareTo(cb, name, "_rio_peer." + name);
                cb.append("if (_rio_ret != 0) return _rio_ret;\n");
            }
            cb.append("return _rio_ret;\n");
            cb.append("}\n");
            cb.append("public boolean equals(final Object _rio_peer_) {\n");
            cb.append("if (!(_rio_peer_ instanceof " + this.name + ")) {\n");
            cb.append("return false;\n");
            cb.append("}\n");
            cb.append("if (_rio_peer_ == this) {\n");
            cb.append("return true;\n");
            cb.append("}\n");
            cb.append(this.name + " " + "_rio_" + "peer = (" + this.name + ") " + "_rio_" + "peer_;\n");
            cb.append("boolean _rio_ret = false;\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genEquals(cb, name, "_rio_peer." + name);
                cb.append("if (!_rio_ret) return _rio_ret;\n");
            }
            cb.append("return _rio_ret;\n");
            cb.append("}\n");
            cb.append("public Object clone() throws CloneNotSupportedException {\n");
            cb.append(this.name + " " + "_rio_" + "other = new " + this.name + "();\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genClone(cb, name);
            }
            cb.append("return _rio_other;\n");
            cb.append("}\n");
            cb.append("public int hashCode() {\n");
            cb.append("int _rio_result = 17;\n");
            cb.append("int _rio_ret;\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genHashCode(cb, name);
                cb.append("_rio_result = 37*_rio_result + _rio_ret;\n");
            }
            cb.append("return _rio_result;\n");
            cb.append("}\n");
            cb.append("public static String signature() {\n");
            cb.append("return \"" + JRecord.this.getSignature() + "\";\n");
            cb.append("}\n");
            cb.append("public static class Comparator extends org.apache.hadoop.record.RecordComparator {\n");
            cb.append("public Comparator() {\n");
            cb.append("super(" + this.name + ".class);\n");
            cb.append("}\n");
            cb.append("static public int slurpRaw(byte[] b, int s, int l) {\n");
            cb.append("try {\n");
            cb.append("int os = s;\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genSlurpBytes(cb, "b", "s", "l");
            }
            cb.append("return (os - s);\n");
            cb.append("} catch(java.io.IOException e) {\n");
            cb.append("throw new RuntimeException(e);\n");
            cb.append("}\n");
            cb.append("}\n");
            cb.append("static public int compareRaw(byte[] b1, int s1, int l1,\n");
            cb.append("                             byte[] b2, int s2, int l2) {\n");
            cb.append("try {\n");
            cb.append("int os1 = s1;\n");
            for (JField<JType.JavaType> jf : this.fields) {
                name = jf.getName();
                type = jf.getType();
                type.genCompareBytes(cb);
            }
            cb.append("return (os1 - s1);\n");
            cb.append("} catch(java.io.IOException e) {\n");
            cb.append("throw new RuntimeException(e);\n");
            cb.append("}\n");
            cb.append("}\n");
            cb.append("public int compare(byte[] b1, int s1, int l1,\n");
            cb.append("                   byte[] b2, int s2, int l2) {\n");
            cb.append("int ret = compareRaw(b1,s1,l1,b2,s2,l2);\n");
            cb.append("return (ret == -1)? -1 : ((ret==0)? 1 : 0);");
            cb.append("}\n");
            cb.append("}\n\n");
            cb.append("static {\n");
            cb.append("org.apache.hadoop.record.RecordComparator.define(" + this.name + ".class, new Comparator());\n");
            cb.append("}\n");
            cb.append("}\n");
            try (FileWriterWithEncoding jj = new FileWriterWithEncoding(jfile, Charsets.UTF_8);){
                ((Writer)jj).write(cb.toString());
            }
        }
    }
}

