/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeHealthScriptRunner
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(NodeHealthScriptRunner.class);
    private String nodeHealthScript;
    private long intervalTime;
    private long scriptTimeout;
    private Timer nodeHealthScriptScheduler;
    Shell.ShellCommandExecutor shexec = null;
    private static final String ERROR_PATTERN = "ERROR";
    public static final String NODE_HEALTH_SCRIPT_TIMED_OUT_MSG = "Node health script timed out";
    private boolean isHealthy = true;
    private String healthReport = "";
    private long lastReportedTime = System.currentTimeMillis();
    private TimerTask timer;

    public NodeHealthScriptRunner(String scriptName, long chkInterval, long timeout, String[] scriptArgs) {
        super(NodeHealthScriptRunner.class.getName());
        this.nodeHealthScript = scriptName;
        this.intervalTime = chkInterval;
        this.scriptTimeout = timeout;
        this.timer = new NodeHealthMonitorExecutor(scriptArgs);
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        this.nodeHealthScriptScheduler = new Timer("NodeHealthMonitor-Timer", true);
        this.nodeHealthScriptScheduler.scheduleAtFixedRate(this.timer, 0L, this.intervalTime);
        super.serviceStart();
    }

    @Override
    protected void serviceStop() {
        Process p;
        if (this.nodeHealthScriptScheduler != null) {
            this.nodeHealthScriptScheduler.cancel();
        }
        if (this.shexec != null && (p = this.shexec.getProcess()) != null) {
            p.destroy();
        }
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    private synchronized void setHealthy(boolean isHealthy) {
        this.isHealthy = isHealthy;
    }

    public String getHealthReport() {
        return this.healthReport;
    }

    private synchronized void setHealthReport(String healthReport) {
        this.healthReport = healthReport;
    }

    public long getLastReportedTime() {
        return this.lastReportedTime;
    }

    private synchronized void setLastReportedTime(long lastReportedTime) {
        this.lastReportedTime = lastReportedTime;
    }

    public static boolean shouldRun(String healthScript) {
        if (healthScript == null || healthScript.trim().isEmpty()) {
            return false;
        }
        File f = new File(healthScript);
        return f.exists() && FileUtil.canExecute(f);
    }

    private synchronized void setHealthStatus(boolean isHealthy, String output) {
        LOG.info("health status being set as " + output);
        this.setHealthy(isHealthy);
        this.setHealthReport(output);
    }

    private synchronized void setHealthStatus(boolean isHealthy, String output, long time) {
        LOG.info("health status being set as " + output);
        this.setHealthStatus(isHealthy, output);
        this.setLastReportedTime(time);
    }

    public TimerTask getTimerTask() {
        return this.timer;
    }

    private class NodeHealthMonitorExecutor
    extends TimerTask {
        String exceptionStackTrace = "";

        public NodeHealthMonitorExecutor(String[] args) {
            ArrayList<String> execScript = new ArrayList<String>();
            execScript.add(NodeHealthScriptRunner.this.nodeHealthScript);
            if (args != null) {
                execScript.addAll(Arrays.asList(args));
            }
            NodeHealthScriptRunner.this.shexec = new Shell.ShellCommandExecutor(execScript.toArray(new String[execScript.size()]), null, null, NodeHealthScriptRunner.this.scriptTimeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HealthCheckerExitStatus status = HealthCheckerExitStatus.SUCCESS;
            try {
                NodeHealthScriptRunner.this.shexec.execute();
            }
            catch (Shell.ExitCodeException e) {
                status = HealthCheckerExitStatus.FAILED_WITH_EXIT_CODE;
                if (Shell.WINDOWS && NodeHealthScriptRunner.this.shexec.isTimedOut()) {
                    status = HealthCheckerExitStatus.TIMED_OUT;
                }
            }
            catch (Exception e) {
                LOG.warn("Caught exception : " + e.getMessage());
                status = !NodeHealthScriptRunner.this.shexec.isTimedOut() ? HealthCheckerExitStatus.FAILED_WITH_EXCEPTION : HealthCheckerExitStatus.TIMED_OUT;
                this.exceptionStackTrace = StringUtils.stringifyException(e);
            }
            finally {
                if (status == HealthCheckerExitStatus.SUCCESS && this.hasErrors(NodeHealthScriptRunner.this.shexec.getOutput())) {
                    status = HealthCheckerExitStatus.FAILED;
                }
                this.reportHealthStatus(status);
            }
        }

        void reportHealthStatus(HealthCheckerExitStatus status) {
            long now = System.currentTimeMillis();
            switch (status) {
                case SUCCESS: {
                    NodeHealthScriptRunner.this.setHealthStatus(true, "", now);
                    break;
                }
                case TIMED_OUT: {
                    NodeHealthScriptRunner.this.setHealthStatus(false, NodeHealthScriptRunner.NODE_HEALTH_SCRIPT_TIMED_OUT_MSG);
                    break;
                }
                case FAILED_WITH_EXCEPTION: {
                    NodeHealthScriptRunner.this.setHealthStatus(false, this.exceptionStackTrace);
                    break;
                }
                case FAILED_WITH_EXIT_CODE: {
                    NodeHealthScriptRunner.this.setHealthStatus(true, "", now);
                    break;
                }
                case FAILED: {
                    NodeHealthScriptRunner.this.setHealthStatus(false, NodeHealthScriptRunner.this.shexec.getOutput());
                }
            }
        }

        private boolean hasErrors(String output) {
            String[] splits;
            for (String split2 : splits = output.split("\n")) {
                if (!split2.startsWith(NodeHealthScriptRunner.ERROR_PATTERN)) continue;
                return true;
            }
            return false;
        }
    }

    private static enum HealthCheckerExitStatus {
        SUCCESS,
        TIMED_OUT,
        FAILED_WITH_EXIT_CODE,
        FAILED_WITH_EXCEPTION,
        FAILED;

    }
}

