/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.ApplicationClassLoader;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RunJar {
    private static final Logger LOG = LoggerFactory.getLogger(RunJar.class);
    public static final Pattern MATCH_ANY = Pattern.compile(".*");
    public static final int SHUTDOWN_HOOK_PRIORITY = 10;
    public static final String HADOOP_USE_CLIENT_CLASSLOADER = "HADOOP_USE_CLIENT_CLASSLOADER";
    public static final String HADOOP_CLASSPATH = "HADOOP_CLASSPATH";
    public static final String HADOOP_CLIENT_CLASSLOADER_SYSTEM_CLASSES = "HADOOP_CLIENT_CLASSLOADER_SYSTEM_CLASSES";
    private static final int BUFFER_SIZE = 8192;

    public static void unJar(File jarFile, File toDir) throws IOException {
        RunJar.unJar(jarFile, toDir, MATCH_ANY);
    }

    public static void unJar(File jarFile, File toDir, Pattern unpackRegex) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            int numOfFailedLastModifiedSet = 0;
            String targetDirPath = toDir.getCanonicalPath() + File.separator;
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry2 = entries.nextElement();
                if (entry2.isDirectory() || !unpackRegex.matcher(entry2.getName()).matches()) continue;
                InputStream in = jar.getInputStream(entry2);
                Throwable throwable = null;
                try {
                    File file = new File(toDir, entry2.getName());
                    RunJar.ensureDirectory(file.getParentFile());
                    if (!file.getCanonicalPath().startsWith(targetDirPath)) {
                        throw new IOException("expanding " + entry2.getName() + " would create file outside of " + toDir);
                    }
                    try (FileOutputStream out = new FileOutputStream(file);){
                        IOUtils.copyBytes(in, (OutputStream)out, 8192);
                    }
                    if (file.setLastModified(entry2.getTime())) continue;
                    ++numOfFailedLastModifiedSet;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            if (numOfFailedLastModifiedSet > 0) {
                LOG.warn("Could not set last modfied time for {} file(s)", (Object)numOfFailedLastModifiedSet);
            }
        }
    }

    private static void ensureDirectory(File dir) throws IOException {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + dir.toString());
        }
    }

    public static void main(String[] args) throws Throwable {
        new RunJar().run(args);
    }

    public void run(String[] args) throws Throwable {
        File workDir;
        JarFile jarFile;
        String fileName;
        File file;
        String usage = "RunJar jarFile [mainClass] args...";
        if (args.length < 1) {
            System.err.println(usage);
            System.exit(-1);
        }
        int firstArg = 0;
        if (!(file = new File(fileName = args[firstArg++])).exists() || !file.isFile()) {
            System.err.println("JAR does not exist or is not a normal file: " + file.getCanonicalPath());
            System.exit(-1);
        }
        String mainClassName = null;
        try {
            jarFile = new JarFile(fileName);
        }
        catch (IOException io) {
            throw new IOException("Error opening job jar: " + fileName).initCause(io);
        }
        Manifest manifest = jarFile.getManifest();
        if (manifest != null) {
            mainClassName = manifest.getMainAttributes().getValue("Main-Class");
        }
        jarFile.close();
        if (mainClassName == null) {
            if (args.length < 2) {
                System.err.println(usage);
                System.exit(-1);
            }
            mainClassName = args[firstArg++];
        }
        mainClassName = mainClassName.replaceAll("/", ".");
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        RunJar.ensureDirectory(tmpDir);
        try {
            workDir = File.createTempFile("hadoop-unjar", "", tmpDir);
        }
        catch (IOException ioe) {
            System.err.println("Error creating temp dir in java.io.tmpdir " + tmpDir + " due to " + ioe.getMessage());
            System.exit(-1);
            return;
        }
        if (!workDir.delete()) {
            System.err.println("Delete failed for " + workDir);
            System.exit(-1);
        }
        RunJar.ensureDirectory(workDir);
        ShutdownHookManager.get().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                FileUtil.fullyDelete(workDir);
            }
        }, 10);
        RunJar.unJar(file, workDir);
        ClassLoader loader = this.createClassLoader(file, workDir);
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> mainClass = Class.forName(mainClassName, true, loader);
        Method main2 = mainClass.getMethod("main", String[].class);
        List<String> newArgsSubList = Arrays.asList(args).subList(firstArg, args.length);
        String[] newArgs = newArgsSubList.toArray(new String[newArgsSubList.size()]);
        try {
            main2.invoke(null, new Object[]{newArgs});
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private ClassLoader createClassLoader(File file, File workDir) throws MalformedURLException {
        URLClassLoader loader;
        if (this.useClientClassLoader()) {
            StringBuilder sb = new StringBuilder();
            sb.append(workDir).append("/").append(File.pathSeparator).append(file).append(File.pathSeparator).append(workDir).append("/classes/").append(File.pathSeparator).append(workDir).append("/lib/*");
            String hadoopClasspath = this.getHadoopClasspath();
            if (hadoopClasspath != null && !hadoopClasspath.isEmpty()) {
                sb.append(File.pathSeparator).append(hadoopClasspath);
            }
            String clientClasspath = sb.toString();
            String systemClasses = this.getSystemClasses();
            List<String> systemClassesList = systemClasses == null ? null : Arrays.asList(StringUtils.getTrimmedStrings(systemClasses));
            loader = new ApplicationClassLoader(clientClasspath, this.getClass().getClassLoader(), systemClassesList);
        } else {
            ArrayList<URL> classPath = new ArrayList<URL>();
            classPath.add(new File(workDir + "/").toURI().toURL());
            classPath.add(file.toURI().toURL());
            classPath.add(new File(workDir, "classes/").toURI().toURL());
            File[] libs = new File(workDir, "lib").listFiles();
            if (libs != null) {
                for (File lib : libs) {
                    classPath.add(lib.toURI().toURL());
                }
            }
            loader = new URLClassLoader(classPath.toArray(new URL[classPath.size()]));
        }
        return loader;
    }

    boolean useClientClassLoader() {
        return Boolean.parseBoolean(System.getenv(HADOOP_USE_CLIENT_CLASSLOADER));
    }

    String getHadoopClasspath() {
        return System.getenv(HADOOP_CLASSPATH);
    }

    String getSystemClasses() {
        return System.getenv(HADOOP_CLIENT_CLASSLOADER_SYSTEM_CLASSES);
    }
}

