/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VersionInfo.class);
    private Properties info = new Properties();
    private static VersionInfo COMMON_VERSION_INFO = new VersionInfo("common");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VersionInfo(String component) {
        String versionInfoFile = component + "-version-info.properties";
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(versionInfoFile);
            if (is == null) {
                throw new IOException("Resource not found");
            }
            this.info.load(is);
        }
        catch (IOException ex) {
            try {
                LoggerFactory.getLogger(this.getClass()).warn("Could not read '" + versionInfoFile + "', " + ex.toString(), ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(is);
                throw throwable;
            }
            IOUtils.closeStream(is);
        }
        IOUtils.closeStream(is);
    }

    protected String _getVersion() {
        return this.info.getProperty("version", "Unknown");
    }

    protected String _getRevision() {
        return this.info.getProperty("revision", "Unknown");
    }

    protected String _getBranch() {
        return this.info.getProperty("branch", "Unknown");
    }

    protected String _getDate() {
        return this.info.getProperty("date", "Unknown");
    }

    protected String _getUser() {
        return this.info.getProperty("user", "Unknown");
    }

    protected String _getUrl() {
        return this.info.getProperty("url", "Unknown");
    }

    protected String _getSrcChecksum() {
        return this.info.getProperty("srcChecksum", "Unknown");
    }

    protected String _getBuildVersion() {
        return this._getVersion() + " from " + this._getRevision() + " by " + this._getUser() + " source checksum " + this._getSrcChecksum();
    }

    protected String _getProtocVersion() {
        return this.info.getProperty("protocVersion", "Unknown");
    }

    public static String getVersion() {
        return COMMON_VERSION_INFO._getVersion();
    }

    public static String getRevision() {
        return COMMON_VERSION_INFO._getRevision();
    }

    public static String getBranch() {
        return COMMON_VERSION_INFO._getBranch();
    }

    public static String getDate() {
        return COMMON_VERSION_INFO._getDate();
    }

    public static String getUser() {
        return COMMON_VERSION_INFO._getUser();
    }

    public static String getUrl() {
        return COMMON_VERSION_INFO._getUrl();
    }

    public static String getSrcChecksum() {
        return COMMON_VERSION_INFO._getSrcChecksum();
    }

    public static String getBuildVersion() {
        return COMMON_VERSION_INFO._getBuildVersion();
    }

    public static String getProtocVersion() {
        return COMMON_VERSION_INFO._getProtocVersion();
    }

    public static void main(String[] args) {
        LOG.debug("version: " + VersionInfo.getVersion());
        System.out.println("Hadoop " + VersionInfo.getVersion());
        System.out.println("Subversion " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision());
        System.out.println("Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate());
        System.out.println("Compiled with protoc " + VersionInfo.getProtocVersion());
        System.out.println("From source with checksum " + VersionInfo.getSrcChecksum());
        System.out.println("This command was run using " + ClassUtil.findContainingJar(VersionInfo.class));
    }
}

