/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.bloom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableComparable;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class Key
implements WritableComparable<Key> {
    byte[] bytes;
    double weight;

    public Key() {
    }

    public Key(byte[] value2) {
        this(value2, 1.0);
    }

    public Key(byte[] value2, double weight) {
        this.set(value2, weight);
    }

    public void set(byte[] value2, double weight) {
        if (value2 == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        this.bytes = value2;
        this.weight = weight;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public double getWeight() {
        return this.weight;
    }

    public void incrementWeight(double weight) {
        this.weight += weight;
    }

    public void incrementWeight() {
        this.weight += 1.0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Key)) {
            return false;
        }
        return this.compareTo((Key)o) == 0;
    }

    public int hashCode() {
        int result2 = 0;
        for (int i = 0; i < this.bytes.length; ++i) {
            result2 ^= Byte.valueOf(this.bytes[i]).hashCode();
        }
        return result2 ^= Double.valueOf(this.weight).hashCode();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.bytes.length);
        out.write(this.bytes);
        out.writeDouble(this.weight);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.bytes = new byte[in.readInt()];
        in.readFully(this.bytes);
        this.weight = in.readDouble();
    }

    @Override
    public int compareTo(Key other) {
        int result2 = this.bytes.length - other.getBytes().length;
        for (int i = 0; result2 == 0 && i < this.bytes.length; ++i) {
            result2 = this.bytes[i] - other.bytes[i];
        }
        if (result2 == 0) {
            result2 = (int)(this.weight - other.weight);
        }
        return result2;
    }
}

