/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.ser;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;
import org.apache.htrace.shaded.fasterxml.jackson.annotation.JsonFormat;
import org.apache.htrace.shaded.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.htrace.shaded.fasterxml.jackson.databind.BeanDescription;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonSerializable;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.MapperFeature;
import org.apache.htrace.shaded.fasterxml.jackson.databind.SerializationConfig;
import org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.htrace.shaded.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.Annotated;
import org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.ContainerSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.SerializerFactory;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.Serializers;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl.IndexedListSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl.IndexedStringListSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl.IteratorSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl.StringArraySerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl.StringCollectionSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.BooleanSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.ByteBufferSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.DateSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.EnumMapSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.EnumSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.EnumSetSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.InetAddressSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.InetSocketAddressSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.IterableSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.MapSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.NumberSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.NumberSerializers;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.ObjectArraySerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.SerializableSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.SqlTimeSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdKeySerializers;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StringSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.TimeZoneSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.TokenBufferSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.ArrayType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.CollectionLikeType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.CollectionType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.MapType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.ClassUtil;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.Converter;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.EnumValues;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.TokenBuffer;

public abstract class BasicSerializerFactory
extends SerializerFactory
implements Serializable {
    protected static final HashMap<String, JsonSerializer<?>> _concrete = new HashMap();
    protected static final HashMap<String, Class<? extends JsonSerializer<?>>> _concreteLazy = new HashMap();
    protected final SerializerFactoryConfig _factoryConfig;

    protected BasicSerializerFactory(SerializerFactoryConfig config) {
        this._factoryConfig = config == null ? new SerializerFactoryConfig() : config;
    }

    public SerializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    public abstract SerializerFactory withConfig(SerializerFactoryConfig var1);

    @Override
    public final SerializerFactory withAdditionalSerializers(Serializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalSerializers(additional));
    }

    @Override
    public final SerializerFactory withAdditionalKeySerializers(Serializers additional) {
        return this.withConfig(this._factoryConfig.withAdditionalKeySerializers(additional));
    }

    @Override
    public final SerializerFactory withSerializerModifier(BeanSerializerModifier modifier) {
        return this.withConfig(this._factoryConfig.withSerializerModifier(modifier));
    }

    @Override
    public abstract JsonSerializer<Object> createSerializer(SerializerProvider var1, JavaType var2) throws JsonMappingException;

    @Override
    public JsonSerializer<Object> createKeySerializer(SerializationConfig config, JavaType keyType, JsonSerializer<Object> defaultImpl) {
        BeanDescription beanDesc = config.introspectClassAnnotations(keyType.getRawClass());
        JsonSerializer<Object> ser = null;
        if (this._factoryConfig.hasKeySerializers()) {
            Serializers serializers;
            Iterator<Object> i$ = this._factoryConfig.keySerializers().iterator();
            while (i$.hasNext() && (ser = (serializers = i$.next()).findSerializer(config, keyType, beanDesc)) == null) {
            }
        }
        if (ser == null && (ser = defaultImpl) == null) {
            ser = StdKeySerializers.getStdKeySerializer(keyType);
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyKeySerializer(config, keyType, beanDesc, ser);
            }
        }
        return ser;
    }

    @Override
    public TypeSerializer createTypeSerializer(SerializationConfig config, JavaType baseType) {
        BeanDescription bean = config.introspectClassAnnotations(baseType.getRawClass());
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(config, ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(ac, config, ai);
        }
        if (b == null) {
            return null;
        }
        return b.buildTypeSerializer(config, baseType, subtypes);
    }

    protected abstract Iterable<Serializers> customSerializers();

    protected final JsonSerializer<?> findSerializerByLookup(JavaType type, SerializationConfig config, BeanDescription beanDesc, boolean staticTyping) {
        Class<JsonSerializer<?>> serClass;
        Class<?> raw2 = type.getRawClass();
        String clsName = raw2.getName();
        JsonSerializer<?> ser = _concrete.get(clsName);
        if (ser == null && (serClass = _concreteLazy.get(clsName)) != null) {
            try {
                return serClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate standard serializer (of type " + serClass.getName() + "): " + e.getMessage(), e);
            }
        }
        return ser;
    }

    protected final JsonSerializer<?> findSerializerByAnnotations(SerializerProvider prov, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw2 = type.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(raw2)) {
            return SerializableSerializer.instance;
        }
        AnnotatedMethod valueMethod = beanDesc.findJsonValueMethod();
        if (valueMethod != null) {
            Method m3 = valueMethod.getAnnotated();
            if (prov.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(m3);
            }
            JsonSerializer<Object> ser = this.findSerializerFromAnnotation(prov, valueMethod);
            return new JsonValueSerializer(m3, ser);
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByPrimaryType(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        Class<?> raw2 = type.getRawClass();
        JsonSerializer<?> ser = this.findOptionalStdSerializer(prov, type, beanDesc, staticTyping);
        if (ser != null) {
            return ser;
        }
        if (Calendar.class.isAssignableFrom(raw2)) {
            return CalendarSerializer.instance;
        }
        if (Date.class.isAssignableFrom(raw2)) {
            return DateSerializer.instance;
        }
        if (ByteBuffer.class.isAssignableFrom(raw2)) {
            return new ByteBufferSerializer();
        }
        if (InetAddress.class.isAssignableFrom(raw2)) {
            return new InetAddressSerializer();
        }
        if (InetSocketAddress.class.isAssignableFrom(raw2)) {
            return new InetSocketAddressSerializer();
        }
        if (TimeZone.class.isAssignableFrom(raw2)) {
            return new TimeZoneSerializer();
        }
        if (Charset.class.isAssignableFrom(raw2)) {
            return ToStringSerializer.instance;
        }
        if (Number.class.isAssignableFrom(raw2)) {
            JsonFormat.Value format2 = beanDesc.findExpectedFormat(null);
            if (format2 != null) {
                switch (format2.getShape()) {
                    case STRING: {
                        return ToStringSerializer.instance;
                    }
                    case OBJECT: 
                    case ARRAY: {
                        return null;
                    }
                }
            }
            return NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(raw2)) {
            return this.buildEnumSerializer(prov.getConfig(), type, beanDesc);
        }
        return null;
    }

    protected JsonSerializer<?> findOptionalStdSerializer(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        return OptionalHandlerFactory.instance.findSerializer(prov.getConfig(), type, beanDesc);
    }

    protected final JsonSerializer<?> findSerializerByAddonType(SerializationConfig config, JavaType javaType, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        Class<?> type = javaType.getRawClass();
        if (Iterator.class.isAssignableFrom(type)) {
            return this.buildIteratorSerializer(config, javaType, beanDesc, staticTyping);
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return this.buildIterableSerializer(config, javaType, beanDesc, staticTyping);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializerProvider prov, Annotated a) throws JsonMappingException {
        Object serDef = prov.getAnnotationIntrospector().findSerializer(a);
        if (serDef == null) {
            return null;
        }
        JsonSerializer<Object> ser = prov.serializerInstance(a, serDef);
        return this.findConvertingSerializer(prov, a, ser);
    }

    protected JsonSerializer<?> findConvertingSerializer(SerializerProvider prov, Annotated a, JsonSerializer<?> ser) throws JsonMappingException {
        Converter<Object, Object> conv = this.findConverter(prov, a);
        if (conv == null) {
            return ser;
        }
        JavaType delegateType = conv.getOutputType(prov.getTypeFactory());
        return new StdDelegatingSerializer(conv, delegateType, ser);
    }

    protected Converter<Object, Object> findConverter(SerializerProvider prov, Annotated a) throws JsonMappingException {
        Object convDef = prov.getAnnotationIntrospector().findSerializationConverter(a);
        if (convDef == null) {
            return null;
        }
        return prov.converterInstance(a, convDef);
    }

    protected JsonSerializer<?> buildContainerSerializer(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType elementType;
        TypeSerializer elementTypeSerializer;
        SerializationConfig config = prov.getConfig();
        if (!(staticTyping || !type.useStaticType() || type.isContainerType() && type.getContentType().getRawClass() == Object.class)) {
            staticTyping = true;
        }
        if ((elementTypeSerializer = this.createTypeSerializer(config, elementType = type.getContentType())) != null) {
            staticTyping = false;
        }
        JsonSerializer<Object> elementValueSerializer = this._findContentSerializer(prov, beanDesc.getClassInfo());
        if (type.isMapLikeType()) {
            MapLikeType mlt = (MapLikeType)type;
            JsonSerializer<Object> keySerializer = this._findKeySerializer(prov, beanDesc.getClassInfo());
            if (mlt.isTrueMapType()) {
                return this.buildMapSerializer(config, (MapType)mlt, beanDesc, staticTyping, keySerializer, elementTypeSerializer, elementValueSerializer);
            }
            for (Serializers serializers : this.customSerializers()) {
                MapLikeType mlType;
                JsonSerializer<?> ser = serializers.findMapLikeSerializer(config, mlType = (MapLikeType)type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
                if (ser == null) continue;
                if (this._factoryConfig.hasSerializerModifiers()) {
                    for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                        ser = mod.modifyMapLikeSerializer(config, mlType, beanDesc, ser);
                    }
                }
                return ser;
            }
            return null;
        }
        if (type.isCollectionLikeType()) {
            CollectionLikeType clt = (CollectionLikeType)type;
            if (clt.isTrueCollectionType()) {
                return this.buildCollectionSerializer(config, (CollectionType)clt, beanDesc, staticTyping, elementTypeSerializer, elementValueSerializer);
            }
            CollectionLikeType clType = (CollectionLikeType)type;
            for (Serializers serializers : this.customSerializers()) {
                JsonSerializer<?> ser = serializers.findCollectionLikeSerializer(config, clType, beanDesc, elementTypeSerializer, elementValueSerializer);
                if (ser == null) continue;
                if (this._factoryConfig.hasSerializerModifiers()) {
                    for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                        ser = mod.modifyCollectionLikeSerializer(config, clType, beanDesc, ser);
                    }
                }
                return ser;
            }
            return null;
        }
        if (type.isArrayType()) {
            return this.buildArraySerializer(config, (ArrayType)type, beanDesc, staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        return null;
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        Serializers serializers;
        StdSerializer ser = null;
        Iterator<Object> i$ = this.customSerializers().iterator();
        while (i$.hasNext() && (ser = (serializers = i$.next()).findCollectionSerializer(config, type, beanDesc, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        if (ser == null) {
            JsonFormat.Value format2 = beanDesc.findExpectedFormat(null);
            if (format2 != null && format2.getShape() == JsonFormat.Shape.OBJECT) {
                return null;
            }
            Class<?> raw2 = type.getRawClass();
            if (EnumSet.class.isAssignableFrom(raw2)) {
                JavaType enumType = type.getContentType();
                if (!enumType.isEnumType()) {
                    enumType = null;
                }
                ser = this.buildEnumSetSerializer(enumType);
            } else {
                Class<?> elementRaw = type.getContentType().getRawClass();
                if (this.isIndexedList(raw2)) {
                    if (elementRaw == String.class) {
                        if (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
                            ser = IndexedStringListSerializer.instance;
                        }
                    } else {
                        ser = this.buildIndexedListSerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
                    }
                } else if (elementRaw == String.class && (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer))) {
                    ser = StringCollectionSerializer.instance;
                }
                if (ser == null) {
                    ser = this.buildCollectionSerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
                }
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyCollectionSerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected boolean isIndexedList(Class<?> cls) {
        return RandomAccess.class.isAssignableFrom(cls);
    }

    public ContainerSerializer<?> buildIndexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        return new IndexedListSerializer(elemType, staticTyping, vts, null, valueSerializer);
    }

    public ContainerSerializer<?> buildCollectionSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        return new CollectionSerializer(elemType, staticTyping, vts, null, valueSerializer);
    }

    public JsonSerializer<?> buildEnumSetSerializer(JavaType enumType) {
        return new EnumSetSerializer(enumType, null);
    }

    protected JsonSerializer<?> buildMapSerializer(SerializationConfig config, MapType type, BeanDescription beanDesc, boolean staticTyping, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        Serializers serializers;
        JsonSerializer ser = null;
        Iterator<Object> i$ = this.customSerializers().iterator();
        while (i$.hasNext() && (ser = (serializers = i$.next()).findMapSerializer(config, type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        if (ser == null) {
            if (EnumMap.class.isAssignableFrom(type.getRawClass())) {
                JavaType keyType = type.getKeyType();
                EnumValues enums = null;
                if (keyType.isEnumType()) {
                    Class<Enum<?>> enumClass = keyType.getRawClass();
                    enums = EnumValues.construct(config, enumClass);
                }
                ser = new EnumMapSerializer(type.getContentType(), staticTyping, enums, elementTypeSerializer, elementValueSerializer);
            } else {
                Object filterId = this.findFilterId(config, beanDesc);
                ser = MapSerializer.construct(config.getAnnotationIntrospector().findPropertiesToIgnore(beanDesc.getClassInfo()), type, staticTyping, elementTypeSerializer, keySerializer, elementValueSerializer, filterId);
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyMapSerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected JsonSerializer<?> buildArraySerializer(SerializationConfig config, ArrayType type, BeanDescription beanDesc, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        Serializers serializers;
        JsonSerializer ser = null;
        Iterator<Object> i$ = this.customSerializers().iterator();
        while (i$.hasNext() && (ser = (serializers = i$.next()).findArraySerializer(config, type, beanDesc, elementTypeSerializer, elementValueSerializer)) == null) {
        }
        if (ser == null) {
            Class<?> raw2 = type.getRawClass();
            if (elementValueSerializer == null || ClassUtil.isJacksonStdImpl(elementValueSerializer)) {
                ser = String[].class == raw2 ? StringArraySerializer.instance : StdArraySerializers.findStandardImpl(raw2);
            }
            if (ser == null) {
                ser = new ObjectArraySerializer(type.getContentType(), staticTyping, elementTypeSerializer, elementValueSerializer);
            }
        }
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyArraySerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected JsonSerializer<?> buildIteratorSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        TypeSerializer vts = this.createTypeSerializer(config, valueType);
        return new IteratorSerializer(valueType, staticTyping, vts, null);
    }

    protected JsonSerializer<?> buildIterableSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        TypeSerializer vts = this.createTypeSerializer(config, valueType);
        return new IterableSerializer(valueType, staticTyping, vts, null);
    }

    protected JsonSerializer<?> buildEnumSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        JsonFormat.Value format2 = beanDesc.findExpectedFormat(null);
        if (format2 != null && format2.getShape() == JsonFormat.Shape.OBJECT) {
            ((BasicBeanDescription)beanDesc).removeProperty("declaringClass");
            return null;
        }
        Class<Enum<?>> enumClass = type.getRawClass();
        JsonSerializer ser = EnumSerializer.construct(enumClass, config, beanDesc, format2);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier mod : this._factoryConfig.serializerModifiers()) {
                ser = mod.modifyEnumSerializer(config, type, beanDesc, ser);
            }
        }
        return ser;
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(SerializationConfig config, Annotated a, T type) {
        Class<?> superclass = config.getAnnotationIntrospector().findSerializationType(a);
        if (superclass != null) {
            try {
                type = type.widenBy(superclass);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Failed to widen type " + type + " with concrete-type annotation (value " + superclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage());
            }
        }
        return BasicSerializerFactory.modifySecondaryTypesByAnnotation(config, a, type);
    }

    protected static <T extends JavaType> T modifySecondaryTypesByAnnotation(SerializationConfig config, Annotated a, T type) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        if (((JavaType)type).isContainerType()) {
            Class<?> cc;
            Class<?> keyClass = intr.findSerializationKeyType(a, ((JavaType)type).getKeyType());
            if (keyClass != null) {
                if (!(type instanceof MapType)) {
                    throw new IllegalArgumentException("Illegal key-type annotation: type " + type + " is not a Map type");
                }
                try {
                    type = ((MapType)type).widenKey(keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Failed to narrow key type " + type + " with key-type annotation (" + keyClass.getName() + "): " + iae.getMessage());
                }
            }
            if ((cc = intr.findSerializationContentType(a, ((JavaType)type).getContentType())) != null) {
                try {
                    type = ((JavaType)type).widenContentsBy(cc);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Failed to narrow content type " + type + " with content-type annotation (" + cc.getName() + "): " + iae.getMessage());
                }
            }
        }
        return (T)type;
    }

    protected JsonSerializer<Object> _findKeySerializer(SerializerProvider prov, Annotated a) throws JsonMappingException {
        AnnotationIntrospector intr = prov.getAnnotationIntrospector();
        Object serDef = intr.findKeySerializer(a);
        if (serDef != null) {
            return prov.serializerInstance(a, serDef);
        }
        return null;
    }

    protected JsonSerializer<Object> _findContentSerializer(SerializerProvider prov, Annotated a) throws JsonMappingException {
        AnnotationIntrospector intr = prov.getAnnotationIntrospector();
        Object serDef = intr.findContentSerializer(a);
        if (serDef != null) {
            return prov.serializerInstance(a, serDef);
        }
        return null;
    }

    protected Object findFilterId(SerializationConfig config, BeanDescription beanDesc) {
        return config.getAnnotationIntrospector().findFilterId((Annotated)beanDesc.getClassInfo());
    }

    protected boolean usesStaticTyping(SerializationConfig config, BeanDescription beanDesc, TypeSerializer typeSer) {
        if (typeSer != null) {
            return false;
        }
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        JsonSerialize.Typing t = intr.findSerializationTyping(beanDesc.getClassInfo());
        if (t != null && t != JsonSerialize.Typing.DEFAULT_TYPING) {
            return t == JsonSerialize.Typing.STATIC;
        }
        return config.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    protected Class<?> _verifyAsClass(Object src, String methodName, Class<?> noneClass) {
        if (src == null) {
            return null;
        }
        if (!(src instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + methodName + "() returned value of type " + src.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class cls = (Class)src;
        if (cls == noneClass || ClassUtil.isBogusClass(cls)) {
            return null;
        }
        return cls;
    }

    static {
        _concrete.put(String.class.getName(), new StringSerializer());
        ToStringSerializer sls = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), sls);
        _concrete.put(StringBuilder.class.getName(), sls);
        _concrete.put(Character.class.getName(), sls);
        _concrete.put(Character.TYPE.getName(), sls);
        NumberSerializers.addAll(_concrete);
        _concrete.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        _concrete.put(Boolean.class.getName(), new BooleanSerializer(false));
        NumberSerializer ns = NumberSerializer.instance;
        _concrete.put(BigInteger.class.getName(), ns);
        _concrete.put(BigDecimal.class.getName(), ns);
        _concrete.put(Calendar.class.getName(), CalendarSerializer.instance);
        DateSerializer dateSer = DateSerializer.instance;
        _concrete.put(Date.class.getName(), dateSer);
        _concrete.put(Timestamp.class.getName(), dateSer);
        _concreteLazy.put(java.sql.Date.class.getName(), SqlDateSerializer.class);
        _concreteLazy.put(Time.class.getName(), SqlTimeSerializer.class);
        for (Map.Entry<Class<?>, Object> en : StdJdkSerializers.all()) {
            Object value2 = en.getValue();
            if (value2 instanceof JsonSerializer) {
                _concrete.put(en.getKey().getName(), (JsonSerializer)value2);
                continue;
            }
            if (value2 instanceof Class) {
                Class cls = (Class)value2;
                _concreteLazy.put(en.getKey().getName(), cls);
                continue;
            }
            throw new IllegalStateException("Internal error: unrecognized value of type " + en.getClass().getName());
        }
        _concreteLazy.put(TokenBuffer.class.getName(), TokenBufferSerializer.class);
    }
}

