/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

@JacksonStdImpl
public final class NumberSerializer
extends StdScalarSerializer<Number> {
    public static final NumberSerializer instance = new NumberSerializer();

    public NumberSerializer() {
        super(Number.class);
    }

    @Override
    public void serialize(Number value2, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value2 instanceof BigDecimal) {
            jgen.writeNumber((BigDecimal)value2);
        } else if (value2 instanceof BigInteger) {
            jgen.writeNumber((BigInteger)value2);
        } else if (value2 instanceof Integer) {
            jgen.writeNumber(value2.intValue());
        } else if (value2 instanceof Long) {
            jgen.writeNumber(value2.longValue());
        } else if (value2 instanceof Double) {
            jgen.writeNumber(value2.doubleValue());
        } else if (value2 instanceof Float) {
            jgen.writeNumber(value2.floatValue());
        } else if (value2 instanceof Byte || value2 instanceof Short) {
            jgen.writeNumber(value2.intValue());
        } else {
            jgen.writeNumber(value2.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonNumberFormatVisitor v2 = visitor.expectNumberFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.BIG_DECIMAL);
        }
    }
}

