/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

public class OffsetSpec {
    public static OffsetSpec latest() {
        return new LatestSpec();
    }

    public static OffsetSpec earliest() {
        return new EarliestSpec();
    }

    public static OffsetSpec forTimestamp(long timestamp2) {
        return new TimestampSpec(timestamp2);
    }

    public static class TimestampSpec
    extends OffsetSpec {
        private final long timestamp;

        TimestampSpec(long timestamp2) {
            this.timestamp = timestamp2;
        }

        long timestamp() {
            return this.timestamp;
        }
    }

    public static class LatestSpec
    extends OffsetSpec {
    }

    public static class EarliestSpec
    extends OffsetSpec {
    }
}

