/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Objects;
import java.util.Optional;

public final class OffsetAndTimestamp {
    private final long timestamp;
    private final long offset;
    private final Optional<Integer> leaderEpoch;

    public OffsetAndTimestamp(long offset2, long timestamp2) {
        this(offset2, timestamp2, Optional.empty());
    }

    public OffsetAndTimestamp(long offset2, long timestamp2, Optional<Integer> leaderEpoch) {
        if (offset2 < 0L) {
            throw new IllegalArgumentException("Invalid negative offset");
        }
        if (timestamp2 < 0L) {
            throw new IllegalArgumentException("Invalid negative timestamp");
        }
        this.offset = offset2;
        this.timestamp = timestamp2;
        this.leaderEpoch = leaderEpoch;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long offset() {
        return this.offset;
    }

    public Optional<Integer> leaderEpoch() {
        return this.leaderEpoch;
    }

    public String toString() {
        return "(timestamp=" + this.timestamp + ", leaderEpoch=" + this.leaderEpoch.orElse(null) + ", offset=" + this.offset + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetAndTimestamp that = (OffsetAndTimestamp)o;
        return this.timestamp == that.timestamp && this.offset == that.offset && Objects.equals(this.leaderEpoch, that.leaderEpoch);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.offset, this.leaderEpoch);
    }
}

