/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListOffsetRequestData
implements ApiMessage {
    int replicaId;
    byte isolationLevel;
    List<ListOffsetTopic> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("topics", new ArrayOf(ListOffsetTopic.SCHEMA_0), "Each topic in the request."));
    public static final Schema SCHEMA_1 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("topics", new ArrayOf(ListOffsetTopic.SCHEMA_1), "Each topic in the request."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 5;

    public ListOffsetRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ListOffsetRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ListOffsetRequestData() {
        this.replicaId = 0;
        this.isolationLevel = 0;
        this.topics = new ArrayList<ListOffsetTopic>(0);
    }

    @Override
    public short apiKey() {
        return 2;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.replicaId = _readable.readInt();
        this.isolationLevel = _version >= 2 ? _readable.readByte() : (byte)0;
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<ListOffsetTopic> newCollection = new ArrayList<ListOffsetTopic>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ListOffsetTopic(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.replicaId);
        if (_version >= 2) {
            _writable.writeByte(this.isolationLevel);
        } else if (this.isolationLevel != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default isolationLevel at version " + _version);
        }
        _writable.writeInt(this.topics.size());
        for (ListOffsetTopic topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.replicaId = struct.getInt("replica_id");
        this.isolationLevel = _version >= 2 ? struct.getByte("isolation_level") : (byte)0;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<ListOffsetTopic>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new ListOffsetTopic((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("replica_id", (Object)this.replicaId);
        if (_version >= 2) {
            struct.set("isolation_level", (Object)this.isolationLevel);
        } else if (this.isolationLevel != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default isolationLevel at version " + _version);
        }
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (ListOffsetTopic element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        if (_version >= 2) {
            ++_size;
        }
        int _arraySize = 0;
        _arraySize += 4;
        for (ListOffsetTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListOffsetRequestData)) {
            return false;
        }
        ListOffsetRequestData other = (ListOffsetRequestData)obj;
        if (this.replicaId != other.replicaId) {
            return false;
        }
        if (this.isolationLevel != other.isolationLevel) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode2 = 0;
        hashCode2 = 31 * hashCode2 + this.replicaId;
        hashCode2 = 31 * hashCode2 + this.isolationLevel;
        hashCode2 = 31 * hashCode2 + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode2;
    }

    @Override
    public ListOffsetRequestData duplicate() {
        ListOffsetRequestData _duplicate = new ListOffsetRequestData();
        _duplicate.replicaId = this.replicaId;
        _duplicate.isolationLevel = this.isolationLevel;
        ArrayList<ListOffsetTopic> newTopics = new ArrayList<ListOffsetTopic>(this.topics.size());
        for (ListOffsetTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "ListOffsetRequestData(replicaId=" + this.replicaId + ", isolationLevel=" + this.isolationLevel + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int replicaId() {
        return this.replicaId;
    }

    public byte isolationLevel() {
        return this.isolationLevel;
    }

    public List<ListOffsetTopic> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListOffsetRequestData setReplicaId(int v) {
        this.replicaId = v;
        return this;
    }

    public ListOffsetRequestData setIsolationLevel(byte v) {
        this.isolationLevel = v;
        return this;
    }

    public ListOffsetRequestData setTopics(List<ListOffsetTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", new ArrayOf(ListOffsetTopic.SCHEMA_1), "Each topic in the request."));
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the requestor, or -1 if this request is being made by a normal consumer."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", new ArrayOf(ListOffsetTopic.SCHEMA_4), "Each topic in the request."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class ListOffsetPartition
    implements Message {
        int partitionIndex;
        int currentLeaderEpoch;
        long timestamp;
        int maxNumOffsets;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("timestamp", Type.INT64, "The current timestamp."), new Field("max_num_offsets", Type.INT32, "The maximum number of offsets to report."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public ListOffsetPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ListOffsetPartition(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ListOffsetPartition() {
            this.partitionIndex = 0;
            this.currentLeaderEpoch = -1;
            this.timestamp = 0L;
            this.maxNumOffsets = 1;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetPartition");
            }
            this.partitionIndex = _readable.readInt();
            this.currentLeaderEpoch = _version >= 4 ? _readable.readInt() : -1;
            this.timestamp = _readable.readLong();
            this.maxNumOffsets = _version <= 0 ? _readable.readInt() : 1;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (_version >= 4) {
                _writable.writeInt(this.currentLeaderEpoch);
            }
            _writable.writeLong(this.timestamp);
            if (_version <= 0) {
                _writable.writeInt(this.maxNumOffsets);
            } else if (this.maxNumOffsets != 1) {
                throw new UnsupportedVersionException("Attempted to write a non-default maxNumOffsets at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetPartition");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.currentLeaderEpoch = _version >= 4 ? struct.getInt("current_leader_epoch") : -1;
            this.timestamp = struct.getLong("timestamp");
            this.maxNumOffsets = _version <= 0 ? struct.getInt("max_num_offsets") : 1;
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ListOffsetPartition");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            if (_version >= 4) {
                struct.set("current_leader_epoch", (Object)this.currentLeaderEpoch);
            }
            struct.set("timestamp", (Object)this.timestamp);
            if (_version <= 0) {
                struct.set("max_num_offsets", (Object)this.maxNumOffsets);
            } else if (this.maxNumOffsets != 1) {
                throw new UnsupportedVersionException("Attempted to write a non-default maxNumOffsets at version " + _version);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ListOffsetPartition");
            }
            _size += 4;
            if (_version >= 4) {
                _size += 4;
            }
            _size += 8;
            if (_version <= 0) {
                _size += 4;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetPartition)) {
                return false;
            }
            ListOffsetPartition other = (ListOffsetPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            if (this.maxNumOffsets != other.maxNumOffsets) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode2 = 0;
            hashCode2 = 31 * hashCode2 + this.partitionIndex;
            hashCode2 = 31 * hashCode2 + this.currentLeaderEpoch;
            hashCode2 = 31 * hashCode2 + ((int)(this.timestamp >> 32) ^ (int)this.timestamp);
            hashCode2 = 31 * hashCode2 + this.maxNumOffsets;
            return hashCode2;
        }

        @Override
        public ListOffsetPartition duplicate() {
            ListOffsetPartition _duplicate = new ListOffsetPartition();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.currentLeaderEpoch = this.currentLeaderEpoch;
            _duplicate.timestamp = this.timestamp;
            _duplicate.maxNumOffsets = this.maxNumOffsets;
            return _duplicate;
        }

        public String toString() {
            return "ListOffsetPartition(partitionIndex=" + this.partitionIndex + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", timestamp=" + this.timestamp + ", maxNumOffsets=" + this.maxNumOffsets + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int currentLeaderEpoch() {
            return this.currentLeaderEpoch;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public int maxNumOffsets() {
            return this.maxNumOffsets;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ListOffsetPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public ListOffsetPartition setCurrentLeaderEpoch(int v) {
            this.currentLeaderEpoch = v;
            return this;
        }

        public ListOffsetPartition setTimestamp(long v) {
            this.timestamp = v;
            return this;
        }

        public ListOffsetPartition setMaxNumOffsets(int v) {
            this.maxNumOffsets = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("timestamp", Type.INT64, "The current timestamp.")));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("current_leader_epoch", Type.INT32, "The current leader epoch."), new Field("timestamp", Type.INT64, "The current timestamp."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class ListOffsetTopic
    implements Message {
        String name;
        List<ListOffsetPartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(ListOffsetPartition.SCHEMA_0), "Each partition in the request."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public ListOffsetTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ListOffsetTopic(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ListOffsetTopic() {
            this.name = "";
            this.partitions = new ArrayList<ListOffsetPartition>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<ListOffsetPartition> newCollection = new ArrayList<ListOffsetPartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ListOffsetPartition(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                ListOffsetPartition partitionsElement = (ListOffsetPartition)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetTopic");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<ListOffsetPartition>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new ListOffsetPartition((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ListOffsetTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (ListOffsetPartition element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ListOffsetTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (ListOffsetPartition partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetTopic)) {
                return false;
            }
            ListOffsetTopic other = (ListOffsetTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode2 = 0;
            hashCode2 = 31 * hashCode2 + (this.name == null ? 0 : this.name.hashCode());
            hashCode2 = 31 * hashCode2 + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode2;
        }

        @Override
        public ListOffsetTopic duplicate() {
            ListOffsetTopic _duplicate = new ListOffsetTopic();
            _duplicate.name = this.name;
            ArrayList<ListOffsetPartition> newPartitions = new ArrayList<ListOffsetPartition>(this.partitions.size());
            for (ListOffsetPartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "ListOffsetTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<ListOffsetPartition> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ListOffsetTopic setName(String v) {
            this.name = v;
            return this;
        }

        public ListOffsetTopic setPartitions(List<ListOffsetPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(ListOffsetPartition.SCHEMA_1), "Each partition in the request.")));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(ListOffsetPartition.SCHEMA_4), "Each partition in the request."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

