/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class RenewDelegationTokenRequestData
implements ApiMessage {
    byte[] hmac;
    long renewPeriodMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public RenewDelegationTokenRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public RenewDelegationTokenRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public RenewDelegationTokenRequestData() {
        this.hmac = Bytes.EMPTY;
        this.renewPeriodMs = 0L;
    }

    @Override
    public short apiKey() {
        return 39;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
        if (length < 0) {
            throw new RuntimeException("non-nullable field hmac was serialized as null");
        }
        byte[] newBytes = new byte[length];
        _readable.readArray(newBytes);
        this.hmac = newBytes;
        this.renewPeriodMs = _readable.readLong();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.hmac.length + 1);
        } else {
            _writable.writeInt(this.hmac.length);
        }
        _writable.writeByteArray(this.hmac);
        _writable.writeLong(this.renewPeriodMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.hmac = struct.getByteArray("hmac");
        this.renewPeriodMs = struct.getLong("renew_period_ms");
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry2 : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry2.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.setByteArray("hmac", this.hmac);
        struct.set("renew_period_ms", (Object)this.renewPeriodMs);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _bytesSize = this.hmac.length;
        _bytesSize = _version >= 2 ? (_bytesSize += ByteUtils.sizeOfUnsignedVarint(this.hmac.length + 1)) : (_bytesSize += 4);
        _size += _bytesSize;
        _size += 8;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RenewDelegationTokenRequestData)) {
            return false;
        }
        RenewDelegationTokenRequestData other = (RenewDelegationTokenRequestData)obj;
        if (!Arrays.equals(this.hmac, other.hmac)) {
            return false;
        }
        if (this.renewPeriodMs != other.renewPeriodMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode2 = 0;
        hashCode2 = 31 * hashCode2 + Arrays.hashCode(this.hmac);
        hashCode2 = 31 * hashCode2 + ((int)(this.renewPeriodMs >> 32) ^ (int)this.renewPeriodMs);
        return hashCode2;
    }

    @Override
    public RenewDelegationTokenRequestData duplicate() {
        RenewDelegationTokenRequestData _duplicate = new RenewDelegationTokenRequestData();
        _duplicate.hmac = MessageUtil.duplicate(this.hmac);
        _duplicate.renewPeriodMs = this.renewPeriodMs;
        return _duplicate;
    }

    public String toString() {
        return "RenewDelegationTokenRequestData(hmac=" + Arrays.toString(this.hmac) + ", renewPeriodMs=" + this.renewPeriodMs + ")";
    }

    public byte[] hmac() {
        return this.hmac;
    }

    public long renewPeriodMs() {
        return this.renewPeriodMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RenewDelegationTokenRequestData setHmac(byte[] v) {
        this.hmac = v;
        return this;
    }

    public RenewDelegationTokenRequestData setRenewPeriodMs(long v) {
        this.renewPeriodMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("hmac", Type.BYTES, "The HMAC of the delegation token to be renewed."), new Field("renew_period_ms", Type.INT64, "The renewal time period in milliseconds."));
        SCHEMA_2 = new Schema(new Field("hmac", Type.COMPACT_BYTES, "The HMAC of the delegation token to be renewed."), new Field("renew_period_ms", Type.INT64, "The renewal time period in milliseconds."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

