/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.stats.Histogram;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Percentiles
extends SampledStat
implements CompoundStat {
    private final Logger log = LoggerFactory.getLogger(Percentiles.class);
    private final int buckets;
    private final Percentile[] percentiles;
    private final Histogram.BinScheme binScheme;
    private final double min;
    private final double max;

    public Percentiles(int sizeInBytes2, double max2, BucketSizing bucketing, Percentile ... percentiles) {
        this(sizeInBytes2, 0.0, max2, bucketing, percentiles);
    }

    public Percentiles(int sizeInBytes2, double min2, double max2, BucketSizing bucketing, Percentile ... percentiles) {
        super(0.0);
        this.percentiles = percentiles;
        this.buckets = sizeInBytes2 / 4;
        this.min = min2;
        this.max = max2;
        if (bucketing == BucketSizing.CONSTANT) {
            this.binScheme = new Histogram.ConstantBinScheme(this.buckets, min2, max2);
        } else if (bucketing == BucketSizing.LINEAR) {
            if (min2 != 0.0) {
                throw new IllegalArgumentException("Linear bucket sizing requires min to be 0.0.");
            }
            this.binScheme = new Histogram.LinearBinScheme(this.buckets, max2);
        } else {
            throw new IllegalArgumentException("Unknown bucket type: " + (Object)((Object)bucketing));
        }
    }

    @Override
    public List<CompoundStat.NamedMeasurable> stats() {
        ArrayList<CompoundStat.NamedMeasurable> ms = new ArrayList<CompoundStat.NamedMeasurable>(this.percentiles.length);
        for (Percentile percentile : this.percentiles) {
            double pct = percentile.percentile();
            ms.add(new CompoundStat.NamedMeasurable(percentile.name(), (config, now) -> this.value(config, now, pct / 100.0)));
        }
        return ms;
    }

    public double value(MetricConfig config, long now, double quantile) {
        this.purgeObsoleteSamples(config, now);
        float count2 = 0.0f;
        for (SampledStat.Sample sample : this.samples) {
            count2 += (float)sample.eventCount;
        }
        if (count2 == 0.0f) {
            return Double.NaN;
        }
        float sum2 = 0.0f;
        float quant = (float)quantile;
        for (int b = 0; b < this.buckets; ++b) {
            for (SampledStat.Sample s2 : this.samples) {
                HistogramSample sample = (HistogramSample)s2;
                float[] hist = sample.histogram.counts();
                if (!((sum2 += hist[b]) / count2 > quant)) continue;
                return this.binScheme.fromBin(b);
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double combine(List<SampledStat.Sample> samples, MetricConfig config, long now) {
        return this.value(config, now, 0.5);
    }

    @Override
    protected HistogramSample newSample(long timeMs) {
        return new HistogramSample(this.binScheme, timeMs);
    }

    @Override
    protected void update(SampledStat.Sample sample, MetricConfig config, double value2, long timeMs) {
        double boundedValue;
        if (value2 > this.max) {
            this.log.warn("Received value {} which is greater than max recordable value {}, will be pinned to the max value", (Object)value2, (Object)this.max);
            boundedValue = this.max;
        } else if (value2 < this.min) {
            this.log.warn("Received value {} which is less than min recordable value {}, will be pinned to the min value", (Object)value2, (Object)this.min);
            boundedValue = this.min;
        } else {
            boundedValue = value2;
        }
        HistogramSample hist = (HistogramSample)sample;
        hist.histogram.record(boundedValue);
    }

    private static class HistogramSample
    extends SampledStat.Sample {
        private final Histogram histogram;

        private HistogramSample(Histogram.BinScheme scheme, long now) {
            super(0.0, now);
            this.histogram = new Histogram(scheme);
        }

        @Override
        public void reset(long now) {
            super.reset(now);
            this.histogram.clear();
        }
    }

    public static enum BucketSizing {
        CONSTANT,
        LINEAR;

    }
}

