/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class CompactArrayOf
extends Type.DocumentedType {
    private static final String COMPACT_ARRAY_TYPE_NAME = "COMPACT_ARRAY";
    private final Type type;
    private final boolean nullable;

    public CompactArrayOf(Type type) {
        this(type, false);
    }

    public static CompactArrayOf nullable(Type type) {
        return new CompactArrayOf(type, true);
    }

    private CompactArrayOf(Type type, boolean nullable) {
        this.type = type;
        this.nullable = nullable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public void write(ByteBuffer buffer, Object o) {
        if (o == null) {
            ByteUtils.writeUnsignedVarint(0, buffer);
            return;
        }
        Object[] objs = (Object[])o;
        int size2 = objs.length;
        ByteUtils.writeUnsignedVarint(size2 + 1, buffer);
        for (Object obj : objs) {
            this.type.write(buffer, obj);
        }
    }

    @Override
    public Object read(ByteBuffer buffer) {
        int n = ByteUtils.readUnsignedVarint(buffer);
        if (n == 0) {
            if (this.isNullable()) {
                return null;
            }
            throw new SchemaException("This array is not nullable.");
        }
        int size2 = n - 1;
        if (size2 > buffer.remaining()) {
            throw new SchemaException("Error reading array of size " + size2 + ", only " + buffer.remaining() + " bytes available");
        }
        Object[] objs = new Object[size2];
        for (int i = 0; i < size2; ++i) {
            objs[i] = this.type.read(buffer);
        }
        return objs;
    }

    @Override
    public int sizeOf(Object o) {
        if (o == null) {
            return 1;
        }
        Object[] objs = (Object[])o;
        int size2 = ByteUtils.sizeOfUnsignedVarint(objs.length + 1);
        for (Object obj : objs) {
            size2 += this.type.sizeOf(obj);
        }
        return size2;
    }

    @Override
    public Optional<Type> arrayElementType() {
        return Optional.of(this.type);
    }

    @Override
    public String toString() {
        return "COMPACT_ARRAY(" + this.type + ")";
    }

    public Object[] validate(Object item) {
        try {
            Object[] array;
            if (this.isNullable() && item == null) {
                return null;
            }
            for (Object obj : array = (Object[])item) {
                this.type.validate(obj);
            }
            return array;
        }
        catch (ClassCastException e) {
            throw new SchemaException("Not an Object[].");
        }
    }

    @Override
    public String typeName() {
        return COMPACT_ARRAY_TYPE_NAME;
    }

    @Override
    public String documentation() {
        return "Represents a sequence of objects of a given type T. Type T can be either a primitive type (e.g. " + STRING + ") or a structure. First, the length N + 1 is given as an UNSIGNED_VARINT. Then N instances of type T follow. A null array is represented with a length of 0. In protocol documentation an array of T instances is referred to as [T].";
    }
}

