/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.DefaultRecordsSend;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.RecordsSend;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Utils;

public abstract class AbstractRecords
implements Records {
    private final Iterable<Record> records = this::recordsIterator;

    @Override
    public boolean hasMatchingMagic(byte magic) {
        for (RecordBatch recordBatch : this.batches()) {
            if (recordBatch.magic() == magic) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasCompatibleMagic(byte magic) {
        for (RecordBatch recordBatch : this.batches()) {
            if (recordBatch.magic() <= magic) continue;
            return false;
        }
        return true;
    }

    public RecordBatch firstBatch() {
        Iterator<? extends RecordBatch> iterator2 = this.batches().iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        return iterator2.next();
    }

    @Override
    public Iterable<Record> records() {
        return this.records;
    }

    @Override
    public RecordsSend toSend(String destination) {
        return new DefaultRecordsSend(destination, this);
    }

    private Iterator<Record> recordsIterator() {
        return new AbstractIterator<Record>(){
            private final Iterator<? extends RecordBatch> batches;
            private Iterator<Record> records;
            {
                this.batches = AbstractRecords.this.batches().iterator();
            }

            @Override
            protected Record makeNext() {
                if (this.records != null && this.records.hasNext()) {
                    return this.records.next();
                }
                if (this.batches.hasNext()) {
                    this.records = this.batches.next().iterator();
                    return this.makeNext();
                }
                return (Record)this.allDone();
            }
        };
    }

    public static int estimateSizeInBytes(byte magic, long baseOffset, CompressionType compressionType, Iterable<Record> records) {
        int size2 = 0;
        if (magic <= 1) {
            for (Record record2 : records) {
                size2 += 12 + LegacyRecord.recordSize(magic, record2.key(), record2.value());
            }
        } else {
            size2 = DefaultRecordBatch.sizeInBytes(baseOffset, records);
        }
        return AbstractRecords.estimateCompressedSizeInBytes(size2, compressionType);
    }

    public static int estimateSizeInBytes(byte magic, CompressionType compressionType, Iterable<SimpleRecord> records) {
        int size2 = 0;
        if (magic <= 1) {
            for (SimpleRecord record2 : records) {
                size2 += 12 + LegacyRecord.recordSize(magic, record2.key(), record2.value());
            }
        } else {
            size2 = DefaultRecordBatch.sizeInBytes(records);
        }
        return AbstractRecords.estimateCompressedSizeInBytes(size2, compressionType);
    }

    private static int estimateCompressedSizeInBytes(int size2, CompressionType compressionType) {
        return compressionType == CompressionType.NONE ? size2 : Math.min(Math.max(size2 / 2, 1024), 65536);
    }

    public static int estimateSizeInBytesUpperBound(byte magic, CompressionType compressionType, byte[] key, byte[] value2, Header[] headers) {
        return AbstractRecords.estimateSizeInBytesUpperBound(magic, compressionType, Utils.wrapNullable(key), Utils.wrapNullable(value2), headers);
    }

    public static int estimateSizeInBytesUpperBound(byte magic, CompressionType compressionType, ByteBuffer key, ByteBuffer value2, Header[] headers) {
        if (magic >= 2) {
            return DefaultRecordBatch.estimateBatchSizeUpperBound(key, value2, headers);
        }
        if (compressionType != CompressionType.NONE) {
            return 12 + LegacyRecord.recordOverhead(magic) + LegacyRecord.recordSize(magic, key, value2);
        }
        return 12 + LegacyRecord.recordSize(magic, key, value2);
    }

    public static int recordBatchHeaderSizeInBytes(byte magic, CompressionType compressionType) {
        if (magic > 1) {
            return 61;
        }
        if (compressionType != CompressionType.NONE) {
            return 12 + LegacyRecord.recordOverhead(magic);
        }
        return 0;
    }
}

