/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.record.LazyDownConversionRecordsSend;
import org.apache.kafka.common.record.RecordConversionStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRecordsSend
implements Send {
    private static final Logger log = LoggerFactory.getLogger(MultiRecordsSend.class);
    private final String dest;
    private final Queue<Send> sendQueue;
    private final long size;
    private Map<TopicPartition, RecordConversionStats> recordConversionStats;
    private long totalWritten = 0L;
    private Send current;

    public MultiRecordsSend(String dest, Queue<Send> sends) {
        this.dest = dest;
        this.sendQueue = sends;
        long size2 = 0L;
        for (Send send2 : sends) {
            size2 += send2.size();
        }
        this.size = size2;
        this.current = this.sendQueue.poll();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public String destination() {
        return this.dest;
    }

    @Override
    public boolean completed() {
        return this.current == null;
    }

    int numResidentSends() {
        int count2 = 0;
        if (this.current != null) {
            ++count2;
        }
        return count2 += this.sendQueue.size();
    }

    @Override
    public long writeTo(GatheringByteChannel channel) throws IOException {
        boolean sendComplete;
        if (this.completed()) {
            throw new KafkaException("This operation cannot be invoked on a complete request.");
        }
        int totalWrittenPerCall = 0;
        do {
            long written = this.current.writeTo(channel);
            totalWrittenPerCall = (int)((long)totalWrittenPerCall + written);
            sendComplete = this.current.completed();
            if (!sendComplete) continue;
            this.updateRecordConversionStats(this.current);
            this.current = this.sendQueue.poll();
        } while (!this.completed() && sendComplete);
        this.totalWritten += (long)totalWrittenPerCall;
        if (this.completed() && this.totalWritten != this.size) {
            log.error("mismatch in sending bytes over socket; expected: {} actual: {}", (Object)this.size, (Object)this.totalWritten);
        }
        log.trace("Bytes written as part of multi-send call: {}, total bytes written so far: {}, expected bytes to write: {}", totalWrittenPerCall, this.totalWritten, this.size);
        return totalWrittenPerCall;
    }

    public Map<TopicPartition, RecordConversionStats> recordConversionStats() {
        return this.recordConversionStats;
    }

    public String toString() {
        return "MultiRecordsSend(dest='" + this.dest + "', size=" + this.size + ", totalWritten=" + this.totalWritten + ')';
    }

    private void updateRecordConversionStats(Send completedSend) {
        if (completedSend instanceof LazyDownConversionRecordsSend) {
            if (this.recordConversionStats == null) {
                this.recordConversionStats = new HashMap<TopicPartition, RecordConversionStats>();
            }
            LazyDownConversionRecordsSend lazyRecordsSend = (LazyDownConversionRecordsSend)completedSend;
            this.recordConversionStats.put(lazyRecordsSend.topicPartition(), lazyRecordsSend.recordConversionStats());
        }
    }
}

