/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;

public class AlterReplicaLogDirsRequest
extends AbstractRequest {
    private final AlterReplicaLogDirsRequestData data;

    public AlterReplicaLogDirsRequest(Struct struct, short version) {
        super(ApiKeys.ALTER_REPLICA_LOG_DIRS, version);
        this.data = new AlterReplicaLogDirsRequestData(struct, version);
    }

    public AlterReplicaLogDirsRequest(AlterReplicaLogDirsRequestData data, short version) {
        super(ApiKeys.ALTER_REPLICA_LOG_DIRS, version);
        this.data = data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public AlterReplicaLogDirsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        AlterReplicaLogDirsResponseData data = new AlterReplicaLogDirsResponseData();
        data.setResults(this.data.dirs().stream().flatMap(alterDir -> alterDir.topics().stream().map(topic -> new AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult().setTopicName(topic.name()).setPartitions(topic.partitions().stream().map(partitionId -> new AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult().setErrorCode(Errors.forException(e).code()).setPartitionIndex((int)partitionId)).collect(Collectors.toList())))).collect(Collectors.toList()));
        return new AlterReplicaLogDirsResponse(data.setThrottleTimeMs(throttleTimeMs));
    }

    public Map<TopicPartition, String> partitionDirs() {
        HashMap<TopicPartition, String> result2 = new HashMap<TopicPartition, String>();
        this.data.dirs().forEach(alterDir -> alterDir.topics().forEach(topic -> topic.partitions().forEach(partition2 -> result2.put(new TopicPartition(topic.name(), (int)partition2), alterDir.path()))));
        return result2;
    }

    public static AlterReplicaLogDirsRequest parse(ByteBuffer buffer, short version) {
        return new AlterReplicaLogDirsRequest(ApiKeys.ALTER_REPLICA_LOG_DIRS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterReplicaLogDirsRequest> {
        private final AlterReplicaLogDirsRequestData data;

        public Builder(AlterReplicaLogDirsRequestData data) {
            super(ApiKeys.ALTER_REPLICA_LOG_DIRS);
            this.data = data;
        }

        @Override
        public AlterReplicaLogDirsRequest build(short version) {
            return new AlterReplicaLogDirsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

