/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class DescribeClientQuotasResponse
extends AbstractResponse {
    private final DescribeClientQuotasResponseData data;

    public DescribeClientQuotasResponse(Map<ClientQuotaEntity, Map<String, Double>> entities, int throttleTimeMs) {
        ArrayList<DescribeClientQuotasResponseData.EntryData> entries = new ArrayList<DescribeClientQuotasResponseData.EntryData>(entities.size());
        for (Map.Entry<ClientQuotaEntity, Map<String, Double>> entry2 : entities.entrySet()) {
            ClientQuotaEntity quotaEntity = entry2.getKey();
            ArrayList<DescribeClientQuotasResponseData.EntityData> entityData = new ArrayList<DescribeClientQuotasResponseData.EntityData>(quotaEntity.entries().size());
            for (Map.Entry<String, String> entityEntry : quotaEntity.entries().entrySet()) {
                entityData.add(new DescribeClientQuotasResponseData.EntityData().setEntityType(entityEntry.getKey()).setEntityName(entityEntry.getValue()));
            }
            Map<String, Double> quotaValues = entry2.getValue();
            ArrayList<DescribeClientQuotasResponseData.ValueData> valueData = new ArrayList<DescribeClientQuotasResponseData.ValueData>(quotaValues.size());
            for (Map.Entry<String, Double> valuesEntry : entry2.getValue().entrySet()) {
                valueData.add(new DescribeClientQuotasResponseData.ValueData().setKey(valuesEntry.getKey()).setValue(valuesEntry.getValue()));
            }
            entries.add(new DescribeClientQuotasResponseData.EntryData().setEntity(entityData).setValues(valueData));
        }
        this.data = new DescribeClientQuotasResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode((short)0).setErrorMessage(null).setEntries(entries);
    }

    public DescribeClientQuotasResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        this.data = new DescribeClientQuotasResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setEntries(null);
    }

    public DescribeClientQuotasResponse(Struct struct, short version) {
        this.data = new DescribeClientQuotasResponseData(struct, version);
    }

    public void complete(KafkaFutureImpl<Map<ClientQuotaEntity, Map<String, Double>>> future) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            future.completeExceptionally(error.exception(this.data.errorMessage()));
            return;
        }
        HashMap result2 = new HashMap(this.data.entries().size());
        for (DescribeClientQuotasResponseData.EntryData entries : this.data.entries()) {
            HashMap<String, String> entity = new HashMap<String, String>(entries.entity().size());
            for (DescribeClientQuotasResponseData.EntityData entityData : entries.entity()) {
                entity.put(entityData.entityType(), entityData.entityName());
            }
            HashMap<String, Double> values = new HashMap<String, Double>(entries.values().size());
            for (DescribeClientQuotasResponseData.ValueData valueData : entries.values()) {
                values.put(valueData.key(), valueData.value());
            }
            result2.put(new ClientQuotaEntity(entity), values);
        }
        future.complete(result2);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public static DescribeClientQuotasResponse parse(ByteBuffer buffer, short version) {
        return new DescribeClientQuotasResponse(ApiKeys.DESCRIBE_CLIENT_QUOTAS.parseResponse(version, buffer), version);
    }
}

