/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.RangerRESTUtils;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;

public class RangerAdminRESTClient
implements RangerAdminClient {
    private static final Log LOG = LogFactory.getLog(RangerAdminRESTClient.class);
    private String serviceName;
    private String pluginId;
    private String clusterName;
    private RangerRESTClient restClient;
    private RangerRESTUtils restUtils = new RangerRESTUtils();

    public static <T> GenericType<List<T>> getGenericType(final T clazz) {
        ParameterizedType parameterizedGenericType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{clazz.getClass()};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return List.class;
            }
        };
        return new GenericType<List<T>>(parameterizedGenericType){};
    }

    @Override
    public void init(String serviceName, String appId, String propertyPrefix) {
        this.serviceName = serviceName;
        this.pluginId = this.restUtils.getPluginId(serviceName, appId);
        String url = "";
        String tmpUrl = RangerConfiguration.getInstance().get(propertyPrefix + ".policy.rest.url");
        String sslConfigFileName = RangerConfiguration.getInstance().get(propertyPrefix + ".policy.rest.ssl.config.file");
        this.clusterName = RangerConfiguration.getInstance().get(propertyPrefix + ".ambari.cluster.name", "");
        int restClientConnTimeOutMs = RangerConfiguration.getInstance().getInt(propertyPrefix + ".policy.rest.client.connection.timeoutMs", 120000);
        int restClientReadTimeOutMs = RangerConfiguration.getInstance().getInt(propertyPrefix + ".policy.rest.client.read.timeoutMs", 30000);
        if (!StringUtil.isEmpty(tmpUrl)) {
            url = tmpUrl.trim();
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.init(url, sslConfigFileName, restClientConnTimeOutMs, restClientReadTimeOutMs);
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(final long lastKnownVersion, final long lastActivationTimeInMillis) throws Exception {
        RESTResponse resp;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")");
        }
        ServicePolicies ret = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        ClientResponse response = null;
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service policy if updated as user : " + user);
            }
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/plugins/secure/policies/download/" + RangerAdminRESTClient.this.serviceName).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("lastActivationTime", Long.toString(lastActivationTimeInMillis)).queryParam("pluginId", RangerAdminRESTClient.this.pluginId).queryParam("clusterName", RangerAdminRESTClient.this.clusterName);
                    return secureWebResource.accept("application/json").get(ClientResponse.class);
                }
            };
            response = user.doAs(action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking Service policy if updated with old api call");
            }
            WebResource webResource = this.createWebResource("/service/plugins/policies/download/" + this.serviceName).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("lastActivationTime", Long.toString(lastActivationTimeInMillis)).queryParam("pluginId", this.pluginId).queryParam("clusterName", this.clusterName);
            response = webResource.accept("application/json").get(ClientResponse.class);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error("Error getting policies; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = response.getEntity(ServicePolicies.class);
        } else if (response.getStatus() == 404) {
            LOG.error("Error getting policies; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret);
        }
        return ret;
    }

    @Override
    public void grantAccess(final GrantRevokeRequest request) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.grantAccess(" + request + ")");
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/plugins/secure/services/grant/" + RangerAdminRESTClient.this.serviceName).queryParam("pluginId", RangerAdminRESTClient.this.pluginId);
                    return ((WebResource.Builder)secureWebResource.accept("application/json").type("application/json")).post(ClientResponse.class, (Object)RangerAdminRESTClient.this.restClient.toJson(request));
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("grantAccess as user " + user);
            }
            response = user.doAs(action);
        } else {
            WebResource webResource = this.createWebResource("/service/plugins/services/grant/" + this.serviceName).queryParam("pluginId", this.pluginId);
            response = ((WebResource.Builder)webResource.accept("application/json").type("application/json")).post(ClientResponse.class, (Object)this.restClient.toJson(request));
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("grantAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during grantAccess. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.grantAccess(" + request + ")");
        }
    }

    @Override
    public void revokeAccess(final GrantRevokeRequest request) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.revokeAccess(" + request + ")");
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/plugins/secure/services/revoke/" + RangerAdminRESTClient.this.serviceName).queryParam("pluginId", RangerAdminRESTClient.this.pluginId);
                    return ((WebResource.Builder)secureWebResource.accept("application/json").type("application/json")).post(ClientResponse.class, (Object)RangerAdminRESTClient.this.restClient.toJson(request));
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("revokeAccess as user " + user);
            }
            response = user.doAs(action);
        } else {
            WebResource webResource = this.createWebResource("/service/plugins/services/revoke/" + this.serviceName).queryParam("pluginId", this.pluginId);
            response = ((WebResource.Builder)webResource.accept("application/json").type("application/json")).post(ClientResponse.class, (Object)this.restClient.toJson(request));
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("revokeAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error. revokeAccess(). serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.revokeAccess(" + request + ")");
        }
    }

    private void init(String url, String sslConfigFileName, int restClientConnTimeOutMs, int restClientReadTimeOutMs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")");
        }
        this.restClient = new RangerRESTClient(url, sslConfigFileName);
        this.restClient.setRestClientConnTimeOutMs(restClientConnTimeOutMs);
        this.restClient.setRestClientReadTimeOutMs(restClientReadTimeOutMs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")");
        }
    }

    private WebResource createWebResource(String url) {
        WebResource ret = this.restClient.getResource(url);
        return ret;
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(final long lastKnownVersion, final long lastActivationTimeInMillis) throws Exception {
        RESTResponse resp;
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        ServiceTags ret = null;
        ClientResponse response = null;
        WebResource webResource = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/tags/secure/download/" + RangerAdminRESTClient.this.serviceName).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("lastActivationTime", Long.toString(lastActivationTimeInMillis)).queryParam("pluginId", RangerAdminRESTClient.this.pluginId);
                    return secureWebResource.accept("application/json").get(ClientResponse.class);
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("getServiceTagsIfUpdated as user " + user);
            }
            response = user.doAs(action);
        } else {
            webResource = this.createWebResource("/service/tags/download/" + this.serviceName).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("lastActivationTime", Long.toString(lastActivationTimeInMillis)).queryParam("pluginId", this.pluginId);
            response = webResource.accept("application/json").get(ClientResponse.class);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error("Error getting tags; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName);
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = response.getEntity(ServiceTags.class);
        } else if (response.getStatus() == 404) {
            LOG.error("Error getting tags; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName);
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        return ret;
    }

    @Override
    public List<String> getTagTypes(String pattern) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.getTagTypes(" + pattern + "): ");
        }
        List<String> ret = null;
        String emptyString = "";
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final WebResource webResource = this.createWebResource("/service/tags/lookup").queryParam("serviceName", this.serviceName).queryParam("pattern", pattern);
        ClientResponse response = null;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    return webResource.accept("application/json").get(ClientResponse.class);
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("getTagTypes as user " + user);
            }
            response = user.doAs(action);
        } else {
            response = webResource.accept("application/json").get(ClientResponse.class);
        }
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("Error getting tags. request=" + webResource + ", response=" + resp + ", serviceName=" + this.serviceName + ", pattern=" + pattern);
            throw new Exception(resp.getMessage());
        }
        ret = response.getEntity(RangerAdminRESTClient.getGenericType(emptyString));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.getTagTypes(" + pattern + "): " + ret);
        }
        return ret;
    }
}

