/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.dao.DaoManager;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.entity.AuthzAuditEventDbObj;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.utils.RangerCredentialProvider;

public class DbAuditProvider
extends AuditDestination {
    private static final Log LOG = LogFactory.getLog(DbAuditProvider.class);
    public static final String AUDIT_DB_IS_ASYNC_PROP = "xasecure.audit.db.is.async";
    public static final String AUDIT_DB_MAX_QUEUE_SIZE_PROP = "xasecure.audit.db.async.max.queue.size";
    public static final String AUDIT_DB_MAX_FLUSH_INTERVAL_PROP = "xasecure.audit.db.async.max.flush.interval.ms";
    private static final String AUDIT_DB_BATCH_SIZE_PROP = "xasecure.audit.db.batch.size";
    private static final String AUDIT_DB_RETRY_MIN_INTERVAL_PROP = "xasecure.audit.db.config.retry.min.interval.ms";
    private static final String AUDIT_JPA_CONFIG_PROP_PREFIX = "xasecure.audit.jpa.";
    private static final String AUDIT_DB_CREDENTIAL_PROVIDER_FILE = "xasecure.audit.credential.provider.file";
    private static final String AUDIT_DB_CREDENTIAL_PROVIDER_ALIAS = "auditDBCred";
    private static final String AUDIT_JPA_JDBC_PASSWORD = "javax.persistence.jdbc.password";
    private EntityManagerFactory entityManagerFactory;
    private DaoManager daoManager;
    private int mCommitBatchSize = 1;
    private int mDbRetryMinIntervalMs = 60000;
    private ArrayList<AuditEventBase> mUncommitted = new ArrayList();
    private Map<String, String> mDbProperties = null;
    private long mLastDbFailedTime = 0L;

    public DbAuditProvider() {
        LOG.info("DbAuditProvider: creating..");
    }

    @Override
    public void init(Properties props) {
        String jdbcPassword;
        LOG.info("DbAuditProvider.init()");
        super.init(props);
        this.mDbProperties = MiscUtil.getPropertiesWithPrefix(props, AUDIT_JPA_CONFIG_PROP_PREFIX);
        this.mCommitBatchSize = MiscUtil.getIntProperty(props, AUDIT_DB_BATCH_SIZE_PROP, 1000);
        this.mDbRetryMinIntervalMs = MiscUtil.getIntProperty(props, AUDIT_DB_RETRY_MIN_INTERVAL_PROP, 15000);
        boolean isAsync = MiscUtil.getBooleanProperty(props, AUDIT_DB_IS_ASYNC_PROP, false);
        if (!isAsync) {
            this.mCommitBatchSize = 1;
        }
        if ((jdbcPassword = this.getCredentialString(MiscUtil.getStringProperty(props, AUDIT_DB_CREDENTIAL_PROVIDER_FILE), AUDIT_DB_CREDENTIAL_PROVIDER_ALIAS)) != null && !jdbcPassword.isEmpty()) {
            this.mDbProperties.put(AUDIT_JPA_JDBC_PASSWORD, jdbcPassword);
        }
        AuthzAuditEventDbObj.init(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean log(AuditEventBase event) {
        LOG.debug("DbAuditProvider.log()");
        boolean isSuccess = false;
        try {
            DaoManager daoMgr;
            if (this.preCreate() && (daoMgr = this.daoManager) != null) {
                event.persist(daoMgr);
                isSuccess = this.postCreate(event);
            }
        }
        catch (Exception excp) {
            this.logDbError("DbAuditProvider.log(): failed", excp);
        }
        finally {
            if (!isSuccess) {
                this.logFailedEvent(event);
            }
        }
        LOG.debug("<== DbAuditProvider.log()");
        return isSuccess;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events2) {
        AuditEventBase event;
        boolean ret = true;
        Iterator<AuditEventBase> iterator2 = events2.iterator();
        while (iterator2.hasNext() && (ret = this.log(event = iterator2.next()))) {
        }
        return ret;
    }

    @Override
    public boolean logJSON(String event) {
        AuditEventBase eventObj = MiscUtil.fromJson(event, AuthzAuditEvent.class);
        return this.log(eventObj);
    }

    @Override
    public boolean logJSON(Collection<String> events2) {
        String event;
        boolean ret = true;
        Iterator<String> iterator2 = events2.iterator();
        while (iterator2.hasNext() && (ret = this.logJSON(event = iterator2.next()))) {
        }
        return ret;
    }

    @Override
    public void start() {
        LOG.info("DbAuditProvider.start()");
        this.init();
    }

    @Override
    public void stop() {
        LOG.info("DbAuditProvider.stop()");
        this.cleanUp();
    }

    @Override
    public void flush() {
        if (this.mUncommitted.size() > 0) {
            boolean isSuccess = this.commitTransaction();
            if (!isSuccess) {
                for (AuditEventBase evt : this.mUncommitted) {
                    this.logFailedEvent(evt);
                }
            }
            this.mUncommitted.clear();
        }
    }

    private synchronized boolean init() {
        long now = System.currentTimeMillis();
        if (now - this.mLastDbFailedTime < (long)this.mDbRetryMinIntervalMs) {
            return false;
        }
        LOG.info("DbAuditProvider: init()");
        LOG.info("java.library.path:" + System.getProperty("java.library.path"));
        try {
            this.entityManagerFactory = Persistence.createEntityManagerFactory("xa_server", this.mDbProperties);
            this.daoManager = new DaoManager();
            this.daoManager.setEntityManagerFactory(this.entityManagerFactory);
            this.daoManager.getEntityManager();
        }
        catch (Exception excp) {
            this.logDbError("DbAuditProvider: DB initalization failed", excp);
            this.cleanUp();
            return false;
        }
        return true;
    }

    private synchronized void cleanUp() {
        LOG.info("DbAuditProvider: cleanUp()");
        try {
            if (this.entityManagerFactory != null && this.entityManagerFactory.isOpen()) {
                this.entityManagerFactory.close();
            }
        }
        catch (Exception excp) {
            LOG.error("DbAuditProvider.cleanUp(): failed", excp);
        }
        finally {
            this.entityManagerFactory = null;
            this.daoManager = null;
        }
    }

    private boolean isDbConnected() {
        EntityManager em = this.getEntityManager();
        return em != null && em.isOpen();
    }

    private EntityManager getEntityManager() {
        DaoManager daoMgr = this.daoManager;
        if (daoMgr != null) {
            try {
                return daoMgr.getEntityManager();
            }
            catch (Exception excp) {
                this.logDbError("DbAuditProvider.getEntityManager(): failed", excp);
                this.cleanUp();
            }
        }
        return null;
    }

    private void clearEntityManager() {
        try {
            EntityManager em = this.getEntityManager();
            if (em != null) {
                em.clear();
            }
        }
        catch (Exception excp) {
            LOG.warn("DbAuditProvider.clearEntityManager(): failed", excp);
        }
    }

    private EntityTransaction getTransaction() {
        EntityManager em = this.getEntityManager();
        return em != null ? em.getTransaction() : null;
    }

    private boolean isInTransaction() {
        EntityTransaction trx = this.getTransaction();
        return trx != null && trx.isActive();
    }

    private boolean beginTransaction() {
        EntityTransaction trx = this.getTransaction();
        if (trx != null && !trx.isActive()) {
            trx.begin();
        }
        if (trx == null) {
            LOG.warn("DbAuditProvider.beginTransaction(): trx is null");
        }
        return trx != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitTransaction() {
        boolean ret;
        block6: {
            ret = false;
            EntityTransaction trx = null;
            try {
                trx = this.getTransaction();
                if (trx != null && trx.isActive()) {
                    trx.commit();
                    ret = true;
                    break block6;
                }
                throw new Exception("trx is null or not active");
            }
            catch (Exception excp) {
                this.logDbError("DbAuditProvider.commitTransaction(): failed", excp);
                this.cleanUp();
            }
            finally {
                this.clearEntityManager();
            }
        }
        return ret;
    }

    private boolean preCreate() {
        boolean ret = true;
        if (!this.isDbConnected()) {
            ret = this.init();
        }
        if (ret && !this.isInTransaction()) {
            ret = this.beginTransaction();
        }
        return ret;
    }

    private boolean postCreate(AuditEventBase event) {
        boolean ret = true;
        if (this.mCommitBatchSize <= 1) {
            ret = this.commitTransaction();
        } else {
            this.mUncommitted.add(event);
            if (this.mUncommitted.size() % this.mCommitBatchSize == 0) {
                ret = this.commitTransaction();
                if (!ret) {
                    for (AuditEventBase evt : this.mUncommitted) {
                        if (evt == event) continue;
                        this.logFailedEvent(evt);
                    }
                }
                this.mUncommitted.clear();
            }
        }
        return ret;
    }

    private void logDbError(String msg, Exception excp) {
        long now = System.currentTimeMillis();
        if (now - this.mLastDbFailedTime > (long)this.mDbRetryMinIntervalMs) {
            this.mLastDbFailedTime = now;
        }
        LOG.warn(msg, excp);
    }

    private String getCredentialString(String url, String alias) {
        char[] cred;
        String ret = null;
        if (url != null && alias != null && (cred = RangerCredentialProvider.getInstance().getCredentialString(url, alias)) != null) {
            ret = new String(cred);
        }
        return ret;
    }
}

