/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.audit.provider.AuditMessageException;
import org.apache.ranger.audit.provider.DebugTracer;
import org.apache.ranger.audit.provider.LocalFileLogBuffer;
import org.apache.ranger.audit.provider.LogDestination;
import org.apache.ranger.audit.provider.MiscUtil;

class DestinationDispatcherThread<T>
extends Thread {
    private TreeSet<String> mCompletedLogfiles = new TreeSet();
    private boolean mStopThread = false;
    private LocalFileLogBuffer<T> mFileLogBuffer = null;
    private LogDestination<T> mDestination = null;
    private DebugTracer mLogger = null;
    private String mCurrentLogfile = null;

    public DestinationDispatcherThread(LocalFileLogBuffer<T> fileLogBuffer, LogDestination<T> destination, DebugTracer tracer) {
        super(DestinationDispatcherThread.class.getSimpleName() + "-" + System.currentTimeMillis());
        this.mLogger = tracer;
        this.mFileLogBuffer = fileLogBuffer;
        this.mDestination = destination;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogfile(String filename) {
        this.mLogger.debug("==> DestinationDispatcherThread.addLogfile(" + filename + ")");
        if (filename != null) {
            TreeSet<String> treeSet = this.mCompletedLogfiles;
            synchronized (treeSet) {
                this.mCompletedLogfiles.add(filename);
                this.mCompletedLogfiles.notify();
            }
        }
        this.mLogger.debug("<== DestinationDispatcherThread.addLogfile(" + filename + ")");
    }

    public void stopThread() {
        this.mStopThread = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        TreeSet<String> treeSet = this.mCompletedLogfiles;
        synchronized (treeSet) {
            return this.mCompletedLogfiles.isEmpty() && this.mCurrentLogfile == null;
        }
    }

    @Override
    public void run() {
        UserGroupInformation loginUser = null;
        try {
            loginUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException excp) {
            this.mLogger.error("DestinationDispatcherThread.run(): failed to get login user details. Audit files will not be sent to HDFS destination", excp);
        }
        if (loginUser == null) {
            this.mLogger.error("DestinationDispatcherThread.run(): failed to get login user. Audit files will not be sent to HDFS destination");
            return;
        }
        loginUser.doAs(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                DestinationDispatcherThread.this.doRun();
                return 0;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        this.init();
        this.mDestination.start();
        long pollIntervalInMs = 1000L;
        while (!this.mStopThread) {
            TreeSet<String> treeSet = this.mCompletedLogfiles;
            synchronized (treeSet) {
                while (this.mCompletedLogfiles.isEmpty() && !this.mStopThread) {
                    try {
                        this.mCompletedLogfiles.wait(pollIntervalInMs);
                    }
                    catch (InterruptedException excp) {
                        throw new RuntimeException("DestinationDispatcherThread.run(): failed to wait for log file", excp);
                    }
                }
                this.mCurrentLogfile = this.mCompletedLogfiles.pollFirst();
            }
            if (this.mCurrentLogfile == null) continue;
            this.sendCurrentFile();
        }
        this.mDestination.stop();
    }

    private void init() {
        File[] files;
        File directory;
        this.mLogger.debug("==> DestinationDispatcherThread.init()");
        String dirName = MiscUtil.replaceTokens(this.mFileLogBuffer.getDirectory(), 0L);
        if (dirName != null && (directory = new File(dirName)).exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                String filename;
                if (!file.exists() || !file.isFile() || !file.canRead() || this.mFileLogBuffer.isCurrentFilename(filename = file.getAbsolutePath())) continue;
                this.addLogfile(filename);
            }
        }
        this.mLogger.debug("<== DestinationDispatcherThread.init()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendCurrentFile() {
        this.mLogger.debug("==> DestinationDispatcherThread.sendCurrentFile()");
        boolean ret = false;
        long destinationPollIntervalInMs = 1000L;
        BufferedReader reader = this.openCurrentFile();
        try {
            while (!this.mStopThread) {
                String log = this.getNextStringifiedLog(reader);
                if (log == null) {
                    ret = true;
                    break;
                }
                try {
                    while (!this.mStopThread && !this.mDestination.sendStringified(log)) {
                        try {
                            Thread.sleep(destinationPollIntervalInMs);
                        }
                        catch (InterruptedException excp) {
                            throw new RuntimeException("LocalFileLogBuffer.sendCurrentFile(" + this.mCurrentLogfile + "): failed while waiting for destination to be available", excp);
                        }
                    }
                }
                catch (AuditMessageException msgError) {
                    this.mLogger.error("Error in log message:" + log);
                }
            }
        }
        finally {
            this.closeCurrentFile(reader);
        }
        if (!this.mStopThread) {
            this.mDestination.flush();
            this.archiveCurrentFile();
        }
        this.mLogger.debug("<== DestinationDispatcherThread.sendCurrentFile()");
        return ret;
    }

    private String getNextStringifiedLog(BufferedReader mReader) {
        String log = null;
        if (mReader != null) {
            try {
                String line;
                while ((line = mReader.readLine()) != null) {
                    if (line.endsWith("\\")) {
                        line = line.substring(0, line.length() - "\\".length());
                        if (log == null) {
                            log = line;
                            continue;
                        }
                        log = log + MiscUtil.LINE_SEPARATOR;
                        log = log + line;
                        continue;
                    }
                    log = log == null ? line : log + line;
                    break;
                }
            }
            catch (IOException excp) {
                this.mLogger.warn("getNextStringifiedLog.getNextLog(): failed to read from file " + this.mCurrentLogfile, excp);
            }
        }
        return log;
    }

    private BufferedReader openCurrentFile() {
        this.mLogger.debug("==> openCurrentFile(" + this.mCurrentLogfile + ")");
        BufferedReader mReader = null;
        if (this.mCurrentLogfile != null) {
            try {
                FileInputStream inStr = new FileInputStream(this.mCurrentLogfile);
                InputStreamReader strReader = this.createReader(inStr);
                if (strReader != null) {
                    mReader = new BufferedReader(strReader);
                }
            }
            catch (FileNotFoundException excp) {
                this.mLogger.warn("openNextFile(): error while opening file " + this.mCurrentLogfile, excp);
            }
        }
        this.mLogger.debug("<== openCurrentFile(" + this.mCurrentLogfile + ")");
        return mReader;
    }

    private void closeCurrentFile(BufferedReader mReader) {
        this.mLogger.debug("==> closeCurrentFile(" + this.mCurrentLogfile + ")");
        if (mReader != null) {
            try {
                mReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mLogger.debug("<== closeCurrentFile(" + this.mCurrentLogfile + ")");
    }

    private void archiveCurrentFile() {
        if (this.mCurrentLogfile != null) {
            File logFile = new File(this.mCurrentLogfile);
            String archiveDirName = MiscUtil.replaceTokens(this.mFileLogBuffer.getArchiveDirectory(), 0L);
            String archiveFilename = archiveDirName + File.separator + logFile.getName();
            try {
                if (logFile.exists()) {
                    File archiveDir;
                    File[] files;
                    int numOfFilesToDelete;
                    File archiveFile = new File(archiveFilename);
                    MiscUtil.createParents(archiveFile);
                    if (!logFile.renameTo(archiveFile)) {
                        this.mLogger.warn("archiving failed to move file: " + this.mCurrentLogfile + " ==> " + archiveFilename);
                    }
                    int n = numOfFilesToDelete = (files = (archiveDir = new File(archiveDirName)).listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isFile();
                        }
                    })) == null ? 0 : files.length - this.mFileLogBuffer.getArchiveFileCount();
                    if (numOfFilesToDelete > 0) {
                        Arrays.sort(files, new Comparator<File>(){

                            @Override
                            public int compare(File f1, File f2) {
                                return (int)(f1.lastModified() - f2.lastModified());
                            }
                        });
                        for (int i = 0; i < numOfFilesToDelete; ++i) {
                            if (files[i].delete()) continue;
                            this.mLogger.warn("archiving failed to delete file: " + files[i].getAbsolutePath());
                        }
                    }
                }
            }
            catch (Exception excp) {
                this.mLogger.warn("archiveCurrentFile(): faile to move " + this.mCurrentLogfile + " to archive location " + archiveFilename, excp);
            }
        }
        this.mCurrentLogfile = null;
    }

    private InputStreamReader createReader(InputStream iStr) {
        InputStreamReader reader = null;
        if (iStr != null) {
            String encoding = this.mFileLogBuffer.getEncoding();
            if (encoding != null) {
                try {
                    reader = new InputStreamReader(iStr, encoding);
                }
                catch (UnsupportedEncodingException excp) {
                    this.mLogger.warn("createReader(): failed to create input reader.", excp);
                }
            }
            if (reader == null) {
                reader = new InputStreamReader(iStr);
            }
        }
        return reader;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DestinationDispatcherThread {");
        sb.append("ThreadName=").append(this.getName()).append("; ");
        sb.append("CompletedLogfiles.size()=").append(this.mCompletedLogfiles.size()).append("; ");
        sb.append("StopThread=").append(this.mStopThread).append("; ");
        sb.append("CurrentLogfile=").append(this.mCurrentLogfile);
        sb.append("}");
        return sb.toString();
    }
}

