/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider.hdfs;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.BufferedAuditProvider;
import org.apache.ranger.audit.provider.LocalFileLogBuffer;
import org.apache.ranger.audit.provider.Log4jTracer;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.provider.hdfs.HdfsLogDestination;

public class HdfsAuditProvider
extends BufferedAuditProvider {
    private static final Log LOG = LogFactory.getLog(HdfsAuditProvider.class);
    public static final String AUDIT_HDFS_IS_ASYNC_PROP = "xasecure.audit.hdfs.is.async";
    public static final String AUDIT_HDFS_MAX_QUEUE_SIZE_PROP = "xasecure.audit.hdfs.async.max.queue.size";
    public static final String AUDIT_HDFS_MAX_FLUSH_INTERVAL_PROP = "xasecure.audit.hdfs.async.max.flush.interval.ms";

    @Override
    public void init(Properties props) {
        LOG.info("HdfsAuditProvider.init()");
        super.init(props);
        Map<String, String> hdfsProps = MiscUtil.getPropertiesWithPrefix(props, "xasecure.audit.hdfs.config.");
        String encoding = hdfsProps.get("encoding");
        String hdfsDestinationDirectory = hdfsProps.get("destination.directory");
        String hdfsDestinationFile = hdfsProps.get("destination.file");
        int hdfsDestinationFlushIntervalSeconds = MiscUtil.parseInteger(hdfsProps.get("destination.flush.interval.seconds"), 900);
        int hdfsDestinationRolloverIntervalSeconds = MiscUtil.parseInteger(hdfsProps.get("destination.rollover.interval.seconds"), 86400);
        int hdfsDestinationOpenRetryIntervalSeconds = MiscUtil.parseInteger(hdfsProps.get("destination.open.retry.interval.seconds"), 60);
        String localFileBufferDirectory = hdfsProps.get("local.buffer.directory");
        String localFileBufferFile = hdfsProps.get("local.buffer.file");
        int localFileBufferFlushIntervalSeconds = MiscUtil.parseInteger(hdfsProps.get("local.buffer.flush.interval.seconds"), 60);
        int localFileBufferFileBufferSizeBytes = MiscUtil.parseInteger(hdfsProps.get("local.buffer.file.buffer.size.bytes"), 8192);
        int localFileBufferRolloverIntervalSeconds = MiscUtil.parseInteger(hdfsProps.get("local.buffer.rollover.interval.seconds"), 600);
        String localFileBufferArchiveDirectory = hdfsProps.get("local.archive.directory");
        int localFileBufferArchiveFileCount = MiscUtil.parseInteger(hdfsProps.get("local.archive.max.file.count"), 10);
        Map<String, String> configProps = MiscUtil.getPropertiesWithPrefix(props, "xasecure.audit.destination.hdfs.config.");
        Log4jTracer tracer = new Log4jTracer(LOG);
        HdfsLogDestination<AuditEventBase> mHdfsDestination = new HdfsLogDestination<AuditEventBase>(tracer);
        mHdfsDestination.setDirectory(hdfsDestinationDirectory);
        mHdfsDestination.setFile(hdfsDestinationFile);
        mHdfsDestination.setFlushIntervalSeconds(hdfsDestinationFlushIntervalSeconds);
        mHdfsDestination.setEncoding(encoding);
        mHdfsDestination.setRolloverIntervalSeconds(hdfsDestinationRolloverIntervalSeconds);
        mHdfsDestination.setOpenRetryIntervalSeconds(hdfsDestinationOpenRetryIntervalSeconds);
        mHdfsDestination.setConfigProps(configProps);
        LocalFileLogBuffer<AuditEventBase> mLocalFileBuffer = new LocalFileLogBuffer<AuditEventBase>(tracer);
        mLocalFileBuffer.setDirectory(localFileBufferDirectory);
        mLocalFileBuffer.setFile(localFileBufferFile);
        mLocalFileBuffer.setFlushIntervalSeconds(localFileBufferFlushIntervalSeconds);
        mLocalFileBuffer.setFileBufferSizeBytes(localFileBufferFileBufferSizeBytes);
        mLocalFileBuffer.setEncoding(encoding);
        mLocalFileBuffer.setRolloverIntervalSeconds(localFileBufferRolloverIntervalSeconds);
        mLocalFileBuffer.setArchiveDirectory(localFileBufferArchiveDirectory);
        mLocalFileBuffer.setArchiveFileCount(localFileBufferArchiveFileCount);
        this.setBufferAndDestination(mLocalFileBuffer, mHdfsDestination);
    }
}

