/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import java.net.URL;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.ranger.authorization.hadoop.config.RangerLegacyConfigBuilder;

public class RangerConfiguration
extends Configuration {
    private static final Logger LOG = Logger.getLogger(RangerConfiguration.class);
    private static volatile RangerConfiguration config;

    private RangerConfiguration() {
        super(false);
    }

    public void addResourcesForServiceType(String serviceType) {
        String auditCfg = "ranger-" + serviceType + "-audit.xml";
        String securityCfg = "ranger-" + serviceType + "-security.xml";
        if (!this.addResourceIfReadable(auditCfg)) {
            this.addAuditResource(serviceType);
        }
        if (!this.addResourceIfReadable(securityCfg)) {
            this.addSecurityResource(serviceType);
        }
    }

    public boolean addAdminResources() {
        String defaultCfg = "ranger-admin-default-site.xml";
        String addlCfg = "ranger-admin-site.xml";
        String coreCfg = "core-site.xml";
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addAdminResources()");
        }
        boolean ret = true;
        if (!this.addResourceIfReadable(defaultCfg)) {
            ret = false;
        }
        if (!this.addResourceIfReadable(addlCfg)) {
            ret = false;
        }
        if (!this.addResourceIfReadable(coreCfg)) {
            ret = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addAdminResources(), result=" + ret);
        }
        return ret;
    }

    public boolean addResourceIfReadable(String aResourceName) {
        URL fUrl;
        boolean ret = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addResourceIfReadable(" + aResourceName + ")");
        }
        if ((fUrl = this.getFileLocation(aResourceName)) != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("addResourceIfReadable(" + aResourceName + "): resource file is " + fUrl);
            }
            try {
                this.addResource(fUrl);
                ret = true;
            }
            catch (Exception e) {
                LOG.error("Unable to load the resource name [" + aResourceName + "]. Ignoring the resource:" + fUrl);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resource loading failed for " + fUrl, e);
                }
            }
        } else {
            LOG.error("addResourceIfReadable(" + aResourceName + "): couldn't find resource file location");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addResourceIfReadable(" + aResourceName + "), result=" + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RangerConfiguration getInstance() {
        RangerConfiguration result2 = config;
        if (result2 != null) return result2;
        Class<RangerConfiguration> clazz = RangerConfiguration.class;
        synchronized (RangerConfiguration.class) {
            result2 = config;
            if (result2 != null) return result2;
            config = result2 = new RangerConfiguration();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result2;
        }
    }

    public Properties getProperties() {
        return this.getProps();
    }

    private URL getFileLocation(String fileName) {
        URL lurl = RangerConfiguration.class.getClassLoader().getResource(fileName);
        if (lurl == null) {
            lurl = RangerConfiguration.class.getClassLoader().getResource("/" + fileName);
        }
        return lurl;
    }

    private void addSecurityResource(String serviceType) {
        Configuration rangerConf;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addSecurityResource(Service Type: " + serviceType);
        }
        if ((rangerConf = RangerLegacyConfigBuilder.getSecurityConfig(serviceType)) != null) {
            this.addResource(rangerConf);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to add the Security Config for " + serviceType + ". Plugin won't be enabled!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<= addSecurityResource(Service Type: " + serviceType);
        }
    }

    private void addAuditResource(String serviceType) {
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> addAuditResource(Service Type: " + serviceType);
            }
            try {
                URL url = RangerLegacyConfigBuilder.getAuditConfig(serviceType);
                if (url != null) {
                    this.addResource(url);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("==> addAuditResource() URL" + url.getPath());
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn(" Unable to find Audit Config for " + serviceType + " Auditing not enabled !");
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug(" Unable to find Audit Config for " + serviceType + " Auditing not enabled !" + t);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addAuditResource(Service Type: " + serviceType + ")");
        }
    }
}

