/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerServiceResourceMatcher;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.contextenricher.RangerTagRetriever;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerResourceTrie;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.ServiceTags;

public class RangerTagEnricher
extends RangerAbstractContextEnricher {
    private static final Log LOG = LogFactory.getLog(RangerTagEnricher.class);
    private static final Log PERF_CONTEXTENRICHER_INIT_LOG = RangerPerfTracer.getPerfLogger("contextenricher.init");
    private static final Log PERF_TRIE_OP_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.retrieval");
    public static final String TAG_REFRESHER_POLLINGINTERVAL_OPTION = "tagRefresherPollingInterval";
    public static final String TAG_RETRIEVER_CLASSNAME_OPTION = "tagRetrieverClassName";
    public static final String TAG_DISABLE_TRIE_PREFILTER_OPTION = "disableTrieLookupPrefilter";
    private RangerTagRefresher tagRefresher;
    private RangerTagRetriever tagRetriever;
    private boolean disableTrieLookupPrefilter;
    private EnrichedServiceTags enrichedServiceTags;
    private boolean disableCacheIfServiceNotFound = true;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.init()");
        }
        super.init();
        String tagRetrieverClassName = this.getOption(TAG_RETRIEVER_CLASSNAME_OPTION);
        long pollingIntervalMs = this.getLongOption(TAG_REFRESHER_POLLINGINTERVAL_OPTION, 60000L);
        this.disableTrieLookupPrefilter = this.getBooleanOption(TAG_DISABLE_TRIE_PREFILTER_OPTION, false);
        if (StringUtils.isNotBlank(tagRetrieverClassName)) {
            try {
                Class<?> tagRetriverClass = Class.forName(tagRetrieverClassName);
                this.tagRetriever = (RangerTagRetriever)tagRetriverClass.newInstance();
            }
            catch (ClassNotFoundException exception) {
                LOG.error("Class " + tagRetrieverClassName + " not found, exception=" + exception);
            }
            catch (ClassCastException exception) {
                LOG.error("Class " + tagRetrieverClassName + " is not a type of RangerTagRetriever, exception=" + exception);
            }
            catch (IllegalAccessException exception) {
                LOG.error("Class " + tagRetrieverClassName + " illegally accessed, exception=" + exception);
            }
            catch (InstantiationException exception) {
                LOG.error("Class " + tagRetrieverClassName + " could not be instantiated, exception=" + exception);
            }
            if (this.tagRetriever != null) {
                String propertyPrefix = "ranger.plugin." + this.serviceDef.getName();
                this.disableCacheIfServiceNotFound = RangerConfiguration.getInstance().getBoolean(propertyPrefix + ".disable.cache.if.servicenotfound", true);
                String cacheDir = RangerConfiguration.getInstance().get(propertyPrefix + ".policy.cache.dir");
                String cacheFilename = String.format("%s_%s_tag.json", this.appId, this.serviceName);
                cacheFilename = cacheFilename.replace(File.separatorChar, '_');
                cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
                String cacheFile = cacheDir == null ? null : cacheDir + File.separator + cacheFilename;
                this.tagRetriever.setServiceName(this.serviceName);
                this.tagRetriever.setServiceDef(this.serviceDef);
                this.tagRetriever.setAppId(this.appId);
                this.tagRetriever.init(this.enricherDef.getEnricherOptions());
                this.tagRefresher = new RangerTagRefresher(this.tagRetriever, this, -1L, cacheFile, pollingIntervalMs);
                try {
                    this.tagRefresher.populateTags();
                }
                catch (Throwable exception) {
                    LOG.error("Exception when retrieving tag for the first time for this enricher", exception);
                }
                this.tagRefresher.setDaemon(true);
                this.tagRefresher.startRefresher();
            }
        } else {
            LOG.error("No value specified for tagRetrieverClassName in the RangerTagEnricher options");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.init()");
        }
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.enrich(" + request + ")");
        }
        this.enrich(request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.enrich(" + request + ")");
        }
    }

    @Override
    public void enrich(RangerAccessRequest request, Object dataStore) {
        EnrichedServiceTags enrichedServiceTags;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.enrich(" + request + ") with dataStore:[" + dataStore + "]");
        }
        if (dataStore instanceof EnrichedServiceTags) {
            enrichedServiceTags = (EnrichedServiceTags)dataStore;
        } else {
            enrichedServiceTags = this.enrichedServiceTags;
            if (dataStore != null) {
                LOG.warn("Incorrect type of dataStore :[" + dataStore.getClass().getName() + "], falling back to original enrich");
            }
        }
        Set<RangerTagForEval> matchedTags = enrichedServiceTags == null ? null : this.findMatchingTags(request, enrichedServiceTags);
        RangerAccessRequestUtil.setRequestTagsInContext(request.getContext(), matchedTags);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.enrich(" + request + ") with dataStore:[" + dataStore + "]): tags count=" + (matchedTags == null ? 0 : matchedTags.size()));
        }
    }

    public void setServiceTags(ServiceTags serviceTags) {
        if (serviceTags == null || CollectionUtils.isEmpty(serviceTags.getServiceResources())) {
            LOG.info("ServiceTags is null or there are no tagged resources for service " + this.serviceName);
            this.enrichedServiceTags = null;
        } else {
            RangerAuthContext currentAuthContext;
            RangerBasePlugin plugin;
            ArrayList<RangerServiceResourceMatcher> resourceMatchers = new ArrayList<RangerServiceResourceMatcher>();
            RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(this.serviceDef, false);
            List<RangerServiceResource> serviceResources = serviceTags.getServiceResources();
            ResourceHierarchies hierarchies = new ResourceHierarchies();
            for (RangerServiceResource rangerServiceResource : serviceResources) {
                Set<String> set = rangerServiceResource.getResourceElements().keySet();
                for (int policyType : RangerPolicy.POLICY_TYPES) {
                    Boolean isValidHierarchy = hierarchies.isValidHierarchy(policyType, set);
                    if (isValidHierarchy == null) {
                        isValidHierarchy = Boolean.FALSE;
                        for (List<RangerServiceDef.RangerResourceDef> hierarchy : serviceDefHelper.getResourceHierarchies(policyType)) {
                            if (!serviceDefHelper.hierarchyHasAllResources(hierarchy, set)) continue;
                            isValidHierarchy = Boolean.TRUE;
                            break;
                        }
                        hierarchies.addHierarchy(policyType, set, isValidHierarchy);
                    }
                    if (!isValidHierarchy.booleanValue()) continue;
                    RangerDefaultPolicyResourceMatcher matcher = new RangerDefaultPolicyResourceMatcher();
                    matcher.setServiceDef(this.serviceDef);
                    matcher.setPolicyResources(rangerServiceResource.getResourceElements(), policyType);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("RangerTagEnricher.setServiceTags() - Initializing matcher with (resource=" + rangerServiceResource + ", serviceDef=" + this.serviceDef.getName() + ")");
                    }
                    matcher.setServiceDefHelper(serviceDefHelper);
                    matcher.init();
                    RangerServiceResourceMatcher serviceResourceMatcher = new RangerServiceResourceMatcher(rangerServiceResource, matcher);
                    resourceMatchers.add(serviceResourceMatcher);
                }
            }
            HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie = null;
            if (!this.disableTrieLookupPrefilter) {
                serviceResourceTrie = new HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>>();
                for (RangerServiceDef.RangerResourceDef rangerResourceDef : this.serviceDef.getResources()) {
                    serviceResourceTrie.put(rangerResourceDef.getName(), new RangerResourceTrie<RangerServiceResourceMatcher>(rangerResourceDef, resourceMatchers));
                }
            }
            HashSet<RangerTagForEval> hashSet = new HashSet<RangerTagForEval>();
            for (Map.Entry<Long, RangerTag> entry2 : serviceTags.getTags().entrySet()) {
                hashSet.add(new RangerTagForEval(entry2.getValue(), RangerPolicyResourceMatcher.MatchType.DESCENDANT));
            }
            this.enrichedServiceTags = new EnrichedServiceTags(serviceTags, resourceMatchers, serviceResourceTrie, hashSet);
            Map<String, RangerBasePlugin> map2 = RangerBasePlugin.getServicePluginMap();
            RangerBasePlugin rangerBasePlugin = plugin = map2 != null ? map2.get(this.getServiceName()) : null;
            if (plugin != null && (currentAuthContext = plugin.getCurrentRangerAuthContext()) != null) {
                currentAuthContext.addOrReplaceRequestContextEnricher(this, this.enrichedServiceTags);
                plugin.contextChanged();
            }
        }
    }

    protected Long getServiceTagsVersion() {
        return this.enrichedServiceTags != null ? this.enrichedServiceTags.getServiceTags().getTagVersion() : null;
    }

    @Override
    public boolean preCleanup() {
        boolean ret = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.preCleanup()");
        }
        if (this.tagRefresher != null) {
            this.tagRefresher.cleanup();
            this.tagRefresher = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.preCleanup() : result=" + ret);
        }
        return ret;
    }

    private Set<RangerTagForEval> findMatchingTags(RangerAccessRequest request, EnrichedServiceTags dataStore) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.findMatchingTags(" + request + ")");
        }
        EnrichedServiceTags enrichedServiceTags = dataStore != null ? dataStore : this.enrichedServiceTags;
        Set<RangerTagForEval> ret = null;
        RangerAccessResource resource = request.getResource();
        if ((resource == null || resource.getKeys() == null || resource.getKeys().isEmpty()) && request.isAccessTypeAny()) {
            ret = enrichedServiceTags.getTagsForEmptyResourceAndAnyAccess();
        } else {
            List<RangerServiceResourceMatcher> serviceResourceMatchers = this.getEvaluators(resource, enrichedServiceTags);
            if (CollectionUtils.isNotEmpty(serviceResourceMatchers)) {
                for (RangerServiceResourceMatcher resourceMatcher : serviceResourceMatchers) {
                    boolean isMatched;
                    RangerPolicyResourceMatcher.MatchType matchType = resourceMatcher.getMatchType(resource, request.getContext());
                    if (request.isAccessTypeAny()) {
                        isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
                    } else if (request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS) {
                        isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
                    } else {
                        boolean bl = isMatched = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR;
                    }
                    if (!isMatched) continue;
                    if (ret == null) {
                        ret = new HashSet<RangerTagForEval>();
                    }
                    ret.addAll(RangerTagEnricher.getTagsForServiceResource(enrichedServiceTags.getServiceTags(), resourceMatcher.getServiceResource(), matchType));
                }
            }
        }
        if (CollectionUtils.isEmpty(ret)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerTagEnricher.findMatchingTags(" + resource + ") - No tags Found ");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("RangerTagEnricher.findMatchingTags(" + resource + ") - " + ret.size() + " tags Found ");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.findMatchingTags(" + request + ")");
        }
        return ret;
    }

    private List<RangerServiceResourceMatcher> getEvaluators(RangerAccessResource resource, EnrichedServiceTags enrichedServiceTags) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerTagEnricher.getEvaluators(" + (resource != null ? resource.getAsString() : null) + ")");
        }
        List<RangerServiceResourceMatcher> ret = null;
        Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie = enrichedServiceTags.getServiceResourceTrie();
        if (resource == null || resource.getKeys() == null || resource.getKeys().isEmpty() || serviceResourceTrie == null) {
            ret = enrichedServiceTags.getServiceResourceMatchers();
        } else {
            RangerPerfTracer perf = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
                perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerTagEnricher.getEvaluators(resource=" + resource.getAsString() + ")");
            }
            Set<String> resourceKeys = resource.getKeys();
            ArrayList<List<RangerServiceResourceMatcher>> serviceResourceMatchersList = null;
            List<RangerServiceResourceMatcher> smallestList = null;
            if (CollectionUtils.isNotEmpty(resourceKeys)) {
                for (String string2 : resourceKeys) {
                    RangerResourceTrie<RangerServiceResourceMatcher> trie = serviceResourceTrie.get(string2);
                    if (trie == null) continue;
                    List<RangerServiceResourceMatcher> serviceResourceMatchers = trie.getEvaluatorsForResource(resource.getValue(string2));
                    if (CollectionUtils.isEmpty(serviceResourceMatchers)) {
                        serviceResourceMatchersList = null;
                        smallestList = null;
                        break;
                    }
                    if (smallestList == null) {
                        smallestList = serviceResourceMatchers;
                        continue;
                    }
                    if (serviceResourceMatchersList == null) {
                        serviceResourceMatchersList = new ArrayList<List<RangerServiceResourceMatcher>>();
                        serviceResourceMatchersList.add(smallestList);
                    }
                    serviceResourceMatchersList.add(serviceResourceMatchers);
                    if (smallestList.size() <= serviceResourceMatchers.size()) continue;
                    smallestList = serviceResourceMatchers;
                }
                if (serviceResourceMatchersList != null) {
                    ret = new ArrayList(smallestList);
                    for (List list : serviceResourceMatchersList) {
                        if (list == smallestList) continue;
                        ret.retainAll(list);
                        if (!CollectionUtils.isEmpty(ret)) continue;
                        ret = null;
                        break;
                    }
                } else {
                    ret = smallestList;
                }
            }
            RangerPerfTracer.logAlways(perf);
        }
        if (ret == null) {
            ret = Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerTagEnricher.getEvaluators(" + (resource != null ? resource.getAsString() : null) + "): evaluatorCount=" + ret.size());
        }
        return ret;
    }

    private static Set<RangerTagForEval> getTagsForServiceResource(ServiceTags serviceTags, RangerServiceResource serviceResource, RangerPolicyResourceMatcher.MatchType matchType) {
        List<Long> tagIds;
        HashSet<RangerTagForEval> ret = new HashSet<RangerTagForEval>();
        Long resourceId = serviceResource.getId();
        Map<Long, List<Long>> resourceToTagIds = serviceTags.getResourceToTagIds();
        Map<Long, RangerTag> tags = serviceTags.getTags();
        if (resourceId != null && MapUtils.isNotEmpty(resourceToTagIds) && MapUtils.isNotEmpty(tags) && CollectionUtils.isNotEmpty(tagIds = resourceToTagIds.get(resourceId))) {
            for (Long tagId : tagIds) {
                RangerTag tag = tags.get(tagId);
                if (tag == null) continue;
                ret.add(new RangerTagForEval(tag, matchType));
            }
        }
        return ret;
    }

    static class RangerTagRefresher
    extends Thread {
        private static final Log LOG = LogFactory.getLog(RangerTagRefresher.class);
        private final RangerTagRetriever tagRetriever;
        private final RangerTagEnricher tagEnricher;
        private long lastKnownVersion = -1L;
        private long lastActivationTimeInMillis;
        private final long pollingIntervalMs;
        private final String cacheFile;
        private boolean hasProvidedTagsToReceiver;
        private Gson gson;

        final long getPollingIntervalMs() {
            return this.pollingIntervalMs;
        }

        RangerTagRefresher(RangerTagRetriever tagRetriever, RangerTagEnricher tagEnricher, long lastKnownVersion, String cacheFile, long pollingIntervalMs) {
            this.tagRetriever = tagRetriever;
            this.tagEnricher = tagEnricher;
            this.lastKnownVersion = lastKnownVersion;
            this.cacheFile = cacheFile;
            this.pollingIntervalMs = pollingIntervalMs;
            try {
                this.gson = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
            }
            catch (Throwable excp) {
                LOG.fatal("failed to create GsonBuilder object", excp);
            }
        }

        public long getLastActivationTimeInMillis() {
            return this.lastActivationTimeInMillis;
        }

        public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
            this.lastActivationTimeInMillis = lastActivationTimeInMillis;
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerTagRefresher(pollingIntervalMs=" + this.pollingIntervalMs + ").run()");
            }
            try {
                while (this.pollingIntervalMs > 0L) {
                    Thread.sleep(this.pollingIntervalMs);
                    RangerPerfTracer perf = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_INIT_LOG)) {
                        perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_INIT_LOG, "RangerTagRefresher.populateTags(serviceName=" + this.tagRetriever.getServiceName() + ",lastKnownVersion=" + this.lastKnownVersion + ")");
                    }
                    this.populateTags();
                    RangerPerfTracer.log(perf);
                }
            }
            catch (InterruptedException excp) {
                LOG.debug("RangerTagRefresher(pollingIntervalMs=" + this.pollingIntervalMs + ").run() : interrupted! Exiting thread", excp);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerTagRefresher().run()");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void populateTags() throws InterruptedException {
            if (this.tagEnricher != null) {
                ServiceTags serviceTags = null;
                try {
                    serviceTags = this.tagRetriever.retrieveTags(this.lastKnownVersion, this.lastActivationTimeInMillis);
                    if (serviceTags == null) {
                        if (!this.hasProvidedTagsToReceiver) {
                            serviceTags = this.loadFromCache();
                        }
                    } else {
                        this.saveToCache(serviceTags);
                    }
                    if (serviceTags != null) {
                        this.tagEnricher.setServiceTags(serviceTags);
                        LOG.info("RangerTagRefresher.populateTags() - Updated tags-cache to new version of tags, lastKnownVersion=" + this.lastKnownVersion + "; newVersion=" + (serviceTags.getTagVersion() == null ? -1L : serviceTags.getTagVersion()));
                        this.hasProvidedTagsToReceiver = true;
                        this.lastKnownVersion = serviceTags.getTagVersion() == null ? -1L : serviceTags.getTagVersion();
                        this.setLastActivationTimeInMillis(System.currentTimeMillis());
                        return;
                    }
                    if (!LOG.isDebugEnabled()) return;
                    LOG.debug("RangerTagRefresher.populateTags() - No need to update tags-cache. lastKnownVersion=" + this.lastKnownVersion);
                    return;
                }
                catch (RangerServiceNotFoundException snfe) {
                    LOG.error("Caught ServiceNotFound exception :", snfe);
                    if (!this.tagEnricher.disableCacheIfServiceNotFound) return;
                    this.disableCache();
                    this.tagEnricher.setServiceTags(null);
                    this.setLastActivationTimeInMillis(System.currentTimeMillis());
                    this.lastKnownVersion = -1L;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception e) {
                    LOG.error("Encountered unexpected exception. Ignoring", e);
                    return;
                }
            } else {
                LOG.error("RangerTagRefresher.populateTags() - no tag receiver to update tag-cache");
            }
        }

        void cleanup() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerTagRefresher.cleanup()");
            }
            this.stopRefresher();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerTagRefresher.cleanup()");
            }
        }

        final void startRefresher() {
            try {
                super.start();
            }
            catch (Exception excp) {
                LOG.error("RangerTagRefresher.startRetriever() - failed to start, exception=" + excp);
            }
        }

        private void stopRefresher() {
            if (super.isAlive()) {
                super.interrupt();
                try {
                    super.join();
                }
                catch (InterruptedException excp) {
                    LOG.error("RangerTagRefresher(): error while waiting for thread to exit", excp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        final ServiceTags loadFromCache() {
            serviceTags = null;
            if (RangerTagRefresher.LOG.isDebugEnabled()) {
                RangerTagRefresher.LOG.debug("==> RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").loadFromCache()");
            }
            v0 = cacheFile = StringUtils.isEmpty(this.cacheFile) != false ? null : new File(this.cacheFile);
            if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
                reader = null;
                try {
                    reader = new FileReader(cacheFile);
                    serviceTags = this.gson.fromJson((Reader)reader, ServiceTags.class);
                    if (serviceTags == null || StringUtils.equals(this.tagEnricher.getServiceName(), serviceTags.getServiceName())) ** GOTO lbl26
                    RangerTagRefresher.LOG.warn("ignoring unexpected serviceName '" + serviceTags.getServiceName() + "' in cache file '" + cacheFile.getAbsolutePath() + "'");
                    serviceTags.setServiceName(this.tagEnricher.getServiceName());
                }
                catch (Exception excp) {
                    RangerTagRefresher.LOG.error("failed to load service-tags from cache file " + cacheFile.getAbsolutePath(), excp);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception excp) {
                            RangerTagRefresher.LOG.error("error while closing opened cache file " + cacheFile.getAbsolutePath(), excp);
                        }
                    }
                }
            } else {
                RangerTagRefresher.LOG.warn("cache file does not exist or not readable '" + (cacheFile == null ? null : cacheFile.getAbsolutePath()) + "'");
            }
lbl26:
            // 4 sources

            if (RangerTagRefresher.LOG.isDebugEnabled()) {
                RangerTagRefresher.LOG.debug("<== RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").loadFromCache()");
            }
            return serviceTags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void saveToCache(ServiceTags serviceTags) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").saveToCache()");
            }
            if (serviceTags != null) {
                File cacheFile;
                File file = cacheFile = StringUtils.isEmpty(this.cacheFile) ? null : new File(this.cacheFile);
                if (cacheFile != null) {
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(cacheFile);
                        this.gson.toJson((Object)serviceTags, (Appendable)writer);
                    }
                    catch (Exception excp) {
                        LOG.error("failed to save service-tags to cache file '" + cacheFile.getAbsolutePath() + "'", excp);
                    }
                    finally {
                        if (writer != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Exception excp) {
                                LOG.error("error while closing opened cache file '" + cacheFile.getAbsolutePath() + "'", excp);
                            }
                        }
                    }
                }
            } else {
                LOG.info("service-tags is null. Nothing to save in cache");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").saveToCache()");
            }
        }

        final void disableCache() {
            File cacheFile;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerTagRetriever.disableCache(serviceName=" + this.tagEnricher.getServiceName() + ")");
            }
            File file = cacheFile = StringUtils.isEmpty(this.cacheFile) ? null : new File(this.cacheFile);
            if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
                LOG.warn("Cleaning up local tags cache");
                String renamedCacheFile = cacheFile.getAbsolutePath() + "_" + System.currentTimeMillis();
                if (!cacheFile.renameTo(new File(renamedCacheFile))) {
                    LOG.error("Failed to move " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile);
                } else {
                    LOG.warn("moved " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No local TAGS cache found. No need to disable it!");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== RangerTagRetriever.disableCache(serviceName=" + this.tagEnricher.getServiceName() + ")");
            }
        }
    }

    private static final class EnrichedServiceTags {
        private final ServiceTags serviceTags;
        private final List<RangerServiceResourceMatcher> serviceResourceMatchers;
        private final Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie;
        private final Set<RangerTagForEval> tagsForEmptyResourceAndAnyAccess;

        EnrichedServiceTags(ServiceTags serviceTags, List<RangerServiceResourceMatcher> serviceResourceMatchers, Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie, Set<RangerTagForEval> tagsForEmptyResourceAndAnyAccess) {
            this.serviceTags = serviceTags;
            this.serviceResourceMatchers = serviceResourceMatchers;
            this.serviceResourceTrie = serviceResourceTrie;
            this.tagsForEmptyResourceAndAnyAccess = tagsForEmptyResourceAndAnyAccess;
        }

        ServiceTags getServiceTags() {
            return this.serviceTags;
        }

        List<RangerServiceResourceMatcher> getServiceResourceMatchers() {
            return this.serviceResourceMatchers;
        }

        Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> getServiceResourceTrie() {
            return this.serviceResourceTrie;
        }

        Set<RangerTagForEval> getTagsForEmptyResourceAndAnyAccess() {
            return this.tagsForEmptyResourceAndAnyAccess;
        }
    }

    private static class ResourceHierarchies {
        private final Map<Collection<String>, Boolean> accessHierarchies = new HashMap<Collection<String>, Boolean>();
        private final Map<Collection<String>, Boolean> dataMaskHierarchies = new HashMap<Collection<String>, Boolean>();
        private final Map<Collection<String>, Boolean> rowFilterHierarchies = new HashMap<Collection<String>, Boolean>();

        private ResourceHierarchies() {
        }

        public Boolean isValidHierarchy(int policyType, Collection<String> resourceKeys) {
            switch (policyType) {
                case 0: {
                    return this.accessHierarchies.get(resourceKeys);
                }
                case 1: {
                    return this.dataMaskHierarchies.get(resourceKeys);
                }
                case 2: {
                    return this.rowFilterHierarchies.get(resourceKeys);
                }
            }
            return null;
        }

        public void addHierarchy(int policyType, Collection<String> resourceKeys, Boolean isValid) {
            switch (policyType) {
                case 0: {
                    this.accessHierarchies.put(resourceKeys, isValid);
                    break;
                }
                case 1: {
                    this.dataMaskHierarchies.put(resourceKeys, isValid);
                    break;
                }
                case 2: {
                    this.rowFilterHierarchies.put(resourceKeys, isValid);
                    break;
                }
                default: {
                    LOG.error("unknown policy-type " + policyType);
                }
            }
        }
    }
}

