/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public class RangerAccessResult {
    public static final String KEY_MASK_TYPE = "maskType";
    public static final String KEY_MASK_CONDITION = "maskCondition";
    public static final String KEY_MASKED_VALUE = "maskedValue";
    private static String KEY_FILTER_EXPR = "filterExpr";
    private final String serviceName;
    private final RangerServiceDef serviceDef;
    private final RangerAccessRequest request;
    private final int policyType;
    private boolean isAccessDetermined;
    private boolean isAllowed;
    private boolean isAuditedDetermined;
    private boolean isAudited;
    private long auditPolicyId = -1L;
    private long policyId = -1L;
    private int policyPriority;
    private long evaluatedPoliciesCount;
    private String reason;
    private Map<String, Object> additionalInfo;

    public RangerAccessResult(int policyType, String serviceName, RangerServiceDef serviceDef, RangerAccessRequest request) {
        this.serviceName = serviceName;
        this.serviceDef = serviceDef;
        this.request = request;
        this.policyType = policyType;
        this.isAccessDetermined = false;
        this.isAllowed = false;
        this.isAuditedDetermined = false;
        this.isAudited = false;
        this.auditPolicyId = -1L;
        this.policyId = -1L;
        this.policyPriority = 0;
        this.evaluatedPoliciesCount = 0L;
        this.reason = null;
    }

    public void setAccessResultFrom(RangerAccessResult other) {
        this.isAccessDetermined = other.getIsAccessDetermined();
        this.isAllowed = other.getIsAllowed();
        this.policyId = other.getPolicyId();
        this.policyPriority = other.getPolicyPriority();
        this.evaluatedPoliciesCount = other.evaluatedPoliciesCount;
        this.reason = other.getReason();
        this.additionalInfo = other.additionalInfo == null ? new HashMap<String, Object>() : new HashMap<String, Object>(other.additionalInfo);
    }

    public void setAuditResultFrom(RangerAccessResult other) {
        this.isAuditedDetermined = other.getIsAuditedDetermined();
        this.isAudited = other.getIsAudited();
        this.auditPolicyId = other.getAuditPolicyId();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    public RangerAccessRequest getAccessRequest() {
        return this.request;
    }

    public int getPolicyType() {
        return this.policyType;
    }

    public boolean getIsAccessDetermined() {
        return this.isAccessDetermined;
    }

    public void setIsAccessDetermined(boolean value2) {
        this.isAccessDetermined = value2;
    }

    public boolean getIsAllowed() {
        return this.isAllowed;
    }

    public void setIsAllowed(boolean isAllowed) {
        if (!isAllowed) {
            this.setIsAccessDetermined(true);
        }
        this.isAllowed = isAllowed;
    }

    public int getPolicyPriority() {
        return this.policyPriority;
    }

    public void setPolicyPriority(int policyPriority) {
        this.policyPriority = policyPriority;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean getIsAuditedDetermined() {
        return this.isAuditedDetermined;
    }

    private void setIsAuditedDetermined(boolean value2) {
        this.isAuditedDetermined = value2;
    }

    public boolean getIsAudited() {
        return this.isAudited;
    }

    public void setIsAudited(boolean isAudited) {
        this.setIsAuditedDetermined(true);
        this.isAudited = isAudited;
    }

    public String getReason() {
        return this.reason;
    }

    public long getPolicyId() {
        return this.policyId;
    }

    public long getAuditPolicyId() {
        return this.auditPolicyId;
    }

    public long getEvaluatedPoliciesCount() {
        return this.evaluatedPoliciesCount;
    }

    public void setPolicyId(long policyId) {
        this.policyId = policyId;
    }

    public void setAuditPolicyId(long policyId) {
        this.auditPolicyId = policyId;
    }

    public void incrementEvaluatedPoliciesCount() {
        ++this.evaluatedPoliciesCount;
    }

    public int getServiceType() {
        int ret = -1;
        if (this.serviceDef != null && this.serviceDef.getId() != null) {
            ret = this.serviceDef.getId().intValue();
        }
        return ret;
    }

    public void setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void addAdditionalInfo(String key, Object value2) {
        if (this.additionalInfo == null) {
            this.additionalInfo = new HashMap<String, Object>();
        }
        this.additionalInfo.put(key, value2);
    }

    public void removeAdditionalInfo(String key) {
        if (MapUtils.isNotEmpty(this.additionalInfo)) {
            this.additionalInfo.remove(key);
        }
    }

    public String getMaskType() {
        return this.additionalInfo == null ? null : (String)this.additionalInfo.get(KEY_MASK_TYPE);
    }

    public void setMaskType(String maskType) {
        this.addAdditionalInfo(KEY_MASK_TYPE, maskType);
    }

    public String getMaskCondition() {
        return this.additionalInfo == null ? null : (String)this.additionalInfo.get(KEY_MASK_CONDITION);
    }

    public void setMaskCondition(String maskCondition) {
        this.addAdditionalInfo(KEY_MASK_CONDITION, maskCondition);
    }

    public String getMaskedValue() {
        return this.additionalInfo == null ? null : (String)this.additionalInfo.get(KEY_MASKED_VALUE);
    }

    public void setMaskedValue(String maskedValue) {
        this.addAdditionalInfo(KEY_MASKED_VALUE, maskedValue);
    }

    public boolean isMaskEnabled() {
        return StringUtils.isNotEmpty(this.getMaskType()) && !StringUtils.equalsIgnoreCase(this.getMaskType(), "MASK_NONE");
    }

    public RangerServiceDef.RangerDataMaskTypeDef getMaskTypeDef() {
        RangerServiceDef.RangerDataMaskTypeDef ret = null;
        String maskType = this.getMaskType();
        if (StringUtils.isNotEmpty(maskType)) {
            ret = ServiceDefUtil.getDataMaskType(this.getServiceDef(), maskType);
        }
        return ret;
    }

    public String getFilterExpr() {
        return this.additionalInfo == null ? null : (String)this.additionalInfo.get(KEY_FILTER_EXPR);
    }

    public void setFilterExpr(String filterExpr) {
        this.addAdditionalInfo(KEY_FILTER_EXPR, filterExpr);
    }

    public boolean isRowFilterEnabled() {
        return StringUtils.isNotEmpty(this.getFilterExpr());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAccessResult={");
        sb.append("isAccessDetermined={").append(this.isAccessDetermined).append("} ");
        sb.append("isAllowed={").append(this.isAllowed).append("} ");
        sb.append("isAuditedDetermined={").append(this.isAuditedDetermined).append("} ");
        sb.append("isAudited={").append(this.isAudited).append("} ");
        sb.append("policyType={").append(this.policyType).append("} ");
        sb.append("policyId={").append(this.policyId).append("} ");
        sb.append("auditPolicyId={").append(this.auditPolicyId).append("} ");
        sb.append("evaluatedPoliciesCount={").append(this.evaluatedPoliciesCount).append("} ");
        sb.append("reason={").append(this.reason).append("} ");
        sb.append("additionalInfo={");
        if (this.additionalInfo != null) {
            for (Map.Entry<String, Object> entry2 : this.additionalInfo.entrySet()) {
                sb.append(entry2.getKey()).append("=").append(entry2.getValue()).append(", ");
            }
        }
        sb.append("}");
        sb.append("}");
        return sb;
    }
}

